/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.autologin;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserTracker;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.pwd.PwdEncryptor;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserTrackerLocalServiceUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AutoLoginFilter
extends BasePortalFilter {
    private static final String _PATH_CHAT_LATEST = "/-/chat/latest";
    private static Log _log = LogFactoryUtil.getLog(AutoLoginFilter.class);
    private static List<AutoLogin> _autoLogins = new CopyOnWriteArrayList<AutoLogin>();

    public static void registerAutoLogin(AutoLogin autoLogin) {
        _autoLogins.add(autoLogin);
    }

    public static void unregisterAutoLogin(AutoLogin autoLogin) {
        _autoLogins.remove(autoLogin);
    }

    public AutoLoginFilter() {
        String[] stringArray = PropsValues.AUTO_LOGIN_HOOKS;
        int n = PropsValues.AUTO_LOGIN_HOOKS.length;
        int n2 = 0;
        while (n2 < n) {
            String autoLoginClassName = stringArray[n2];
            AutoLogin autoLogin = (AutoLogin)InstancePool.get((String)autoLoginClassName);
            _autoLogins.add(autoLogin);
            ++n2;
        }
    }

    protected String getLoginRemoteUser(HttpServletRequest request, HttpServletResponse response, HttpSession session, String[] credentials) throws Exception {
        boolean encPassword;
        String jPassword;
        String jUsername;
        block10: {
            UserTracker userTracker;
            long userId;
            block11: {
                if (credentials == null || credentials.length != 3) {
                    return null;
                }
                jUsername = credentials[0];
                jPassword = credentials[1];
                encPassword = GetterUtil.getBoolean((String)credentials[2]);
                if (Validator.isNull((String)jUsername) || Validator.isNull((String)jPassword)) {
                    return null;
                }
                try {
                    userId = GetterUtil.getLong((String)jUsername);
                    if (userId <= 0L) break block10;
                    User user = UserLocalServiceUtil.getUserById((long)userId);
                    if (!user.isLockout()) break block11;
                    return null;
                }
                catch (NoSuchUserException noSuchUserException) {
                    return null;
                }
            }
            if (PropsValues.LIVE_USERS_ENABLED && (userTracker = UserTrackerLocalServiceUtil.fetchUserTracker((long)userId)) == null && session.getAttribute("USER") == null) {
                session.invalidate();
                return null;
            }
        }
        return null;
        session.setAttribute("j_username", (Object)jUsername);
        if (encPassword) {
            session.setAttribute("j_password", (Object)jPassword);
        } else {
            session.setAttribute("j_password", (Object)PwdEncryptor.encrypt(jPassword));
            if (PropsValues.SESSION_STORE_PASSWORD) {
                session.setAttribute("USER_PASSWORD", (Object)jPassword);
            }
        }
        session.setAttribute("j_remoteuser", (Object)jUsername);
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            response.sendRedirect(String.valueOf(PortalUtil.getPathMain()) + "/portal/touch_protected");
        }
        return jUsername;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        HttpSession session = request.getSession();
        String host = PortalUtil.getHost((HttpServletRequest)request);
        if (PortalInstances.isAutoLoginIgnoreHost(host)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore host " + host));
            }
            this.processFilter(AutoLoginFilter.class, request, response, filterChain);
            return;
        }
        String contextPath = PortalUtil.getPathContext();
        String path = request.getRequestURI().toLowerCase();
        if (!contextPath.equals("/") && path.indexOf(contextPath) != -1) {
            path = path.substring(contextPath.length());
        }
        if (PortalInstances.isAutoLoginIgnorePath(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore path " + path));
            }
            this.processFilter(AutoLoginFilter.class, request, response, filterChain);
            return;
        }
        String remoteUser = request.getRemoteUser();
        String jUserName = (String)session.getAttribute("j_username");
        if (!PropsValues.AUTH_LOGIN_DISABLED && remoteUser == null && jUserName == null) {
            for (AutoLogin autoLogin : _autoLogins) {
                try {
                    String[] credentials = autoLogin.login(request, response);
                    String redirect = (String)request.getAttribute("AUTO_LOGIN_REDIRECT");
                    if (Validator.isNotNull((String)redirect)) {
                        response.sendRedirect(redirect);
                        return;
                    }
                    String loginRemoteUser = this.getLoginRemoteUser(request, response, session, credentials);
                    if (loginRemoteUser == null) continue;
                    request = new ProtectedServletRequest(request, loginRemoteUser);
                    if (PropsValues.PORTAL_JAAS_ENABLE) {
                        return;
                    }
                    redirect = (String)request.getAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE");
                    if (!Validator.isNotNull((String)redirect)) continue;
                    response.sendRedirect(redirect);
                    break;
                }
                catch (Exception e2) {
                    String currentURL;
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                    if ((currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request)).endsWith(_PATH_CHAT_LATEST)) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Current URL " + currentURL + " generates exception: " + e2.getMessage()));
                        continue;
                    }
                    _log.error((Object)("Current URL " + currentURL + " generates exception: " + e2.getMessage()));
                }
            }
        }
        this.processFilter(AutoLoginFilter.class, request, response, filterChain);
    }
}

