/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.servlet.filters.CacheResponseUtil;
import java.io.File;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicCSSFilter
extends BasePortalFilter {
    public static final boolean ENABLED = GetterUtil.getBoolean((String)PropsUtil.get(DynamicCSSFilter.class.getName()));
    private static final String _CSS_EXTENSION = ".css";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + "/liferay/css";
    private static Log _log = LogFactoryUtil.getLog(DynamicCSSFilter.class);
    private ServletContext _servletContext;
    private String _servletContextName;
    private String _tempDir = _TEMP_DIR;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        this._servletContextName = GetterUtil.getString((String)this._servletContext.getServletContextName());
        if (Validator.isNull((String)this._servletContextName)) {
            this._tempDir = String.valueOf(this._tempDir) + "/portal";
        }
        DynamicCSSUtil.init();
    }

    protected String getCacheFileName(HttpServletRequest request) {
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)DynamicCSSFilter.class.getName());
        cacheKeyGenerator.append(request.getRequestURI());
        String queryString = request.getQueryString();
        if (queryString != null) {
            cacheKeyGenerator.append(this.sterilizeQueryString(queryString));
        }
        String cacheKey = String.valueOf(cacheKeyGenerator.finish());
        return this._tempDir.concat("/").concat(cacheKey);
    }

    protected Object getDynamicContent(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String content;
        String dynamicContent;
        File cacheDataFile;
        block14: {
            String realPath;
            String requestURI;
            String requestPath = requestURI = request.getRequestURI();
            String contextPath = request.getContextPath();
            if (!contextPath.equals("/")) {
                requestPath = requestPath.substring(contextPath.length());
            }
            if ((realPath = ServletContextUtil.getRealPath((ServletContext)this._servletContext, (String)requestPath)) == null) {
                return null;
            }
            File file = new File(realPath = StringUtil.replace((String)realPath, (char)'\\', (char)'/'));
            if (!file.exists()) {
                return null;
            }
            String cacheCommonFileName = this.getCacheFileName(request);
            File cacheContentTypeFile = new File(String.valueOf(cacheCommonFileName) + "_E_CONTENT_TYPE");
            cacheDataFile = new File(String.valueOf(cacheCommonFileName) + "_E_DATA");
            if (cacheDataFile.exists() && cacheDataFile.lastModified() >= file.lastModified()) {
                if (cacheContentTypeFile.exists()) {
                    String contentType = FileUtil.read((File)cacheContentTypeFile);
                    response.setContentType(contentType);
                }
                return cacheDataFile;
            }
            dynamicContent = null;
            content = null;
            try {
                if (realPath.endsWith(_CSS_EXTENSION) && file.exists()) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Parsing SASS on CSS " + file));
                    }
                    content = FileUtil.read((File)file);
                    dynamicContent = DynamicCSSUtil.parseSass(request, realPath, content);
                    response.setContentType("text/css");
                    FileUtil.write((File)cacheContentTypeFile, (String)"text/css");
                    break block14;
                }
                if (realPath.endsWith(_JSP_EXTENSION) || !file.exists()) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Parsing SASS on JSP or servlet " + realPath));
                    }
                    StringServletResponse stringResponse = new StringServletResponse(response);
                    this.processFilter(DynamicCSSFilter.class, request, (HttpServletResponse)stringResponse, filterChain);
                    CacheResponseUtil.setHeaders((HttpServletResponse)response, (Map)stringResponse.getHeaders());
                    response.setContentType(stringResponse.getContentType());
                    content = stringResponse.getString();
                    dynamicContent = DynamicCSSUtil.parseSass(request, realPath, content);
                    FileUtil.write((File)cacheContentTypeFile, (String)stringResponse.getContentType());
                    break block14;
                }
                return null;
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to parse SASS on CSS " + realPath), (Throwable)e2);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)content);
                }
                response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            }
        }
        if (dynamicContent != null) {
            FileUtil.write((File)cacheDataFile, (String)dynamicContent);
        } else {
            dynamicContent = content;
        }
        return dynamicContent;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Object parsedContent = this.getDynamicContent(request, response, filterChain);
        if (parsedContent == null) {
            this.processFilter(DynamicCSSFilter.class, request, response, filterChain);
        } else if (parsedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)response, (File)((File)parsedContent));
        } else if (parsedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)response, (String)((String)parsedContent));
        }
    }

    protected String sterilizeQueryString(String queryString) {
        return StringUtil.replace((String)queryString, (String[])new String[]{"/", "\\"}, (String[])new String[]{"_", "_"});
    }
}

