/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.minifier;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.JavaScriptBundleUtil;
import com.liferay.portal.util.LimitedFilesCache;
import com.liferay.portal.util.MinifierUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.filters.CacheResponseUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MinifierFilter
extends BasePortalFilter {
    private static final String _CSS_COMMENT_BEGIN = "/*";
    private static final String _CSS_COMMENT_END = "*/";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final String _JAVASCRIPT_EXTENSION = ".js";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + "/liferay/minifier";
    private static Log _log = LogFactoryUtil.getLog(MinifierFilter.class);
    private static Pattern _pattern = Pattern.compile("^(\\.ie|\\.js\\.ie)([^}]*)}", 8);
    private LimitedFilesCache<String> _limitedFilesCache;
    private ServletContext _servletContext;
    private String _servletContextName;
    private String _tempDir = _TEMP_DIR;

    public static String aggregateCss(String dir, String content) throws IOException {
        StringBuilder sb = new StringBuilder(content.length());
        int pos = 0;
        while (true) {
            int commentX = content.indexOf(_CSS_COMMENT_BEGIN, pos);
            int commentY = content.indexOf(_CSS_COMMENT_END, commentX + _CSS_COMMENT_BEGIN.length());
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            if (commentX != -1 && commentY != -1 && commentX < importX && commentY > importX) {
                sb.append(content.substring(pos, commentY += _CSS_COMMENT_END.length()));
                pos = commentY;
                continue;
            }
            sb.append(content.substring(pos, importX));
            String importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            String importFullFileName = dir.concat("/").concat(importFileName);
            String importContent = FileUtil.read((String)importFullFileName);
            if (importContent == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("File " + importFullFileName + " does not exist"));
                }
                importContent = "";
            }
            String importDir = "";
            int slashPos = importFileName.lastIndexOf(47);
            if (slashPos != -1) {
                importDir = "/".concat(importFileName.substring(0, slashPos + 1));
            }
            importContent = MinifierFilter.aggregateCss(String.valueOf(dir) + importDir, importContent);
            int importDepth = StringUtil.count((String)importFileName, (String)"/");
            String relativePath = "";
            int i2 = 0;
            while (i2 < importDepth) {
                relativePath = String.valueOf(relativePath) + "../";
                ++i2;
            }
            importContent = StringUtil.replace((String)importContent, (String[])new String[]{"url('" + relativePath, "url(\"" + relativePath, "url(" + relativePath}, (String[])new String[]{"url('[$TEMP_RELATIVE_PATH$]", "url(\"[$TEMP_RELATIVE_PATH$]", "url([$TEMP_RELATIVE_PATH$]"});
            importContent = StringUtil.replace((String)importContent, (String)"[$TEMP_RELATIVE_PATH$]", (String)"");
            sb.append(importContent);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        return sb.toString();
    }

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        this._servletContextName = GetterUtil.getString((String)this._servletContext.getServletContextName());
        if (Validator.isNull((String)this._servletContextName)) {
            this._tempDir = String.valueOf(this._tempDir) + "/portal";
        }
        if (PropsValues.MINIFIER_FILES_LIMIT > 0) {
            this._limitedFilesCache = new LimitedFilesCache(PropsValues.MINIFIER_FILES_LIMIT);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Minifier files limit " + PropsValues.MINIFIER_FILES_LIMIT));
            }
        }
    }

    protected String getCacheFileName(HttpServletRequest request) {
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)MinifierFilter.class.getName());
        cacheKeyGenerator.append(request.getRequestURI());
        String queryString = request.getQueryString();
        if (queryString != null) {
            cacheKeyGenerator.append(this.sterilizeQueryString(queryString));
        }
        String cacheKey = String.valueOf(cacheKeyGenerator.finish());
        return this._tempDir.concat("/").concat(cacheKey);
    }

    protected Object getMinifiedBundleContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int n;
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String minifierBundleId = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId");
        if (Validator.isNull((String)minifierType) || Validator.isNull((String)minifierBundleId) || !ArrayUtil.contains((Object[])PropsValues.JAVASCRIPT_BUNDLE_IDS, (Object)minifierBundleId)) {
            return null;
        }
        String minifierBundleDir = PropsUtil.get("javascript.bundle.dir", new Filter(minifierBundleId));
        String bundleDirRealPath = ServletContextUtil.getRealPath((ServletContext)this._servletContext, (String)minifierBundleDir);
        if (bundleDirRealPath == null) {
            return null;
        }
        String cacheFileName = this.getCacheFileName(request);
        String[] fileNames = JavaScriptBundleUtil.getFileNames(minifierBundleId);
        File cacheFile = new File(cacheFileName);
        if (this._limitedFilesCache != null) {
            this._limitedFilesCache.put(cacheFileName);
        }
        if (cacheFile.exists()) {
            boolean staleCache = false;
            String[] stringArray = fileNames;
            n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File file = new File(String.valueOf(bundleDirRealPath) + "/" + fileName);
                if (file.lastModified() > cacheFile.lastModified()) {
                    staleCache = true;
                    break;
                }
                ++n2;
            }
            if (!staleCache) {
                response.setContentType("text/javascript");
                return cacheFile;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Minifying JavaScript bundle " + minifierBundleId));
        }
        String minifiedContent = null;
        if (fileNames.length == 0) {
            minifiedContent = "";
        } else {
            StringBundler sb = new StringBundler(fileNames.length * 2);
            String[] stringArray = fileNames;
            int n3 = fileNames.length;
            n = 0;
            while (n < n3) {
                String fileName = stringArray[n];
                String content = FileUtil.read((String)(String.valueOf(bundleDirRealPath) + "/" + fileName));
                sb.append(content);
                sb.append("\n");
                ++n;
            }
            minifiedContent = this.minifyJavaScript(sb.toString());
        }
        response.setContentType("text/javascript");
        FileUtil.write((File)cacheFile, (String)minifiedContent);
        return minifiedContent;
    }

    protected Object getMinifiedContent(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String realPath;
        String requestURI;
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String minifierBundleId = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId");
        String minifierBundleDir = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleDir");
        if (Validator.isNull((String)minifierType) || Validator.isNotNull((String)minifierBundleId) || Validator.isNotNull((String)minifierBundleDir)) {
            return null;
        }
        String requestPath = requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (!contextPath.equals("/")) {
            requestPath = requestPath.substring(contextPath.length());
        }
        if ((realPath = ServletContextUtil.getRealPath((ServletContext)this._servletContext, (String)requestPath)) == null) {
            return null;
        }
        File file = new File(realPath = StringUtil.replace((String)realPath, (char)'\\', (char)'/'));
        if (!file.exists()) {
            return null;
        }
        String cacheCommonFileName = this.getCacheFileName(request);
        File cacheContentTypeFile = new File(String.valueOf(cacheCommonFileName) + "_E_CONTENT_TYPE");
        File cacheDataFile = new File(String.valueOf(cacheCommonFileName) + "_E_DATA");
        if (cacheDataFile.exists() && cacheDataFile.lastModified() >= file.lastModified()) {
            if (cacheContentTypeFile.exists()) {
                String contentType = FileUtil.read((File)cacheContentTypeFile);
                response.setContentType(contentType);
            }
            return cacheDataFile;
        }
        String minifiedContent = null;
        if (realPath.endsWith(_CSS_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying CSS " + file));
            }
            minifiedContent = this.minifyCss(request, response, file);
            response.setContentType("text/css");
            FileUtil.write((File)cacheContentTypeFile, (String)"text/css");
        } else if (realPath.endsWith(_JAVASCRIPT_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying JavaScript " + file));
            }
            minifiedContent = this.minifyJavaScript(file);
            response.setContentType("text/javascript");
            FileUtil.write((File)cacheContentTypeFile, (String)"text/javascript");
        } else if (realPath.endsWith(_JSP_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying JSP " + file));
            }
            StringServletResponse stringResponse = new StringServletResponse(response);
            this.processFilter(MinifierFilter.class, request, (HttpServletResponse)stringResponse, filterChain);
            CacheResponseUtil.setHeaders((HttpServletResponse)response, (Map)stringResponse.getHeaders());
            response.setContentType(stringResponse.getContentType());
            minifiedContent = stringResponse.getString();
            if (minifierType.equals("css")) {
                minifiedContent = this.minifyCss(request, response, realPath, minifiedContent);
            } else if (minifierType.equals("js")) {
                minifiedContent = this.minifyJavaScript(minifiedContent);
            }
            FileUtil.write((File)cacheContentTypeFile, (String)stringResponse.getContentType());
        } else {
            return null;
        }
        FileUtil.write((File)cacheDataFile, (String)minifiedContent);
        return minifiedContent;
    }

    protected String minifyCss(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        String content = FileUtil.read((File)file);
        content = MinifierFilter.aggregateCss(file.getParent(), content);
        return this.minifyCss(request, response, file.getAbsolutePath(), content);
    }

    protected String minifyCss(HttpServletRequest request, HttpServletResponse response, String cssRealPath, String content) {
        try {
            content = DynamicCSSUtil.parseSass(request, cssRealPath, content);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to parse SASS on CSS " + cssRealPath), (Throwable)e2);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)content);
            }
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        }
        String browserId = ParamUtil.getString((HttpServletRequest)request, (String)"browserId");
        if (!browserId.equals("ie")) {
            Matcher matcher = _pattern.matcher(content);
            content = matcher.replaceAll("");
        }
        return MinifierUtil.minifyCss(content);
    }

    protected String minifyJavaScript(File file) throws IOException {
        String content = FileUtil.read((File)file);
        return this.minifyJavaScript(content);
    }

    protected String minifyJavaScript(String content) {
        return MinifierUtil.minifyJavaScript(content);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Object minifiedContent = this.getMinifiedContent(request, response, filterChain);
        if (minifiedContent == null) {
            minifiedContent = this.getMinifiedBundleContent(request, response);
        }
        if (minifiedContent == null) {
            this.processFilter(MinifierFilter.class, request, response, filterChain);
        } else if (minifiedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)response, (File)((File)minifiedContent));
        } else if (minifiedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)response, (String)((String)minifiedContent));
        }
    }

    protected String sterilizeQueryString(String queryString) {
        return StringUtil.replace((String)queryString, (String[])new String[]{"/", "\\"}, (String[])new String[]{"_", "_"});
    }
}

