/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import com.liferay.portal.spring.aop.ServiceBeanMethodInvocation;
import com.liferay.portal.spring.aop.ServiceMethodAnnotationCache;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBeanAopProxy
implements AopProxy,
InvocationHandler {
    private static Log _log = LogFactoryUtil.getLog(ServiceBeanAopProxy.class);
    private static Map<ServiceBeanMethodInvocation, MethodInterceptorsBag> _methodInterceptorBags = new ConcurrentHashMap<ServiceBeanMethodInvocation, MethodInterceptorsBag>();
    private AdvisedSupport _advisedSupport;
    private AdvisorChainFactory _advisorChainFactory;
    private final List<MethodInterceptor> _classLevelMethodInterceptors;
    private final List<MethodInterceptor> _fullMethodInterceptors;
    private boolean _mergeSpringMethodInterceptors;

    public static void clearMethodInterceptorCache() {
        _methodInterceptorBags.clear();
    }

    public static void removeMethodInterceptor(MethodInvocation methodInvocation, MethodInterceptor methodInterceptor) {
        if (!(methodInvocation instanceof ServiceBeanMethodInvocation)) {
            return;
        }
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = (ServiceBeanMethodInvocation)methodInvocation;
        MethodInterceptorsBag methodInterceptorsBag = _methodInterceptorBags.get(serviceBeanMethodInvocation);
        if (methodInterceptorsBag == null) {
            return;
        }
        ArrayList<MethodInterceptor> methodInterceptors = new ArrayList<MethodInterceptor>(methodInterceptorsBag._mergedMethodInterceptors);
        methodInterceptors.remove(methodInterceptor);
        MethodInterceptorsBag newMethodInterceptorsBag = null;
        if (methodInterceptors.equals(methodInterceptorsBag._classLevelMethodInterceptors)) {
            newMethodInterceptorsBag = new MethodInterceptorsBag(methodInterceptorsBag._classLevelMethodInterceptors, methodInterceptorsBag._classLevelMethodInterceptors);
        } else {
            methodInterceptors.trimToSize();
            newMethodInterceptorsBag = new MethodInterceptorsBag(methodInterceptorsBag._classLevelMethodInterceptors, methodInterceptors);
        }
        _methodInterceptorBags.put(serviceBeanMethodInvocation.toCacheKeyModel(), newMethodInterceptorsBag);
    }

    public ServiceBeanAopProxy(AdvisedSupport advisedSupport, MethodInterceptor methodInterceptor) {
        this._advisedSupport = advisedSupport;
        this._advisorChainFactory = this._advisedSupport.getAdvisorChainFactory();
        Object[] proxyInterfaces = this._advisedSupport.getProxiedInterfaces();
        this._mergeSpringMethodInterceptors = !ArrayUtil.contains((Object[])proxyInterfaces, SpringProxy.class);
        ArrayList<MethodInterceptor> classLevelMethodInterceptors = new ArrayList<MethodInterceptor>();
        ArrayList<MethodInterceptor> fullMethodInterceptors = new ArrayList<MethodInterceptor>();
        while (true) {
            if (!(methodInterceptor instanceof ChainableMethodAdvice)) break;
            ChainableMethodAdvice chainableMethodAdvice = (ChainableMethodAdvice)methodInterceptor;
            if (methodInterceptor instanceof AnnotationChainableMethodAdvice) {
                AnnotationChainableMethodAdvice annotationChainableMethodAdvice = (AnnotationChainableMethodAdvice)methodInterceptor;
                Class<Annotation> annotationClass = annotationChainableMethodAdvice.getAnnotationClass();
                Target target = annotationClass.getAnnotation(Target.class);
                if (target == null) {
                    classLevelMethodInterceptors.add(methodInterceptor);
                } else {
                    ElementType[] elementTypeArray = target.value();
                    int n = elementTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ElementType elementType = elementTypeArray[n2];
                        if (elementType == ElementType.TYPE) {
                            classLevelMethodInterceptors.add(methodInterceptor);
                            break;
                        }
                        ++n2;
                    }
                }
            } else {
                classLevelMethodInterceptors.add(methodInterceptor);
            }
            fullMethodInterceptors.add(methodInterceptor);
            methodInterceptor = chainableMethodAdvice.nextMethodInterceptor;
        }
        classLevelMethodInterceptors.add(methodInterceptor);
        fullMethodInterceptors.add(methodInterceptor);
        classLevelMethodInterceptors.trimToSize();
        this._classLevelMethodInterceptors = classLevelMethodInterceptors;
        this._fullMethodInterceptors = fullMethodInterceptors;
        AnnotationChainableMethodAdvice.registerAnnotationClass(Skip.class);
    }

    public Object getProxy() {
        return this.getProxy(ClassUtils.getDefaultClassLoader());
    }

    public Object getProxy(ClassLoader classLoader) {
        Class[] proxiedInterfaces = AopProxyUtils.completeProxiedInterfaces((AdvisedSupport)this._advisedSupport);
        return ProxyUtil.newProxyInstance((ClassLoader)classLoader, (Class[])proxiedInterfaces, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        TargetSource targetSource = this._advisedSupport.getTargetSource();
        Object target = null;
        try {
            ServiceBeanMethodInvocation serviceBeanMethodInvocation;
            Skip skip;
            Class<?> targetClass = null;
            target = targetSource.getTarget();
            if (target != null) {
                targetClass = target.getClass();
            }
            if ((skip = (Skip)ServiceMethodAnnotationCache.get(serviceBeanMethodInvocation = new ServiceBeanMethodInvocation(target, targetClass, method, arguments), Skip.class, null)) != null) {
                serviceBeanMethodInvocation.setMethodInterceptors(Collections.<MethodInterceptor>emptyList());
            } else {
                this._setMethodInterceptors(serviceBeanMethodInvocation);
            }
            Object object = serviceBeanMethodInvocation.proceed();
            return object;
        }
        finally {
            if (target != null && !targetSource.isStatic()) {
                targetSource.releaseTarget(target);
            }
        }
    }

    private List<MethodInterceptor> _getMethodInterceptors(ServiceBeanMethodInvocation serviceBeanMethodInvocation) {
        ArrayList<MethodInterceptor> methodInterceptors = new ArrayList<MethodInterceptor>(this._fullMethodInterceptors);
        if (!this._mergeSpringMethodInterceptors) {
            return methodInterceptors;
        }
        List list = this._advisorChainFactory.getInterceptorsAndDynamicInterceptionAdvice((Advised)this._advisedSupport, serviceBeanMethodInvocation.getMethod(), serviceBeanMethodInvocation.getTargetClass());
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof MethodInterceptor) continue;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Skipping unsupported interceptor type " + obj.getClass()));
            }
            itr.remove();
        }
        if (list.isEmpty()) {
            return methodInterceptors;
        }
        for (Object object : list) {
            methodInterceptors.add((MethodInterceptor)object);
        }
        return methodInterceptors;
    }

    private void _setMethodInterceptors(ServiceBeanMethodInvocation serviceBeanMethodInvocation) {
        MethodInterceptorsBag methodInterceptorsBag = _methodInterceptorBags.get(serviceBeanMethodInvocation);
        if (methodInterceptorsBag == null) {
            List<MethodInterceptor> methodInterceptors = this._getMethodInterceptors(serviceBeanMethodInvocation);
            methodInterceptorsBag = new MethodInterceptorsBag(this._classLevelMethodInterceptors, methodInterceptors);
            _methodInterceptorBags.put(serviceBeanMethodInvocation.toCacheKeyModel(), methodInterceptorsBag);
        }
        serviceBeanMethodInvocation.setMethodInterceptors(methodInterceptorsBag._mergedMethodInterceptors);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInterceptorsBag {
        private List<MethodInterceptor> _classLevelMethodInterceptors;
        private List<MethodInterceptor> _mergedMethodInterceptors;

        public MethodInterceptorsBag(List<MethodInterceptor> classLevelMethodInterceptors, List<MethodInterceptor> mergedMethodInterceptors) {
            this._classLevelMethodInterceptors = classLevelMethodInterceptors;
            this._mergedMethodInterceptors = mergedMethodInterceptors;
        }
    }
}

