/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBeanMethodInvocation
implements MethodInvocation,
Serializable {
    private Object[] _arguments;
    private int _hashCode;
    private int _index;
    private Method _method;
    private List<MethodInterceptor> _methodInterceptors;
    private Object _target;
    private Class<?> _targetClass;
    private String _toString;

    public ServiceBeanMethodInvocation(Object target, Class<?> targetClass, Method method, Object[] arguments) {
        this._target = target;
        this._targetClass = targetClass;
        this._method = method;
        this._arguments = arguments;
        if (!this._method.isAccessible()) {
            boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
            try {
                PortalSecurityManagerThreadLocal.setEnabled(false);
                this._method.setAccessible(true);
            }
            finally {
                PortalSecurityManagerThreadLocal.setEnabled(enabled);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServiceBeanMethodInvocation)) {
            return false;
        }
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = (ServiceBeanMethodInvocation)obj;
        return this._method == serviceBeanMethodInvocation._method && Validator.equals((Object)this._method, (Object)serviceBeanMethodInvocation._method);
    }

    public Object[] getArguments() {
        return this._arguments;
    }

    public Method getMethod() {
        return this._method;
    }

    public AccessibleObject getStaticPart() {
        return this._method;
    }

    public Class<?> getTargetClass() {
        return this._targetClass;
    }

    public Object getThis() {
        return this._target;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this._method.hashCode();
        }
        return this._hashCode;
    }

    public Object proceed() throws Throwable {
        if (this._index < this._methodInterceptors.size()) {
            MethodInterceptor methodInterceptor = this._methodInterceptors.get(this._index++);
            return methodInterceptor.invoke((MethodInvocation)this);
        }
        try {
            return this._method.invoke(this._target, this._arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public void setMethodInterceptors(List<MethodInterceptor> methodInterceptors) {
        this._methodInterceptors = methodInterceptors;
    }

    public ServiceBeanMethodInvocation toCacheKeyModel() {
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = new ServiceBeanMethodInvocation(null, null, this._method, null);
        serviceBeanMethodInvocation._hashCode = this._hashCode;
        return serviceBeanMethodInvocation;
    }

    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        Class<?>[] parameterTypes = this._method.getParameterTypes();
        StringBundler sb = new StringBundler(parameterTypes.length * 2 + 6);
        Class<?> declaringClass = this._method.getDeclaringClass();
        sb.append(declaringClass.getName());
        sb.append(".");
        sb.append(this._method.getName());
        sb.append("(");
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            Class<?> parameterType = parameterTypes[i2];
            sb.append(parameterType.getName());
            if (i2 + 1 < parameterTypes.length) {
                sb.append(",");
            }
            ++i2;
        }
        sb.append(")");
        if (this._targetClass != null) {
            sb.append("@");
            sb.append(this._targetClass.getName());
        }
        this._toString = sb.toString();
        return this._toString;
    }
}

