/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.cache.ehcache.ClearEhcacheThreadUtil;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.CharBufferPool;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.ClearTimerThreadUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.module.framework.ModuleFrameworkUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.spring.context.PortalContextLoaderLifecycleThreadLocal;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portal.velocity.LiferayResourceCacheUtil;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalContextLoaderListener
extends ContextLoaderListener {
    private static Log _log = LogFactoryUtil.getLog(PortalContextLoaderListener.class);
    private static Field _filteredPropertyDescriptorsCacheField;

    static {
        try {
            _filteredPropertyDescriptorsCacheField = ReflectionUtil.getDeclaredField(AbstractAutowireCapableBeanFactory.class, (String)"filteredPropertyDescriptorsCache");
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        PortalContextLoaderLifecycleThreadLocal.setDestroying(true);
        ThreadLocalCacheManager.destroy();
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        try {
            ClearTimerThreadUtil.clearTimerThread();
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
        try {
            ClearEhcacheThreadUtil.clearEhcacheReplicationThread();
        }
        catch (Exception e4) {
            _log.error((Object)e4, (Throwable)e4);
        }
        try {
            DirectServletRegistryUtil.clearServlets();
        }
        catch (Exception e5) {
            _log.error((Object)e5, (Throwable)e5);
        }
        try {
            HotDeployUtil.reset();
        }
        catch (Exception e6) {
            _log.error((Object)e6, (Throwable)e6);
        }
        try {
            ModuleFrameworkUtil.stopRuntime();
        }
        catch (Exception e7) {
            _log.error((Object)e7, (Throwable)e7);
        }
        try {
            super.contextDestroyed(servletContextEvent);
            try {
                ModuleFrameworkUtil.stopFramework();
            }
            catch (Exception e8) {
                _log.error((Object)e8, (Throwable)e8);
            }
        }
        finally {
            PortalContextLoaderLifecycleThreadLocal.setDestroying(false);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        PortalSecurityManagerThreadLocal.setEnabled(false);
        InstancePool.reset();
        MethodCache.reset();
        PortletBagPool.reset();
        ReferenceRegistry.releaseReferences();
        InitUtil.init();
        ServletContext servletContext = servletContextEvent.getServletContext();
        ClassPathUtil.initializeClassPaths((ServletContext)servletContext);
        CacheRegistryUtil.clear();
        CharBufferPool.cleanUp();
        PortletContextBagPool.clear();
        WebAppPool.clear();
        if (PropsValues.MODULE_FRAMEWORK_ENABLED) {
            try {
                ModuleFrameworkUtil.startFramework();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        PortalContextLoaderLifecycleThreadLocal.setInitializing(true);
        try {
            super.contextInitialized(servletContextEvent);
        }
        finally {
            PortalContextLoaderLifecycleThreadLocal.setInitializing(false);
            PortalSecurityManagerThreadLocal.setEnabled(true);
        }
        FinderCacheUtil.clearCache();
        FinderCacheUtil.clearLocalCache();
        EntityCacheUtil.clearCache();
        EntityCacheUtil.clearLocalCache();
        LiferayResourceCacheUtil.clear();
        PermissionCacheUtil.clearCache();
        PermissionCacheUtil.clearLocalCache();
        WikiCacheUtil.clearCache(0L);
        ServletContextPool.clear();
        CacheUtil.clearCache();
        MultiVMPoolUtil.clear();
        SingleVMPoolUtil.clear();
        WebCachePoolUtil.clear();
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        ClassLoader portalClassLoader = PACLClassLoaderUtil.getPortalClassLoader();
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(portalClassLoader, (ApplicationContext)applicationContext);
        beanLocatorImpl.setPACLWrapPersistence(true);
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocatorImpl);
        ClassLoader classLoader = portalClassLoader;
        while (classLoader != null) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
            classLoader = classLoader.getParent();
        }
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        this.clearFilteredPropertyDescriptorsCache(autowireCapableBeanFactory);
        if (PropsValues.MODULE_FRAMEWORK_ENABLED) {
            try {
                ModuleFrameworkUtil.registerContext(applicationContext);
                ModuleFrameworkUtil.registerContext(servletContext);
                ModuleFrameworkUtil.startRuntime();
            }
            catch (Exception e3) {
                _log.error((Object)e3, (Throwable)e3);
            }
        }
    }

    protected void clearFilteredPropertyDescriptorsCache(AutowireCapableBeanFactory autowireCapableBeanFactory) {
        try {
            Map filteredPropertyDescriptorsCache = (Map)_filteredPropertyDescriptorsCacheField.get(autowireCapableBeanFactory);
            filteredPropertyDescriptorsCache.clear();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

