/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PreloadClassLoader;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.spring.util.FilterClassLoader;
import com.liferay.portal.util.PropsValues;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PortletApplicationContext
extends XmlWebApplicationContext {
    private static Log _log = LogFactoryUtil.getLog(PortletApplicationContext.class);
    private static Map<String, Class<?>> _classes = new HashMap();

    static {
        String[] stringArray = PropsValues.PORTAL_SECURITY_MANAGER_PRELOAD_CLASSLOADER_CLASSES;
        int n = PropsValues.PORTAL_SECURITY_MANAGER_PRELOAD_CLASSLOADER_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            _classes.put(clazz.getName(), clazz);
            ++n2;
        }
    }

    public static ClassLoader getBeanClassLoader() {
        if (PortletApplicationContext._isUseRestrictedClassLoader()) {
            boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
            try {
                PortalSecurityManagerThreadLocal.setEnabled(false);
                PreloadClassLoader preloadClassLoader = new PreloadClassLoader(PortletClassLoaderUtil.getClassLoader(), _classes);
                return preloadClassLoader;
            }
            finally {
                PortalSecurityManagerThreadLocal.setEnabled(enabled);
            }
        }
        ClassLoader beanClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader[])new ClassLoader[]{PortletClassLoaderUtil.getClassLoader(), PACLClassLoaderUtil.getPortalClassLoader()});
        return new FilterClassLoader(beanClassLoader);
    }

    protected String[] getDefaultConfigLocations() {
        return new String[0];
    }

    protected String[] getPortletConfigLocations() {
        Object[] configLocations = this.getConfigLocations();
        ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
        Configuration serviceBuilderPropertiesConfiguration = null;
        try {
            serviceBuilderPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read service.properties");
            }
            return configLocations;
        }
        return (String[])ArrayUtil.append((Object[])configLocations, (Object[])serviceBuilderPropertiesConfiguration.getArray("spring.configs"));
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        xmlBeanDefinitionReader.setBeanClassLoader(PortletApplicationContext.getBeanClassLoader());
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        String[] configLocations = this.getPortletConfigLocations();
        if (configLocations == null) {
            return;
        }
        String[] stringArray = configLocations;
        int n = configLocations.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                String configLocation = stringArray[n2];
                boolean checkReadFile = PortalSecurityManagerThreadLocal.isCheckReadFile();
                try {
                    try {
                        PortalSecurityManagerThreadLocal.setCheckReadFile(false);
                        xmlBeanDefinitionReader.loadBeanDefinitions(configLocation);
                    }
                    catch (Exception e2) {
                        Throwable cause = e2.getCause();
                        if (cause instanceof FileNotFoundException) {
                            if (_log.isWarnEnabled()) {
                                _log.warn((Object)cause.getMessage());
                            }
                        } else {
                            _log.error((Object)e2, (Throwable)e2);
                        }
                        PortalSecurityManagerThreadLocal.setCheckReadFile(checkReadFile);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    PortalSecurityManagerThreadLocal.setCheckReadFile(checkReadFile);
                    throw throwable;
                }
                PortalSecurityManagerThreadLocal.setCheckReadFile(checkReadFile);
            }
            ++n2;
        }
    }

    private static boolean _isUseRestrictedClassLoader() {
        return PACLPolicyManager.isActive();
    }
}

