/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.spring.context.PortletBeanFactoryCleaner;
import com.liferay.portal.spring.context.PortletContextLoader;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortletContextLoaderListener
extends ContextLoaderListener {
    private static Log _log = LogFactoryUtil.getLog(PortletContextLoaderListener.class);

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        block2: {
            ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
            ServletContext servletContext = servletContextEvent.getServletContext();
            try {
                Class<?> beanLocatorUtilClass = Class.forName("com.liferay.util.bean.PortletBeanLocatorUtil", true, classLoader);
                Method setBeanLocatorMethod = beanLocatorUtilClass.getMethod("setBeanLocator", BeanLocator.class);
                setBeanLocatorMethod.invoke(beanLocatorUtilClass, new Object[1]);
                PortletBeanLocatorUtil.setBeanLocator((String)servletContext.getServletContextName(), null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        super.contextDestroyed(servletContextEvent);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        MethodCache.reset();
        ServletContext servletContext = servletContextEvent.getServletContext();
        Object previousApplicationContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
        PACLPolicy previousPACLPolicy = PortalSecurityManagerThreadLocal.getPACLPolicy();
        try {
            PACLPolicy paclPolicy = PACLPolicyManager.getPACLPolicy(classLoader);
            PortalSecurityManagerThreadLocal.setPACLPolicy(paclPolicy);
            super.contextInitialized(servletContextEvent);
        }
        finally {
            PortalSecurityManagerThreadLocal.setPACLPolicy(previousPACLPolicy);
        }
        PortletBeanFactoryCleaner.readBeans();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(classLoader, (ApplicationContext)applicationContext);
        beanLocatorImpl.setPACLServletContextName(servletContext.getServletContextName());
        try {
            Class<?> beanLocatorUtilClass = Class.forName("com.liferay.util.bean.PortletBeanLocatorUtil", true, classLoader);
            Method setBeanLocatorMethod = beanLocatorUtilClass.getMethod("setBeanLocator", BeanLocator.class);
            setBeanLocatorMethod.invoke(beanLocatorUtilClass, beanLocatorImpl);
            PortletBeanLocatorUtil.setBeanLocator((String)servletContext.getServletContextName(), (BeanLocator)beanLocatorImpl);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if (previousApplicationContext == null) {
            servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        } else {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, previousApplicationContext);
        }
    }

    protected ContextLoader createContextLoader() {
        return new PortletContextLoader();
    }
}

