/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.jpa;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.jpa.DatabaseDetector;
import com.liferay.portal.spring.jpa.LiferayPersistenceUnitPostProcessor;
import com.liferay.portal.util.PropsValues;
import javax.sql.DataSource;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.OpenJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.TopLinkJpaVendorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalContainerEntityManagerFactoryBean
extends org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean {
    private static Log _log = LogFactoryUtil.getLog(LocalContainerEntityManagerFactoryBean.class);

    public LocalContainerEntityManagerFactoryBean() {
        try {
            if (Validator.isNotNull((String)PropsValues.JPA_LOAD_TIME_WEAVER)) {
                Class<?> loadTimeWeaverClass = Class.forName(PropsValues.JPA_LOAD_TIME_WEAVER);
                LoadTimeWeaver loadTimeWeaver = (LoadTimeWeaver)loadTimeWeaverClass.newInstance();
                this.setLoadTimeWeaver(loadTimeWeaver);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RuntimeException(e2);
        }
        this.setPersistenceXmlLocation("classpath*:META-INF/persistence-custom.xml");
        PersistenceUnitPostProcessor[] persistenceUnitPostProcessors = new PersistenceUnitPostProcessor[]{new LiferayPersistenceUnitPostProcessor()};
        this.setPersistenceUnitPostProcessors(persistenceUnitPostProcessors);
    }

    public void setDataSource(DataSource dataSource) {
        Database database = DatabaseDetector.determineDatabase(dataSource);
        AbstractJpaVendorAdapter jpaVendorAdapter = null;
        String provider = PropsValues.JPA_PROVIDER;
        try {
            Class<?> providerClass = this.getProviderClass(provider);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Using provider class " + providerClass.getName()));
            }
            jpaVendorAdapter = (AbstractJpaVendorAdapter)providerClass.newInstance();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return;
        }
        String databasePlatform = PropsValues.JPA_DATABASE_PLATFORM;
        if (provider.equalsIgnoreCase("eclipselink") || provider.equalsIgnoreCase("toplink")) {
            if (databasePlatform == null) {
                databasePlatform = this.getDatabasePlatform(database);
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Using database platform " + databasePlatform));
            }
            jpaVendorAdapter.setDatabasePlatform(databasePlatform);
        } else if (databasePlatform == null) {
            jpaVendorAdapter.setDatabase(database);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Using database name " + database.toString()));
            }
        } else {
            jpaVendorAdapter.setDatabase(Database.valueOf((String)databasePlatform));
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Using database name " + databasePlatform));
            }
        }
        this.setJpaVendorAdapter((JpaVendorAdapter)jpaVendorAdapter);
        super.setDataSource(dataSource);
    }

    protected String getDatabasePlatform(Database database) {
        String databasePlatform = null;
        String packageName = null;
        boolean eclipseLink = false;
        if (PropsValues.JPA_PROVIDER.equalsIgnoreCase("eclipselink")) {
            packageName = "org.eclipse.persistence.platform.database.";
            eclipseLink = true;
        } else {
            packageName = "oracle.toplink.essentials.platform.database.";
        }
        if (database.equals((Object)Database.DB2)) {
            databasePlatform = String.valueOf(packageName) + "DB2Platform";
        } else if (database.equals((Object)Database.DERBY)) {
            databasePlatform = String.valueOf(packageName) + "DerbyPlatform";
        } else if (database.equals((Object)Database.HSQL)) {
            databasePlatform = String.valueOf(packageName) + "HSQLPlatform";
        } else if (database.equals((Object)Database.INFORMIX)) {
            databasePlatform = String.valueOf(packageName) + "InformixPlatform";
        } else if (database.equals((Object)Database.MYSQL)) {
            databasePlatform = eclipseLink ? String.valueOf(packageName) + "MySQLPlatform" : String.valueOf(packageName) + "MySQL4Platform";
        } else if (database.equals((Object)Database.ORACLE)) {
            databasePlatform = eclipseLink ? String.valueOf(packageName) + "OraclePlatform" : String.valueOf(packageName) + "oracle.OraclePlatform";
        } else if (database.equals((Object)Database.POSTGRESQL)) {
            databasePlatform = String.valueOf(packageName) + "PostgreSQLPlatform";
        } else if (database.equals((Object)Database.SQL_SERVER)) {
            databasePlatform = String.valueOf(packageName) + "SQLServerPlatform";
        } else if (database.equals((Object)Database.SYBASE)) {
            databasePlatform = String.valueOf(packageName) + "SybasePlatform";
        } else {
            _log.error((Object)("Unable to detect database platform for \"" + database.toString() + "\". Override by configuring the " + "\"jpa.database.platform\" property."));
        }
        return databasePlatform;
    }

    protected Class<?> getProviderClass(String provider) throws Exception {
        if (provider.equalsIgnoreCase("eclipselink")) {
            return EclipseLinkJpaVendorAdapter.class;
        }
        if (provider.equalsIgnoreCase("hibernate")) {
            return HibernateJpaVendorAdapter.class;
        }
        if (provider.equalsIgnoreCase("openjpa")) {
            return OpenJpaVendorAdapter.class;
        }
        if (provider.equalsIgnoreCase("toplink")) {
            return TopLinkJpaVendorAdapter.class;
        }
        return null;
    }
}

