/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.annotation.AnnotationLocator;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.MethodTargetClassKey;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTransactionAttributeSource
implements TransactionAttributeSource {
    private static TransactionAttribute _nullTransactionAttribute = new DefaultTransactionAttribute();
    private Map<MethodTargetClassKey, TransactionAttribute> _transactionAttributes = new ConcurrentHashMap<MethodTargetClassKey, TransactionAttribute>();

    public TransactionAttribute getTransactionAttribute(Method method, Class<?> targetClass) {
        MethodTargetClassKey methodTargetClassKey = new MethodTargetClassKey(method, targetClass);
        TransactionAttribute transactionAttribute = this._transactionAttributes.get(methodTargetClassKey);
        if (transactionAttribute != null) {
            if (transactionAttribute == _nullTransactionAttribute) {
                return null;
            }
            return transactionAttribute;
        }
        Transactional transactional = (Transactional)AnnotationLocator.locate((Method)method, targetClass, Transactional.class);
        transactionAttribute = TransactionAttributeBuilder.build(transactional);
        if (transactionAttribute == null) {
            this._transactionAttributes.put(methodTargetClassKey, _nullTransactionAttribute);
        } else {
            this._transactionAttributes.put(methodTargetClassKey, transactionAttribute);
        }
        return transactionAttribute;
    }
}

