/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.cache.transactional.TransactionalPortalCacheHelper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.transaction.TransactionCommitCallbackUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class TransactionInterceptor
implements MethodInterceptor {
    protected TransactionAttributeSource transactionAttributeSource;
    private static Log _log = LogFactoryUtil.getLog(TransactionInterceptor.class);
    private PlatformTransactionManager _platformTransactionManager;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        TransactionAttribute transactionAttribute;
        Method method = methodInvocation.getMethod();
        Class<?> targetClass = null;
        Object targetBean = methodInvocation.getThis();
        if (targetBean != null) {
            targetClass = targetBean.getClass();
        }
        if ((transactionAttribute = this.transactionAttributeSource.getTransactionAttribute(method, targetClass)) == null) {
            return methodInvocation.proceed();
        }
        TransactionStatus transactionStatus = this._platformTransactionManager.getTransaction((TransactionDefinition)transactionAttribute);
        if (transactionStatus.isNewTransaction()) {
            TransactionalPortalCacheHelper.begin();
            TransactionCommitCallbackUtil.pushCallbackList();
        }
        Object returnValue = null;
        try {
            returnValue = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.processThrowable(throwable, transactionAttribute, transactionStatus);
        }
        this._platformTransactionManager.commit(transactionStatus);
        if (transactionStatus.isNewTransaction()) {
            TransactionalPortalCacheHelper.commit();
            this.invokeCallbacks();
        }
        return returnValue;
    }

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this._platformTransactionManager = platformTransactionManager;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public void setTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this._platformTransactionManager = platformTransactionManager;
    }

    protected void invokeCallbacks() {
        List<Callable<?>> callables = TransactionCommitCallbackUtil.popCallbackList();
        for (Callable<?> callable : callables) {
            try {
                callable.call();
            }
            catch (Exception e2) {
                _log.error((Object)"Failed to execute transaction commit callback", (Throwable)e2);
            }
        }
    }

    protected void processThrowable(Throwable throwable, TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) throws Throwable {
        block19: {
            if (transactionAttribute.rollbackOn(throwable)) {
                try {
                    try {
                        this._platformTransactionManager.rollback(transactionStatus);
                        break block19;
                    }
                    catch (TransactionSystemException tse) {
                        _log.error((Object)"Application exception overridden by rollback exception", (Throwable)tse);
                        throw tse;
                    }
                    catch (RuntimeException re) {
                        _log.error((Object)"Application exception overridden by rollback exception", (Throwable)re);
                        throw re;
                    }
                    catch (Error e2) {
                        _log.error((Object)"Application exception overridden by rollback error", (Throwable)e2);
                        throw e2;
                    }
                }
                finally {
                    if (transactionStatus.isNewTransaction()) {
                        TransactionalPortalCacheHelper.rollback();
                        TransactionCommitCallbackUtil.popCallbackList();
                    }
                }
            }
            boolean hasError = false;
            try {
                try {
                    this._platformTransactionManager.commit(transactionStatus);
                }
                catch (TransactionSystemException tse) {
                    _log.error((Object)"Application exception overridden by commit exception", (Throwable)tse);
                    hasError = true;
                    throw tse;
                }
                catch (RuntimeException re) {
                    _log.error((Object)"Application exception overridden by commit exception", (Throwable)re);
                    hasError = true;
                    throw re;
                }
                catch (Error e3) {
                    _log.error((Object)"Application exception overridden by commit error", (Throwable)e3);
                    hasError = true;
                    throw e3;
                }
            }
            finally {
                if (transactionStatus.isNewTransaction()) {
                    if (hasError) {
                        TransactionalPortalCacheHelper.rollback();
                        TransactionCommitCallbackUtil.popCallbackList();
                    } else {
                        TransactionalPortalCacheHelper.commit();
                        this.invokeCallbacks();
                    }
                }
            }
        }
        throw throwable;
    }
}

