/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.util;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.spring.util.SpringFactory;
import com.liferay.portal.kernel.spring.util.SpringFactoryException;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringFactoryImpl
implements SpringFactory {
    private Map<String, Set<String>> _beanDefinitions;

    public Object newBean(String className) throws SpringFactoryException {
        return this.newBean(className, null);
    }

    public Object newBean(String className, Map<String, Object> properties) throws SpringFactoryException {
        try {
            return this.doNewBean(className, properties);
        }
        catch (SpringFactoryException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new SpringFactoryException((Throwable)e2);
        }
    }

    public void setBeanDefinitions(Map<String, String> beanDefinitions) {
        this._beanDefinitions = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : beanDefinitions.entrySet()) {
            String className = entry.getKey();
            Set properties = SetUtil.fromArray((Object[])StringUtil.split((String)entry.getValue()));
            this._beanDefinitions.put(className, properties);
        }
    }

    protected Object doNewBean(String className, Map<String, Object> properties) throws Exception {
        Set<String> allowedProperties = this._beanDefinitions.get(className);
        if (allowedProperties == null) {
            throw new SpringFactoryException("Undefined class " + className);
        }
        boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
        try {
            PortalSecurityManagerThreadLocal.setEnabled(false);
            Object bean = InstanceFactory.newInstance((ClassLoader)PACLClassLoaderUtil.getPortalClassLoader(), (String)className);
            if (properties == null) {
                Object object = bean;
                return object;
            }
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String name = entry.getKey();
                if (!allowedProperties.contains(name)) {
                    throw new SpringFactoryException("Undefined property " + name + " for class " + className);
                }
                Object value = entry.getValue();
                BeanPropertiesUtil.setProperty((Object)bean, (String)name, (Object)value);
            }
            Object object = bean;
            return object;
        }
        finally {
            PortalSecurityManagerThreadLocal.setEnabled(enabled);
        }
    }
}

