/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.util;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.spring.context.ArrayApplicationContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringUtil {
    public static void loadContext() {
        List configLocations = ListUtil.fromArray((Object[])PropsUtil.getArray("spring.configs"));
        SpringUtil._loadContext(configLocations);
    }

    public static void loadContext(List<String> extraConfigLocations) {
        List configLocations = ListUtil.fromArray((Object[])PropsUtil.getArray("spring.configs"));
        if (extraConfigLocations != null) {
            configLocations.addAll(extraConfigLocations);
        }
        SpringUtil._loadContext(configLocations);
    }

    private static void _loadContext(List<String> configLocations) {
        if (PropsValues.PERSISTENCE_PROVIDER.equalsIgnoreCase("jpa")) {
            configLocations.remove("META-INF/hibernate-spring.xml");
        } else {
            configLocations.remove("META-INF/jpa-spring.xml");
        }
        ArrayApplicationContext applicationContext = new ArrayApplicationContext(configLocations.toArray(new String[configLocations.size()]));
        BeanLocatorImpl beanLocator = new BeanLocatorImpl(PACLClassLoaderUtil.getPortalClassLoader(), (ApplicationContext)applicationContext);
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocator);
    }
}

