/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthTokenUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.servlet.SharedSessionServletRequest;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONAction
extends Action {
    private static final String _SERVER_IP = "SERVER_IP";
    private static Log _log = LogFactoryUtil.getLog(JSONAction.class);
    private Set<String> _hostsAllowed = SetUtil.fromArray((Object[])PropsValues.JSON_SERVICE_AUTH_TOKEN_HOSTS_ALLOWED);
    private ServletContext _servletContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.rerouteExecute(request, response)) {
            return null;
        }
        String callback = ParamUtil.getString((HttpServletRequest)request, (String)"callback");
        String instance = ParamUtil.getString((HttpServletRequest)request, (String)"inst");
        String json = null;
        try {
            this.checkAuthToken(request);
            json = this.getJSON(mapping, form, request, response);
            if (Validator.isNotNull((String)callback)) {
                json = String.valueOf(callback) + "(" + json + ");";
            } else if (Validator.isNotNull((String)instance)) {
                json = "var " + instance + "=" + json + ";";
            }
        }
        catch (PrincipalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe.getMessage());
            }
            json = JSONFactoryUtil.serializeException((Exception)((Object)pe));
        }
        catch (Exception e2) {
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
        boolean refresh = ParamUtil.getBoolean((HttpServletRequest)request, (String)"refresh");
        if (refresh) {
            return mapping.findForward("/common/referer_js.jsp");
        }
        if (Validator.isNotNull((String)json)) {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/javascript");
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] bytes = json.getBytes("UTF-8");
            outputStream.write(bytes);
            outputStream.close();
        }
        return null;
    }

    public abstract String getJSON(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected void checkAuthToken(HttpServletRequest request) throws PortalException {
        String authType = GetterUtil.getString((String)request.getAuthType());
        if (authType.equals("BASIC") || authType.equals("DIGEST")) {
            return;
        }
        if (PropsValues.AUTH_TOKEN_CHECK_ENABLED && PropsValues.JSON_SERVICE_AUTH_TOKEN_ENABLED && !this.isAccessAllowed(request, this._hostsAllowed)) {
            AuthTokenUtil.check((HttpServletRequest)request);
        }
    }

    protected String getReroutePath() {
        return null;
    }

    protected boolean isAccessAllowed(HttpServletRequest request, Set<String> hostsAllowed) {
        if (hostsAllowed.isEmpty()) {
            return true;
        }
        String remoteAddr = request.getRemoteAddr();
        if (hostsAllowed.contains(remoteAddr)) {
            return true;
        }
        String computerAddress = PortalUtil.getComputerAddress();
        return computerAddress.equals(remoteAddr) && hostsAllowed.contains(_SERVER_IP);
    }

    protected boolean rerouteExecute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String servletContextName;
        String reroutePath = this.getReroutePath();
        if (Validator.isNull((String)reroutePath)) {
            return false;
        }
        String requestServletContextName = ParamUtil.getString((HttpServletRequest)request, (String)"servletContextName");
        if (Validator.isNull((String)requestServletContextName)) {
            return false;
        }
        ServletContext servletContext = this._servletContext;
        if (servletContext == null) {
            servletContext = (ServletContext)request.getAttribute("CTX");
        }
        if ((servletContextName = GetterUtil.getString((String)servletContext.getServletContextName())).equals(requestServletContextName)) {
            return false;
        }
        ServletContext requestServletContext = ServletContextPool.get((String)requestServletContextName);
        if (requestServletContext == null) {
            return false;
        }
        RequestDispatcher requestDispatcher = requestServletContext.getRequestDispatcher(reroutePath);
        if (requestDispatcher == null) {
            return false;
        }
        requestDispatcher.forward((ServletRequest)new SharedSessionServletRequest(request, true), (ServletResponse)response);
        return true;
    }
}

