/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Release;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.ReleaseLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.lang.time.StopWatch;

public class DBUpgrader {
    private static final String _DELETE_TEMP_IMAGES_1 = "delete from Image where imageId IN (SELECT articleImageId FROM JournalArticleImage where tempImage = TRUE)";
    private static final String _DELETE_TEMP_IMAGES_2 = "delete from JournalArticleImage where tempImage = TRUE";
    private static Log _log = LogFactoryUtil.getLog(DBUpgrader.class);

    public static void main(String[] args) {
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            InitUtil.initWithSpring();
            DBUpgrader.upgrade();
            DBUpgrader.verify();
            System.out.println("\nSuccessfully completed upgrade process in " + stopWatch.getTime() / 1000L + " seconds.");
            System.exit(0);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
    }

    public static void upgrade() throws Exception {
        int buildNumber;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Disable cache registry");
        }
        CacheRegistryUtil.setActive((boolean)false);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Run upgrade process");
        }
        if ((buildNumber = ReleaseLocalServiceUtil.getBuildNumberOrCreate()) > ReleaseInfo.getParentBuildNumber()) {
            StringBundler sb = new StringBundler(6);
            sb.append("Attempting to deploy an older Liferay Portal version. ");
            sb.append("Current build version is ");
            sb.append(buildNumber);
            sb.append(" and attempting to deploy version ");
            sb.append(ReleaseInfo.getParentBuildNumber());
            sb.append(".");
            throw new IllegalStateException(sb.toString());
        }
        if (buildNumber < 5000) {
            String msg = "You must first upgrade to Liferay Portal 5.0.0";
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
        CustomSQLUtil.reloadCustomSQL();
        SQLTransformer.reloadSQLTransformer();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Update build " + buildNumber));
        }
        DBUpgrader._checkReleaseState();
        try {
            StartupHelperUtil.upgradeProcess(buildNumber);
        }
        catch (Exception e2) {
            DBUpgrader._updateReleaseState(1);
            throw e2;
        }
        if (StartupHelperUtil.isUpgraded()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Update company key");
            }
            DBUpgrader._updateCompanyKey();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check class names");
        }
        ClassNameLocalServiceUtil.checkClassNames();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource actions");
        }
        ResourceActionLocalServiceUtil.checkResourceActions();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource codes");
        }
        ResourceCodeLocalServiceUtil.checkResourceCodes();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Delete temporary images");
        }
        DBUpgrader._deleteTempImages();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Clear cache if upgrade process was run");
        }
        if (StartupHelperUtil.isUpgraded()) {
            MultiVMPoolUtil.clear();
        }
    }

    public static void verify() throws Exception {
        Release release = null;
        try {
            release = ReleaseLocalServiceUtil.getRelease((String)"portal", (int)ReleaseInfo.getParentBuildNumber());
        }
        catch (PortalException portalException) {
            release = ReleaseLocalServiceUtil.addRelease((String)"portal", (int)ReleaseInfo.getParentBuildNumber());
        }
        DBUpgrader._checkReleaseState();
        try {
            StartupHelperUtil.verifyProcess(release.isVerified());
        }
        catch (Exception e2) {
            DBUpgrader._updateReleaseState(2);
            throw e2;
        }
        if (PropsValues.DATABASE_INDEXES_UPDATE_ON_STARTUP) {
            StartupHelperUtil.setDropIndexes(true);
            StartupHelperUtil.updateIndexes();
        } else if (StartupHelperUtil.isUpgraded()) {
            StartupHelperUtil.updateIndexes();
        }
        boolean verified = StartupHelperUtil.isVerified();
        if (release.isVerified()) {
            verified = true;
        }
        ReleaseLocalServiceUtil.updateRelease((long)release.getReleaseId(), (int)ReleaseInfo.getParentBuildNumber(), (java.util.Date)ReleaseInfo.getBuildDate(), (boolean)verified);
        CacheRegistryUtil.setActive((boolean)true);
    }

    private static void _checkReleaseState() throws Exception {
        int state = DBUpgrader._getReleaseState();
        if (state == 0) {
            return;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("The database contains changes from a previous ");
        sb.append("upgrade attempt that failed. Please restore the old ");
        sb.append("database and file system and retry the upgrade. A ");
        sb.append("patch may be required if the upgrade failed due to a");
        sb.append(" bug or an unforeseen data permutation that resulted ");
        sb.append("from a corrupt database.");
        throw new IllegalStateException(sb.toString());
    }

    private static void _deleteTempImages() throws Exception {
        DB db = DBFactoryUtil.getDB();
        db.runSQL(_DELETE_TEMP_IMAGES_1);
        db.runSQL(_DELETE_TEMP_IMAGES_2);
    }

    private static int _getReleaseState() throws Exception {
        block3: {
            int n;
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select state_ from Release_ where releaseId = ?");
                ps.setLong(1, 1L);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt("state_");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return n;
        }
        throw new IllegalArgumentException("No Release exists with the primary key 1");
    }

    private static void _updateCompanyKey() throws Exception {
        DB db = DBFactoryUtil.getDB();
        db.runSQL("update Company set key_ = null");
    }

    private static void _updateReleaseState(int state) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update Release_ set modifiedDate = ?, state_ = ? where releaseId = ?");
            ps.setDate(1, new Date(System.currentTimeMillis()));
            ps.setInt(2, state);
            ps.setLong(3, 1L);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

