/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import com.liferay.portal.util.InitUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.TypeVariable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class InstanceWrapperBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 1) {
            throw new IllegalArgumentException();
        }
        new InstanceWrapperBuilder(args[0]);
    }

    public InstanceWrapperBuilder(String xml) {
        try {
            File file = new File(xml);
            Document document = SAXReaderUtil.read((File)file);
            Element rootElement = document.getRootElement();
            List instanceWrapperElements = rootElement.elements("instance-wrapper");
            for (Element instanceWrapperElement : instanceWrapperElements) {
                String parentDir = instanceWrapperElement.attributeValue("parent-dir");
                String srcFile = instanceWrapperElement.attributeValue("src-file");
                this._createIW(parentDir, srcFile);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void _createIW(String parentDir, String srcFile) throws IOException {
        JavaClass javaClass = this._getJavaClass(parentDir, srcFile);
        JavaMethod[] javaMethods = javaClass.getMethods();
        StringBuilder sb = new StringBuilder();
        sb.append("package " + javaClass.getPackage().getName() + ";");
        sb.append("public class " + javaClass.getName() + "_IW {");
        sb.append("public static " + javaClass.getName() + "_IW getInstance() {");
        sb.append("return _instance;");
        sb.append("}\n");
        JavaMethod[] javaMethodArray = javaMethods;
        int n = javaMethods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = javaMethodArray[n2];
            String methodName = javaMethod.getName();
            if (javaMethod.isPublic() && javaMethod.isStatic()) {
                DocletTag[] docletTags;
                if (methodName.equals("getInstance")) {
                    methodName = "getWrappedInstance";
                }
                if ((docletTags = javaMethod.getTagsByName("deprecated")) != null && docletTags.length > 0) {
                    sb.append("\t/**\n");
                    sb.append("\t * @deprecated\n");
                    sb.append("\t */\n");
                }
                sb.append("public ");
                TypeVariable[] typeParameters = javaMethod.getTypeParameters();
                if (typeParameters.length > 0) {
                    sb.append(" <");
                    int i2 = 0;
                    while (i2 < typeParameters.length) {
                        TypeVariable typeParameter = typeParameters[i2];
                        sb.append(typeParameter.getName());
                        if (i2 + 1 != typeParameters.length) {
                            sb.append(", ");
                        }
                        ++i2;
                    }
                    sb.append("> ");
                }
                sb.append(String.valueOf(this._getTypeGenericsName(javaMethod.getReturns())) + " " + methodName + "(");
                JavaParameter[] javaParameters = javaMethod.getParameters();
                int i3 = 0;
                while (i3 < javaParameters.length) {
                    JavaParameter javaParameter = javaParameters[i3];
                    sb.append(this._getTypeGenericsName(javaParameter.getType()));
                    if (javaParameter.isVarArgs()) {
                        sb.append("...");
                    }
                    sb.append(" " + javaParameter.getName());
                    if (i3 + 1 != javaParameters.length) {
                        sb.append(", ");
                    }
                    ++i3;
                }
                sb.append(")");
                Type[] thrownExceptions = javaMethod.getExceptions();
                LinkedHashSet<String> newExceptions = new LinkedHashSet<String>();
                int j = 0;
                while (j < thrownExceptions.length) {
                    Type thrownException = thrownExceptions[j];
                    newExceptions.add(thrownException.getValue());
                    ++j;
                }
                if (newExceptions.size() > 0) {
                    sb.append(" throws ");
                    Iterator itr = newExceptions.iterator();
                    while (itr.hasNext()) {
                        sb.append((String)itr.next());
                        if (!itr.hasNext()) continue;
                        sb.append(", ");
                    }
                }
                sb.append("{\n");
                if (!javaMethod.getReturns().getValue().equals("void")) {
                    sb.append("return ");
                }
                sb.append(String.valueOf(javaClass.getName()) + "." + javaMethod.getName() + "(");
                j = 0;
                while (j < javaParameters.length) {
                    JavaParameter javaParameter = javaParameters[j];
                    sb.append(javaParameter.getName());
                    if (j + 1 != javaParameters.length) {
                        sb.append(", ");
                    }
                    ++j;
                }
                sb.append(");");
                sb.append("}\n");
            }
            ++n2;
        }
        sb.append("private " + javaClass.getName() + "_IW() {");
        sb.append("}");
        sb.append("private static " + javaClass.getName() + "_IW _instance = new " + javaClass.getName() + "_IW();");
        sb.append("}");
        File file = new File(String.valueOf(parentDir) + "/" + StringUtil.replace((String)javaClass.getPackage().getName(), (String)".", (String)"/") + "/" + javaClass.getName() + "_IW.java");
        ServiceBuilder.writeFile(file, sb.toString());
    }

    private String _getDimensions(Type type) {
        String dimensions = "";
        int i2 = 0;
        while (i2 < type.getDimensions()) {
            dimensions = String.valueOf(dimensions) + "[]";
            ++i2;
        }
        return dimensions;
    }

    private JavaClass _getJavaClass(String parentDir, String srcFile) throws IOException {
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new File(String.valueOf(parentDir) + "/" + srcFile));
        return builder.getClassByName(className);
    }

    private String _getTypeGenericsName(Type type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getValue());
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments != null) {
            sb.append("<");
            int i2 = 0;
            while (i2 < actualTypeArguments.length) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(this._getTypeGenericsName(actualTypeArguments[i2]));
                ++i2;
            }
            sb.append(">");
        }
        sb.append(this._getDimensions(type));
        return sb.toString();
    }
}

