/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.util.xml.DocUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocFormatter {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static SAXReaderImpl _saxReaderUtil = SAXReaderImpl.getInstance();
    private boolean _initializeMissingJavadocs;
    private String _inputDir;
    private Map<String, Tuple> _javadocxXmlTuples = new HashMap<String, Tuple>();
    private String _outputFilePrefix;
    private boolean _updateJavadocs;

    public static void main(String[] args) {
        try {
            new JavadocFormatter(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public JavadocFormatter(String[] args) throws Exception {
        int n;
        int n2;
        String[] stringArray;
        String update;
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String init = arguments.get("javadoc.init");
        if (Validator.isNotNull((String)init) && !init.startsWith("$")) {
            this._initializeMissingJavadocs = GetterUtil.getBoolean((String)init);
        }
        this._inputDir = GetterUtil.getString((String)arguments.get("javadoc.input.dir"));
        if (this._inputDir.startsWith("$")) {
            this._inputDir = "./";
        }
        if (!this._inputDir.endsWith("/")) {
            this._inputDir = String.valueOf(this._inputDir) + "/";
        }
        System.out.println("Input directory is " + this._inputDir);
        String limit = arguments.get("javadoc.limit");
        this._outputFilePrefix = GetterUtil.getString((String)arguments.get("javadoc.output.file.prefix"));
        if (this._outputFilePrefix.startsWith("$")) {
            this._outputFilePrefix = "javadocs";
        }
        if (Validator.isNotNull((String)(update = arguments.get("javadoc.update"))) && !update.startsWith("$")) {
            this._updateJavadocs = GetterUtil.getBoolean((String)update);
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this._inputDir);
        directoryScanner.setExcludes(new String[]{"**\\classes\\**", "**\\portal-client\\**"});
        ArrayList<String> includes = new ArrayList<String>();
        if (Validator.isNotNull((String)limit) && !limit.startsWith("$")) {
            String[] limitArray;
            System.out.println("Limit on " + limit);
            stringArray = limitArray = StringUtil.split((String)limit, (char)'/');
            n2 = limitArray.length;
            n = 0;
            while (n < n2) {
                String curLimit = stringArray[n];
                includes.add("**\\" + StringUtil.replace((String)curLimit, (String)".", (String)"\\") + "\\**\\*.java");
                includes.add("**\\" + curLimit + ".java");
                ++n;
            }
        } else {
            includes.add("**\\*.java");
        }
        directoryScanner.setIncludes(includes.toArray(new String[includes.size()]));
        directoryScanner.scan();
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames.length == 0 && Validator.isNotNull((String)limit) && !limit.startsWith("$")) {
            StringBundler sb = new StringBundler("Limit file not found: ");
            sb.append(limit);
            if (limit.contains(".")) {
                sb.append(" Specify limit filename without package path or ");
                sb.append("file type suffix.");
            }
            System.out.println(sb.toString());
        }
        stringArray = fileNames;
        n2 = fileNames.length;
        n = 0;
        while (n < n2) {
            String fileName = stringArray[n];
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            this._format(fileName);
            ++n;
        }
        for (Map.Entry<String, Tuple> entry : this._javadocxXmlTuples.entrySet()) {
            String newJavadocsRuntimeXmlContent;
            Tuple tuple = entry.getValue();
            File javadocsXmlFile = (File)tuple.getObject(1);
            String oldJavadocsXmlContent = (String)tuple.getObject(2);
            Document javadocsXmlDocument = (Document)tuple.getObject(3);
            Element javadocsXmlRootElement = javadocsXmlDocument.getRootElement();
            javadocsXmlRootElement.sortElementsByChildElement("javadoc", "type");
            String newJavadocsXmlContent = javadocsXmlDocument.formattedString();
            if (!oldJavadocsXmlContent.equals(newJavadocsXmlContent)) {
                _fileUtil.write(javadocsXmlFile, newJavadocsXmlContent);
            }
            this._detachUnnecessaryTypes(javadocsXmlRootElement);
            File javadocsRuntimeXmlFile = new File(StringUtil.replaceLast((String)javadocsXmlFile.toString(), (String)"-all.xml", (String)"-rt.xml"));
            String oldJavadocsRuntimeXmlContent = "";
            if (javadocsRuntimeXmlFile.exists()) {
                oldJavadocsRuntimeXmlContent = _fileUtil.read(javadocsRuntimeXmlFile);
            }
            if (oldJavadocsRuntimeXmlContent.equals(newJavadocsRuntimeXmlContent = javadocsXmlDocument.compactString())) continue;
            _fileUtil.write(javadocsRuntimeXmlFile, newJavadocsRuntimeXmlContent);
        }
    }

    private void _addClassCommentElement(Element rootElement, JavaClass javaClass) {
        String comment = this._getCDATA((AbstractJavaEntity)javaClass);
        if (comment.startsWith("Copyright (c) 2000-2010 Liferay, Inc.")) {
            comment = "";
        }
        if (Validator.isNull((String)comment)) {
            return;
        }
        Element commentElement = rootElement.addElement("comment");
        commentElement.addCDATA(comment);
    }

    private void _addDocletElements(Element parentElement, AbstractJavaEntity abstractJavaEntity, String name) throws Exception {
        DocletTag[] docletTags;
        DocletTag[] docletTagArray = docletTags = abstractJavaEntity.getTagsByName(name);
        int n = docletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag docletTag = docletTagArray[n2];
            String value = docletTag.getValue();
            value = this._trimMultilineText(value);
            value = StringUtil.replace((String)value, (String)" </", (String)"</");
            Element element = parentElement.addElement(name);
            element.addCDATA(value);
            ++n2;
        }
        if (docletTags.length == 0 && name.equals("author")) {
            Element element = parentElement.addElement(name);
            element.addCDATA("Brian Wing Shun Chan");
        }
    }

    private String _addDocletTags(Element parentElement, String[] tagNames, String indent, boolean publicAccess) {
        ArrayList<String> allTagNames = new ArrayList<String>();
        ArrayList<String> commonTagNamesWithComments = new ArrayList<String>();
        ArrayList<String> customTagNames = new ArrayList<String>();
        String[] stringArray = tagNames;
        int n = tagNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tagName = stringArray[n2];
            List elements = parentElement.elements(tagName);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                if (tagName.equals("param") || tagName.equals("return") || tagName.equals("throws")) {
                    if (Validator.isNotNull((String)comment)) {
                        commonTagNamesWithComments.add(tagName);
                    }
                } else {
                    customTagNames.add(tagName);
                }
                allTagNames.add(tagName);
            }
            ++n2;
        }
        int maxTagNameLength = 0;
        ArrayList<String> maxTagNameLengthTags = new ArrayList<String>();
        if (this._initializeMissingJavadocs) {
            maxTagNameLengthTags.addAll(allTagNames);
        } else if (this._updateJavadocs) {
            if (!commonTagNamesWithComments.isEmpty()) {
                maxTagNameLengthTags.addAll(allTagNames);
            } else {
                maxTagNameLengthTags.addAll(commonTagNamesWithComments);
                maxTagNameLengthTags.addAll(customTagNames);
            }
        } else {
            maxTagNameLengthTags.addAll(commonTagNamesWithComments);
            maxTagNameLengthTags.addAll(customTagNames);
        }
        for (String name : maxTagNameLengthTags) {
            if (name.length() <= maxTagNameLength) continue;
            maxTagNameLength = name.length();
        }
        String tagNameIndent = this._getSpacesIndent(maxTagNameLength += 2);
        StringBundler sb = new StringBundler();
        String[] stringArray2 = tagNames;
        int n3 = tagNames.length;
        int n4 = 0;
        while (n4 < n3) {
            String tagName = stringArray2[n4];
            List elements = parentElement.elements(tagName);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                String elementName = null;
                if (commentElement != null) {
                    elementName = element.elementText("name");
                }
                if (Validator.isNotNull((String)comment)) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (this._initializeMissingJavadocs && publicAccess) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (this._updateJavadocs && publicAccess) {
                    if (!(tagName.equals("param") || tagName.equals("return") || tagName.equals("throws"))) {
                        comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                        sb.append(comment);
                        continue;
                    }
                    if (commonTagNamesWithComments.isEmpty()) continue;
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (tagName.equals("param") || tagName.equals("return") || tagName.equals("throws")) continue;
                comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                sb.append(comment);
            }
            ++n4;
        }
        return sb.toString();
    }

    private void _addFieldElement(Element rootElement, JavaField javaField) throws Exception {
        Element fieldElement = rootElement.addElement("field");
        DocUtil.add((Element)fieldElement, (String)"name", (String)javaField.getName());
        String comment = this._getCDATA((AbstractJavaEntity)javaField);
        if (Validator.isNotNull((String)comment)) {
            Element commentElement = fieldElement.addElement("comment");
            commentElement.addCDATA(comment);
        }
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "version");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "see");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "since");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "deprecated");
    }

    private void _addMethodElement(Element rootElement, JavaMethod javaMethod) throws Exception {
        Element methodElement = rootElement.addElement("method");
        DocUtil.add((Element)methodElement, (String)"name", (String)javaMethod.getName());
        String comment = this._getCDATA((AbstractJavaEntity)javaMethod);
        if (Validator.isNotNull((String)comment)) {
            Element commentElement = methodElement.addElement("comment");
            commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaMethod));
        }
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "version");
        this._addParamElements(methodElement, javaMethod);
        this._addReturnElement(methodElement, javaMethod);
        this._addThrowsElements(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "see");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "since");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "deprecated");
    }

    private void _addParamElement(Element methodElement, JavaParameter javaParameter, DocletTag[] paramDocletTags) {
        String name = javaParameter.getName();
        String value = null;
        DocletTag[] docletTagArray = paramDocletTags;
        int n = paramDocletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag paramDocletTag = docletTagArray[n2];
            String curValue = paramDocletTag.getValue();
            if (curValue.startsWith(name)) {
                value = curValue;
                break;
            }
            ++n2;
        }
        Element paramElement = methodElement.addElement("param");
        DocUtil.add((Element)paramElement, (String)"name", (String)name);
        DocUtil.add((Element)paramElement, (String)"type", (String)this._getTypeValue(javaParameter));
        if (value != null) {
            value = value.substring(name.length());
        }
        if (Validator.isNotNull((String)(value = this._trimMultilineText(value)))) {
            Element commentElement = paramElement.addElement("comment");
            commentElement.addCDATA(value);
        }
    }

    private void _addParamElements(Element methodElement, JavaMethod javaMethod) {
        JavaParameter[] javaParameters = javaMethod.getParameters();
        DocletTag[] paramDocletTags = javaMethod.getTagsByName("param");
        JavaParameter[] javaParameterArray = javaParameters;
        int n = javaParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JavaParameter javaParameter = javaParameterArray[n2];
            this._addParamElement(methodElement, javaParameter, paramDocletTags);
            ++n2;
        }
    }

    private void _addReturnElement(Element methodElement, JavaMethod javaMethod) throws Exception {
        Type returns = javaMethod.getReturns();
        if (returns == null) {
            return;
        }
        String returnsValue = returns.getValue();
        if (returnsValue.equals("void")) {
            return;
        }
        DocletTag[] returnDocletTags = javaMethod.getTagsByName("return");
        String comment = "";
        if (returnDocletTags.length > 0) {
            DocletTag returnDocletTag = returnDocletTags[0];
            comment = GetterUtil.getString((String)returnDocletTag.getValue());
        }
        if (Validator.isNotNull((String)(comment = this._trimMultilineText(comment)))) {
            Element returnElement = methodElement.addElement("return");
            Element commentElement = returnElement.addElement("comment");
            commentElement.addCDATA(comment);
        }
    }

    private void _addThrowsElement(Element methodElement, Type exceptionType, DocletTag[] throwsDocletTags) {
        JavaClass javaClass = exceptionType.getJavaClass();
        String name = javaClass.getName();
        String value = null;
        DocletTag[] docletTagArray = throwsDocletTags;
        int n = throwsDocletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag throwsDocletTag = docletTagArray[n2];
            String curValue = throwsDocletTag.getValue();
            if (curValue.startsWith(name)) {
                value = curValue;
                break;
            }
            ++n2;
        }
        Element throwsElement = methodElement.addElement("throws");
        DocUtil.add((Element)throwsElement, (String)"name", (String)name);
        DocUtil.add((Element)throwsElement, (String)"type", (String)exceptionType.getValue());
        if (value != null) {
            value = value.substring(name.length());
        }
        if (Validator.isNotNull((String)(value = this._trimMultilineText(value)))) {
            Element commentElement = throwsElement.addElement("comment");
            commentElement.addCDATA(this._getCDATA(value));
        }
    }

    private void _addThrowsElements(Element methodElement, JavaMethod javaMethod) {
        Type[] exceptionTypes = javaMethod.getExceptions();
        DocletTag[] throwsDocletTags = javaMethod.getTagsByName("throws");
        Type[] typeArray = exceptionTypes;
        int n = exceptionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type exceptionType = typeArray[n2];
            this._addThrowsElement(methodElement, exceptionType, throwsDocletTags);
            ++n2;
        }
    }

    private String _assembleTagComment(String tagName, String elementName, String comment, String indent, String tagNameIndent) {
        String indentAndTagName = String.valueOf(indent) + "@" + tagName;
        if (Validator.isNotNull((String)elementName)) {
            comment = Validator.isNotNull((String)comment) ? String.valueOf(elementName) + " " + comment : elementName;
            comment = this._wrapText(comment, String.valueOf(indent) + tagNameIndent);
            comment = String.valueOf(indentAndTagName) + comment.substring(indentAndTagName.length());
        } else if (Validator.isNotNull((String)comment)) {
            comment = this._wrapText(comment, String.valueOf(indent) + tagNameIndent);
            comment = String.valueOf(indentAndTagName) + comment.substring(indentAndTagName.length());
        } else {
            comment = String.valueOf(indentAndTagName) + "\n";
        }
        return comment;
    }

    private void _detachUnnecessaryTypes(Element rootElement) {
        List elements = rootElement.elements();
        for (Element element : elements) {
            String type = element.elementText("type");
            if (type.contains(".service.") && type.endsWith("ServiceImpl")) continue;
            element.detach();
        }
    }

    private void _format(String fileName) throws Exception {
        FileInputStream inputStream = new FileInputStream(String.valueOf(this._inputDir) + fileName);
        byte[] bytes = new byte[((InputStream)inputStream).available()];
        ((InputStream)inputStream).read(bytes);
        ((InputStream)inputStream).close();
        String originalContent = new String(bytes, "UTF-8");
        if (fileName.endsWith("JavadocFormatter.java") || fileName.endsWith("SourceFormatter.java") || this._hasGeneratedTag(originalContent)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(originalContent));
        String javadocLessContent = this._removeJavadocFromJava(javaClass, originalContent);
        Document document = this._getJavadocDocument(javaClass);
        this._updateJavadocsXmlFile(fileName, javaClass, document);
        this._updateJavaFromDocument(fileName, originalContent, javadocLessContent, document);
    }

    private String _formatInlines(String text) {
        text = text.replaceAll("(?i)\\bid(s)?\\b", "ID$1");
        text = text.replaceAll("(?i)(?<!<code>|\\w)(null|false|true)(?!\\w)", "<code>$1</code>");
        return text;
    }

    private List<JavaClass> _getAncestorJavaClasses(JavaClass javaClass) {
        ArrayList<JavaClass> ancestorJavaClasses = new ArrayList<JavaClass>();
        while ((javaClass = javaClass.getSuperJavaClass()) != null) {
            ancestorJavaClasses.add(javaClass);
        }
        return ancestorJavaClasses;
    }

    private String _getCDATA(AbstractJavaEntity abstractJavaEntity) {
        return this._getCDATA(abstractJavaEntity.getComment());
    }

    private String _getCDATA(String cdata) {
        if (cdata == null) {
            return "";
        }
        cdata = cdata.replaceAll("(?s)\\s*<(p|pre|[ou]l)>\\s*(.*?)\\s*</\\1>\\s*", "\n\n<$1>\n$2\n</$1>\n\n");
        cdata = cdata.replaceAll("(?s)\\s*<li>\\s*(.*?)\\s*</li>\\s*", "\n<li>\n$1\n</li>\n");
        cdata = StringUtil.replace((String)cdata, (String)"</li>\n\n<li>", (String)"</li>\n<li>");
        cdata = cdata.replaceAll("\n\\s+\n", "\n\n");
        cdata = cdata.replaceAll(" +", " ");
        Pattern pattern = Pattern.compile("(^.*?(?=\n\n|$)+|(?<=<p>\n).*?(?=\n</p>))", 32);
        Matcher matcher = pattern.matcher(cdata);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String trimmed = this._trimMultilineText(matcher.group());
            trimmed = trimmed.replaceAll("\\$", "\\\\\\$");
            matcher.appendReplacement(sb, trimmed);
        }
        matcher.appendTail(sb);
        cdata = sb.toString();
        return cdata.trim();
    }

    private String _getClassName(String fileName) {
        int pos = fileName.indexOf("src/");
        if (pos == -1) {
            pos = fileName.indexOf("test/");
        }
        if (pos == -1) {
            pos = fileName.indexOf("service/");
        }
        if (pos == -1) {
            throw new RuntimeException(fileName);
        }
        pos = fileName.indexOf("/", pos);
        String srcFile = fileName.substring(pos + 1, fileName.length());
        return StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
    }

    private String _getFieldKey(Element fieldElement) {
        return fieldElement.elementText("name");
    }

    private String _getFieldKey(JavaField javaField) {
        return javaField.getName();
    }

    private String _getIndent(String[] lines, AbstractBaseJavaEntity abstractBaseJavaEntity) {
        String line = lines[abstractBaseJavaEntity.getLineNumber() - 1];
        String indent = "";
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (!Character.isWhitespace(c2)) break;
            indent = String.valueOf(indent) + c2;
            ++n2;
        }
        return indent;
    }

    private int _getIndentLength(String indent) {
        int indentLength = 0;
        char[] cArray = indent.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            indentLength = c2 == '\t' ? (indentLength += 4) : ++indentLength;
            ++n2;
        }
        return indentLength;
    }

    private JavaClass _getJavaClass(String fileName, Reader reader) throws Exception {
        String className = this._getClassName(fileName);
        JavaDocBuilder javadocBuilder = new JavaDocBuilder();
        if (reader == null) {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            javadocBuilder.addSource(file);
        } else {
            javadocBuilder.addSource(reader);
        }
        return javadocBuilder.getClassByName(className);
    }

    private String _getJavaClassComment(Element rootElement, JavaClass javaClass) {
        String docletTags;
        StringBundler sb = new StringBundler();
        String indent = "";
        sb.append("/**\n");
        String comment = rootElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, String.valueOf(indent) + " * "));
        }
        if (Validator.isNotNull((String)(docletTags = this._addDocletTags(rootElement, new String[]{"author", "version", "see", "since", "serial", "deprecated"}, String.valueOf(indent) + " * ", this._hasPublicModifier((AbstractJavaEntity)javaClass))))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private int _getJavaClassLineNumber(JavaClass javaClass) {
        int lineNumber = javaClass.getLineNumber();
        Annotation[] annotations = javaClass.getAnnotations();
        if (annotations.length == 0) {
            return lineNumber;
        }
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            int annotationLineNumber = annotation.getLineNumber();
            Map propertyMap = annotation.getPropertyMap();
            if (propertyMap.isEmpty()) {
                --annotationLineNumber;
            }
            if (annotationLineNumber < lineNumber) {
                lineNumber = annotationLineNumber;
            }
            ++n2;
        }
        return lineNumber;
    }

    private Document _getJavadocDocument(JavaClass javaClass) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        Element rootElement = _saxReaderUtil.createElement("javadoc");
        Document document = _saxReaderUtil.createDocument(rootElement);
        DocUtil.add((Element)rootElement, (String)"name", (String)javaClass.getName());
        DocUtil.add((Element)rootElement, (String)"type", (String)javaClass.getFullyQualifiedName());
        this._addClassCommentElement(rootElement, javaClass);
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "author");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "version");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "see");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "since");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "serial");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "deprecated");
        JavaMethod[] javaMethodArray = javaMethods = javaClass.getMethods();
        int n = javaMethods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = javaMethodArray[n2];
            this._addMethodElement(rootElement, javaMethod);
            ++n2;
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int n3 = javaFields.length;
        n = 0;
        while (n < n3) {
            JavaField javaField = javaFieldArray[n];
            this._addFieldElement(rootElement, javaField);
            ++n;
        }
        return document;
    }

    private Tuple _getJavadocsXmlTuple(String fileName) throws Exception {
        File file = new File(String.valueOf(this._inputDir) + fileName);
        String absolutePath = file.getAbsolutePath();
        absolutePath = StringUtil.replace((String)absolutePath, (String)"\\", (String)"/");
        absolutePath = StringUtil.replace((String)absolutePath, (String)"/./", (String)"/");
        int pos = absolutePath.indexOf("/portal-impl/src/");
        String srcDirName = null;
        if (pos != -1) {
            srcDirName = absolutePath.substring(0, pos + 17);
        }
        if (srcDirName == null) {
            pos = absolutePath.indexOf("/portal-kernel/src/");
            if (pos == -1) {
                pos = absolutePath.indexOf("/portal-service/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-bridges/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-java/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-taglib/src/");
            }
            if (pos != -1) {
                srcDirName = String.valueOf(absolutePath.substring(0, pos)) + "/portal-impl/src/";
            }
        }
        if (srcDirName == null && (pos = absolutePath.indexOf("/WEB-INF/src/")) != -1) {
            srcDirName = absolutePath.substring(0, pos + 13);
        }
        if (srcDirName == null) {
            return null;
        }
        Tuple tuple = this._javadocxXmlTuples.get(srcDirName);
        if (tuple != null) {
            return tuple;
        }
        File javadocsXmlFile = new File(srcDirName, "META-INF/" + this._outputFilePrefix + "-all.xml");
        if (!javadocsXmlFile.exists()) {
            _fileUtil.write(javadocsXmlFile, "<?xml version=\"1.0\"?>\n\n<javadocs>\n</javadocs>");
        }
        String javadocsXmlContent = _fileUtil.read(javadocsXmlFile);
        Document javadocsXmlDocument = _saxReaderUtil.read(javadocsXmlContent);
        tuple = new Tuple(new Object[]{srcDirName, javadocsXmlFile, javadocsXmlContent, javadocsXmlDocument});
        this._javadocxXmlTuples.put(srcDirName, tuple);
        return tuple;
    }

    private String _getJavaFieldComment(String[] lines, Map<String, Element> fieldElementsMap, JavaField javaField) {
        String docletTags;
        String fieldKey = this._getFieldKey(javaField);
        Element fieldElement = fieldElementsMap.get(fieldKey);
        if (fieldElement == null) {
            return null;
        }
        String indent = this._getIndent(lines, (AbstractBaseJavaEntity)javaField);
        StringBundler sb = new StringBundler();
        sb.append(indent);
        sb.append("/**\n");
        String comment = fieldElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, String.valueOf(indent) + " * "));
        }
        if (Validator.isNotNull((String)(docletTags = this._addDocletTags(fieldElement, new String[]{"version", "see", "since", "deprecated"}, String.valueOf(indent) + " * ", this._hasPublicModifier((AbstractJavaEntity)javaField))))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier((AbstractJavaEntity)javaField) && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getJavaMethodComment(String[] lines, Map<String, Element> methodElementsMap, JavaMethod javaMethod) {
        String docletTags;
        String methodKey = this._getMethodKey(javaMethod);
        Element methodElement = methodElementsMap.get(methodKey);
        if (methodElement == null) {
            return null;
        }
        String indent = this._getIndent(lines, (AbstractBaseJavaEntity)javaMethod);
        StringBundler sb = new StringBundler();
        sb.append(indent);
        sb.append("/**\n");
        String comment = methodElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, String.valueOf(indent) + " * "));
        }
        if (Validator.isNotNull((String)(docletTags = this._addDocletTags(methodElement, new String[]{"version", "param", "return", "throws", "see", "since", "deprecated"}, String.valueOf(indent) + " * ", this._hasPublicModifier((AbstractJavaEntity)javaMethod))))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier((AbstractJavaEntity)javaMethod) && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getMethodKey(Element methodElement) {
        StringBundler sb = new StringBundler();
        sb.append(methodElement.elementText("name"));
        sb.append("(");
        List paramElements = methodElement.elements("param");
        for (Element paramElement : paramElements) {
            sb.append(paramElement.elementText("name"));
            sb.append("|");
            sb.append(paramElement.elementText("type"));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getMethodKey(JavaMethod javaMethod) {
        JavaParameter[] javaParameters;
        StringBundler sb = new StringBundler();
        sb.append(javaMethod.getName());
        sb.append("(");
        JavaParameter[] javaParameterArray = javaParameters = javaMethod.getParameters();
        int n = javaParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JavaParameter javaParameter = javaParameterArray[n2];
            sb.append(javaParameter.getName());
            sb.append("|");
            sb.append(this._getTypeValue(javaParameter));
            sb.append(",");
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getSpacesIndent(int length) {
        String indent = "";
        int i2 = 0;
        while (i2 < length) {
            indent = String.valueOf(indent) + " ";
            ++i2;
        }
        return indent;
    }

    private String _getTypeValue(JavaParameter javaParameter) {
        Type type = javaParameter.getType();
        String typeValue = type.getValue();
        if (type.isArray()) {
            typeValue = String.valueOf(typeValue) + "[]";
        }
        return typeValue;
    }

    private boolean _hasAnnotation(AbstractBaseJavaEntity abstractBaseJavaEntity, String annotationName) {
        Annotation[] annotations = abstractBaseJavaEntity.getAnnotations();
        if (annotations == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < annotations.length) {
            Type type = annotations[i2].getType();
            JavaClass javaClass = type.getJavaClass();
            if (annotationName.equals(javaClass.getName())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean _hasGeneratedTag(String content) {
        return content.contains("* @generated") || content.contains("$ANTLR");
    }

    private boolean _hasPublicModifier(AbstractJavaEntity abstractJavaEntity) {
        String[] modifiers = abstractJavaEntity.getModifiers();
        if (modifiers == null) {
            return false;
        }
        String[] stringArray = modifiers;
        int n = modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String modifier = stringArray[n2];
            if (modifier.equals("public")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean _isOverrideMethod(JavaClass javaClass, JavaMethod javaMethod, Collection<JavaClass> ancestorJavaClasses) {
        if (javaClass.isInterface() || javaMethod.isConstructor() || javaMethod.isPrivate() || javaMethod.isStatic()) {
            return false;
        }
        String methodName = javaMethod.getName();
        JavaParameter[] javaParameters = javaMethod.getParameters();
        Type[] types = new Type[javaParameters.length];
        int i2 = 0;
        while (i2 < javaParameters.length) {
            types[i2] = javaParameters[i2].getType();
            ++i2;
        }
        for (JavaClass ancestorJavaClass : ancestorJavaClasses) {
            JavaMethod ancestorJavaMethod = ancestorJavaClass.getMethodBySignature(methodName, types);
            if (ancestorJavaMethod == null) continue;
            boolean samePackage = false;
            JavaPackage ancestorJavaPackage = ancestorJavaClass.getPackage();
            if (ancestorJavaPackage != null) {
                samePackage = ancestorJavaPackage.equals((Object)javaClass.getPackage());
            }
            if (samePackage) {
                return !ancestorJavaMethod.isPrivate();
            }
            return ancestorJavaMethod.isProtected() || ancestorJavaMethod.isPublic();
        }
        return false;
    }

    private String _removeJavadocFromJava(JavaClass javaClass, String content) {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        lineNumbers.add(this._getJavaClassLineNumber(javaClass));
        JavaMethod[] javaMethodArray = javaMethods = javaClass.getMethods();
        int n = javaMethods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = javaMethodArray[n2];
            lineNumbers.add(javaMethod.getLineNumber());
            ++n2;
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int n3 = javaFields.length;
        n = 0;
        while (n < n3) {
            JavaField javaField = javaFieldArray[n];
            lineNumbers.add(javaField.getLineNumber());
            ++n;
        }
        String[] lines = StringUtil.splitLines((String)content);
        Iterator iterator = lineNumbers.iterator();
        block2: while (iterator.hasNext()) {
            int pos;
            String line;
            int lineNumber = (Integer)iterator.next();
            if (lineNumber == 0 || (line = lines[pos = lineNumber - 2]) == null || !(line = line.trim()).endsWith("*/")) continue;
            while (true) {
                lines[pos] = null;
                if (line.startsWith("/**")) continue block2;
                line = lines[--pos].trim();
            }
        }
        StringBundler sb = new StringBundler(content.length());
        String[] stringArray = lines;
        int n4 = lines.length;
        int n5 = 0;
        while (n5 < n4) {
            String line = stringArray[n5];
            if (line != null) {
                sb.append(line);
                sb.append("\n");
            }
            ++n5;
        }
        return sb.toString().trim();
    }

    private String _trimMultilineText(String text) {
        Object[] textArray = StringUtil.splitLines((String)text);
        int i2 = 0;
        while (i2 < textArray.length) {
            textArray[i2] = ((String)textArray[i2]).trim();
            ++i2;
        }
        return StringUtil.merge((Object[])textArray, (String)" ");
    }

    private void _updateJavadocsXmlFile(String fileName, JavaClass javaClass, Document javaClassDocument) throws Exception {
        String javaClassFullyQualifiedName = javaClass.getFullyQualifiedName();
        Tuple javadocsXmlTuple = this._getJavadocsXmlTuple(fileName);
        if (javadocsXmlTuple == null) {
            return;
        }
        Document javadocsXmlDocument = (Document)javadocsXmlTuple.getObject(3);
        Element javadocsXmlRootElement = javadocsXmlDocument.getRootElement();
        List javadocElements = javadocsXmlRootElement.elements("javadoc");
        for (Element javadocElement : javadocElements) {
            String type = javadocElement.elementText("type");
            if (!type.equals(javaClassFullyQualifiedName)) continue;
            Element javaClassRootElement = javaClassDocument.getRootElement();
            if (Validator.equals((Object)javadocElement.formattedString(), (Object)javaClassRootElement.formattedString())) {
                return;
            }
            javadocElement.detach();
            break;
        }
        javadocsXmlRootElement.add(javaClassDocument.getRootElement());
    }

    private void _updateJavaFromDocument(String fileName, String originalContent, String javadocLessContent, Document document) throws Exception {
        JavaField[] javaFields;
        String[] lines = StringUtil.splitLines((String)javadocLessContent);
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(javadocLessContent));
        List<JavaClass> ancestorJavaClasses = this._getAncestorJavaClasses(javaClass);
        Element rootElement = document.getRootElement();
        TreeMap<Integer, String> commentsMap = new TreeMap<Integer, String>();
        commentsMap.put(this._getJavaClassLineNumber(javaClass), this._getJavaClassComment(rootElement, javaClass));
        HashMap<String, Element> methodElementsMap = new HashMap<String, Element>();
        List methodElements = rootElement.elements("method");
        for (Element methodElement : methodElements) {
            String methodKey = this._getMethodKey(methodElement);
            methodElementsMap.put(methodKey, methodElement);
        }
        JavaMethod[] javaMethods = javaClass.getMethods();
        JavaMethod[] javaMethodArray = javaMethods;
        int n = javaMethods.length;
        int methodKey = 0;
        while (methodKey < n) {
            JavaMethod javaMethod = javaMethodArray[methodKey];
            if (!commentsMap.containsKey(javaMethod.getLineNumber())) {
                String javaMethodComment = this._getJavaMethodComment(lines, methodElementsMap, javaMethod);
                if (!this._hasAnnotation((AbstractBaseJavaEntity)javaMethod, "Override") && this._isOverrideMethod(javaClass, javaMethod, ancestorJavaClasses)) {
                    String overrideLine = String.valueOf(this._getIndent(lines, (AbstractBaseJavaEntity)javaMethod)) + "@Override\n";
                    javaMethodComment = Validator.isNotNull((String)javaMethodComment) ? String.valueOf(javaMethodComment) + overrideLine : overrideLine;
                }
                commentsMap.put(javaMethod.getLineNumber(), javaMethodComment);
            }
            ++methodKey;
        }
        HashMap<String, Element> fieldElementsMap = new HashMap<String, Element>();
        List fieldElements = rootElement.elements("field");
        for (Element fieldElement : fieldElements) {
            String fieldKey = this._getFieldKey(fieldElement);
            fieldElementsMap.put(fieldKey, fieldElement);
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int overrideLine = javaFields.length;
        int fieldKey = 0;
        while (fieldKey < overrideLine) {
            JavaField javaField = javaFieldArray[fieldKey];
            if (!commentsMap.containsKey(javaField.getLineNumber())) {
                commentsMap.put(javaField.getLineNumber(), this._getJavaFieldComment(lines, fieldElementsMap, javaField));
            }
            ++fieldKey;
        }
        StringBundler sb = new StringBundler(javadocLessContent.length());
        int lineNumber = 1;
        while (lineNumber <= lines.length) {
            String line = lines[lineNumber - 1];
            String comments = (String)commentsMap.get(lineNumber);
            if (comments != null) {
                sb.append(comments);
            }
            sb.append(line);
            sb.append("\n");
            ++lineNumber;
        }
        String formattedContent = sb.toString().trim();
        if (!originalContent.equals(formattedContent)) {
            File file = new File(String.valueOf(this._inputDir) + fileName);
            _fileUtil.write(file, formattedContent.getBytes("UTF-8"));
            System.out.println("Writing " + file);
        }
    }

    private String _wrapText(String text, String indent) {
        int indentLength = this._getIndentLength(indent);
        if (text.contains("<pre>")) {
            Pattern pattern = Pattern.compile("(?<=^|</pre>).+?(?=$|<pre>)", 32);
            Matcher matcher = pattern.matcher(text);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String wrapped = this._formatInlines(matcher.group());
                wrapped = StringUtil.wrap((String)wrapped, (int)(80 - indentLength), (String)"\n");
                matcher.appendReplacement(sb, wrapped);
            }
            matcher.appendTail(sb);
            sb.append("\n");
            text = sb.toString();
        } else {
            text = this._formatInlines(text);
            text = StringUtil.wrap((String)text, (int)(80 - indentLength), (String)"\n");
        }
        text = text.replaceAll("(?m)^", indent);
        text = text.replaceAll("(?m) +$", "");
        return text;
    }
}

