/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.DirectoryScanner;

public class PluginsSummaryBuilder {
    private Set<String> _distinctAuthors = new TreeSet<String>();
    private Set<String> _distinctLicenses = new TreeSet<String>();
    private File _pluginsDir;

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        File pluginsDir = new File(System.getProperty("plugins.dir"));
        new PluginsSummaryBuilder(pluginsDir);
    }

    public PluginsSummaryBuilder(File pluginsDir) {
        try {
            this._pluginsDir = pluginsDir;
            this._createPluginsSummary();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void _createPluginsSummary() throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("<plugins-summary>\n");
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this._pluginsDir);
        directoryScanner.setExcludes(new String[]{"**\\tmp\\**", "**\\tools\\**"});
        directoryScanner.setIncludes(new String[]{"**\\liferay-plugin-package.properties"});
        directoryScanner.scan();
        Object[] fileNames = directoryScanner.getIncludedFiles();
        Arrays.sort(fileNames);
        Object[] objectArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object fileName = objectArray[n2];
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            this._createPluginSummary((String)fileName, sb);
            ++n2;
        }
        for (String author : this._distinctAuthors) {
            sb.append("\t<author>");
            sb.append(author);
            sb.append("</author>\n");
        }
        for (String license : this._distinctLicenses) {
            sb.append("\t<license>");
            sb.append(license);
            sb.append("</license>\n");
        }
        sb.append("</plugins-summary>");
        FileUtil.write((String)(this._pluginsDir + "/summary.xml"), (String)sb.toString());
    }

    private void _createPluginSummary(String fileName, StringBundler sb) throws Exception {
        String content = FileUtil.read((String)fileName);
        int x = fileName.indexOf("/");
        String type = fileName.substring(0, x);
        if (type.endsWith("s")) {
            type = type.substring(0, type.length() - 1);
        }
        x = fileName.indexOf("/", x) + 1;
        int y = fileName.indexOf("/", x);
        String artifactId = fileName.substring(x, y);
        Properties properties = PropertiesUtil.load((String)content);
        String name = this._readProperty(properties, "name");
        String tags = this._readProperty(properties, "tags");
        String shortDescription = this._readProperty(properties, "short-description");
        String longDescription = this._readProperty(properties, "long-description");
        String changeLog = this._readProperty(properties, "change-log");
        String pageURL = this._readProperty(properties, "page-url");
        String author = this._readProperty(properties, "author");
        String licenses = this._readProperty(properties, "licenses");
        String liferayVersions = this._readProperty(properties, "liferay-versions");
        this._distinctAuthors.add(author);
        this._distinctLicenses.add(licenses);
        sb.append("\t<plugin>\n");
        this._writeElement(sb, "artifact-id", artifactId, 2);
        this._writeElement(sb, "name", name, 2);
        this._writeElement(sb, "type", type, 2);
        this._writeElement(sb, "tags", tags, 2);
        this._writeElement(sb, "short-description", shortDescription, 2);
        this._writeElement(sb, "long-description", longDescription, 2);
        this._writeElement(sb, "change-log", changeLog, 2);
        this._writeElement(sb, "page-url", pageURL, 2);
        this._writeElement(sb, "author", author, 2);
        this._writeElement(sb, "licenses", licenses, 2);
        this._writeElement(sb, "liferay-versions", liferayVersions, 2);
        sb.append("\t\t<releng>\n");
        sb.append(this._readReleng(fileName));
        sb.append("\t\t</releng>\n");
        sb.append("\t</plugin>\n");
    }

    private String _readProperty(Properties properties, String key) {
        return GetterUtil.getString((String)properties.getProperty(key));
    }

    private String _readReleng(String fileName) throws Exception {
        String relengPropertiesContent;
        int x = fileName.indexOf("WEB-INF");
        String relativeWebInfDirName = fileName.substring(0, x + 8);
        String fullWebInfDirName = this._pluginsDir + "/" + relativeWebInfDirName;
        String relengPropertiesFileName = String.valueOf(fullWebInfDirName) + "liferay-releng.properties";
        Properties relengProperties = null;
        if (FileUtil.exists((String)relengPropertiesFileName)) {
            relengPropertiesContent = FileUtil.read((String)relengPropertiesFileName);
            relengProperties = PropertiesUtil.load((String)relengPropertiesContent);
        } else {
            relengProperties = new Properties();
        }
        relengPropertiesContent = this._updateRelengPropertiesFile(relengPropertiesFileName, relengProperties);
        relengProperties = PropertiesUtil.load((String)relengPropertiesContent);
        StringBundler sb = new StringBundler();
        this._writeElement(sb, "bundle", relengProperties, 3);
        this._writeElement(sb, "category", relengProperties, 3);
        this._writeElement(sb, "demo-url", relengProperties, 3);
        this._writeElement(sb, "dependent-apps", relengProperties, 3);
        if (FileUtil.exists((String)(String.valueOf(fullWebInfDirName) + "releng/icons/90x90.png"))) {
            this._writeElement(sb, "icon", String.valueOf(relativeWebInfDirName) + "releng/icons/90x90.png", 3);
        }
        this._writeElement(sb, "labs", relengProperties, 3);
        this._writeElement(sb, "marketplace", relengProperties, 3);
        this._writeElement(sb, "public", relengProperties, 3);
        String fullScreenshotsDirName = String.valueOf(fullWebInfDirName) + "releng/screenshots/";
        String relativeScreenshotsDirName = String.valueOf(relativeWebInfDirName) + "releng/screenshots/";
        if (FileUtil.exists((String)fullScreenshotsDirName)) {
            Object[] screenshotsFileNames = FileUtil.listFiles((String)fullScreenshotsDirName);
            Arrays.sort(screenshotsFileNames);
            Object[] objectArray = screenshotsFileNames;
            int n = screenshotsFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object screenshotsFileName = objectArray[n2];
                if (((String)screenshotsFileName).equals("Thumbs.db") || ((String)screenshotsFileName).endsWith(".png")) {
                    FileUtil.delete((String)(String.valueOf(fullScreenshotsDirName) + (String)screenshotsFileName));
                }
                if (((String)screenshotsFileName).endsWith(".jpg")) {
                    this._writeElement(sb, "screenshot", String.valueOf(relativeScreenshotsDirName) + (String)screenshotsFileName, 3);
                }
                ++n2;
            }
        }
        this._writeElement(sb, "supported", relengProperties, 3);
        return sb.toString();
    }

    private String _updateRelengPropertiesFile(String relengPropertiesFileName, Properties relengProperties) throws Exception {
        StringBundler sb = new StringBundler();
        this._writeProperty(sb, relengProperties, "bundle", "false");
        this._writeProperty(sb, relengProperties, "category", "");
        this._writeProperty(sb, relengProperties, "demo-url", "");
        this._writeProperty(sb, relengProperties, "dependent-apps", "");
        this._writeProperty(sb, relengProperties, "labs", "true");
        this._writeProperty(sb, relengProperties, "marketplace", "false");
        this._writeProperty(sb, relengProperties, "public", "true");
        this._writeProperty(sb, relengProperties, "supported", "false");
        String relengPropertiesContent = sb.toString();
        FileUtil.write((String)relengPropertiesFileName, (String)relengPropertiesContent);
        return relengPropertiesContent;
    }

    private void _writeElement(StringBundler sb, String name, Properties properties, int tabsCount) {
        this._writeElement(sb, name, this._readProperty(properties, name), tabsCount);
    }

    private void _writeElement(StringBundler sb, String name, String value, int tabsCount) {
        int i2 = 0;
        while (i2 < tabsCount) {
            sb.append("\t");
            ++i2;
        }
        sb.append("<");
        sb.append(name);
        sb.append(">");
        sb.append(value);
        sb.append("</");
        sb.append(name);
        sb.append(">\n");
    }

    private void _writeProperty(StringBundler sb, Properties properties, String key, String defaultValue) {
        String value = GetterUtil.getString((String)properties.getProperty(key), (String)defaultValue);
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(key);
        sb.append("=");
        sb.append(value);
    }
}

