/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ComparableRoute;
import com.liferay.portal.tools.SourceFormatterHelper;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.util.ContentUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFormatter {
    private static final String[] _TAG_LIBRARIES = new String[]{"aui", "c", "html", "jsp", "liferay-portlet", "liferay-security", "liferay-theme", "liferay-ui", "liferay-util", "portlet", "struts", "tiles"};
    private static final int _TYPE_CLASS_PRIVATE = 24;
    private static final int _TYPE_CLASS_PRIVATE_STATIC = 23;
    private static final int _TYPE_CLASS_PROTECTED = 16;
    private static final int _TYPE_CLASS_PROTECTED_STATIC = 15;
    private static final int _TYPE_CLASS_PUBLIC = 8;
    private static final int _TYPE_CLASS_PUBLIC_STATIC = 7;
    private static final int _TYPE_CONSTRUCTOR_PRIVATE = 18;
    private static final int _TYPE_CONSTRUCTOR_PROTECTED = 10;
    private static final int _TYPE_CONSTRUCTOR_PUBLIC = 4;
    private static final int[] _TYPE_METHOD = new int[]{19, 17, 11, 9, 5, 3};
    private static final int _TYPE_METHOD_PRIVATE = 19;
    private static final int _TYPE_METHOD_PRIVATE_STATIC = 17;
    private static final int _TYPE_METHOD_PROTECTED = 11;
    private static final int _TYPE_METHOD_PROTECTED_STATIC = 9;
    private static final int _TYPE_METHOD_PUBLIC = 5;
    private static final int _TYPE_METHOD_PUBLIC_STATIC = 3;
    private static final int[] _TYPE_VARIABLE_NOT_FINAL = new int[]{22, 21, 14, 13, 6, 2};
    private static final int _TYPE_VARIABLE_PRIVATE = 22;
    private static final int _TYPE_VARIABLE_PRIVATE_STATIC = 21;
    private static final int _TYPE_VARIABLE_PRIVATE_STATIC_FINAL = 20;
    private static final int _TYPE_VARIABLE_PROTECTED = 14;
    private static final int _TYPE_VARIABLE_PROTECTED_STATIC = 13;
    private static final int _TYPE_VARIABLE_PROTECTED_STATIC_FINAL = 12;
    private static final int _TYPE_VARIABLE_PUBLIC = 6;
    private static final int _TYPE_VARIABLE_PUBLIC_STATIC = 2;
    private static final int _TYPE_VARIABLE_PUBLIC_STATIC_FINAL = 1;
    private static String[] _excludes;
    private static FileImpl _fileUtil;
    private static Pattern _javaImportPattern;
    private static Properties _javaTermAlphabetizeExclusionsProperties;
    private static Pattern _jspAttributeNamePattern;
    private static Map<String, String> _jspContents;
    private static Pattern _jspImportPattern;
    private static Pattern _jspIncludeFilePattern;
    private static Properties _lineLengthExclusionsProperties;
    private static SAXReaderImpl _saxReaderUtil;
    private static SourceFormatterHelper _sourceFormatterHelper;
    private static Pattern _xssPattern;

    static {
        _fileUtil = FileImpl.getInstance();
        _javaImportPattern = Pattern.compile("(^[ \t]*import\\s+.*;\n+)+", 8);
        _jspAttributeNamePattern = Pattern.compile("[a-z]+[-_a-zA-Z0-9]*");
        _jspContents = new HashMap<String, String>();
        _jspImportPattern = Pattern.compile("(<.*\n*page.import=\".*>\n*)+", 8);
        _jspIncludeFilePattern = Pattern.compile("/.*[.]jsp[f]?");
        _saxReaderUtil = SAXReaderImpl.getInstance();
        _xssPattern = Pattern.compile("String\\s+([^\\s]+)\\s*=\\s*(Bean)?ParamUtil\\.getString\\(");
    }

    public static void main(String[] args) {
        try {
            _excludes = StringUtil.split((String)GetterUtil.getString((String)System.getProperty("source.formatter.excludes")));
            _sourceFormatterHelper = new SourceFormatterHelper(false);
            _sourceFormatterHelper.init();
            _javaTermAlphabetizeExclusionsProperties = SourceFormatter._getExclusionsProperties("source_formatter_javaterm_alphabetize_exclusions.properties");
            _lineLengthExclusionsProperties = SourceFormatter._getExclusionsProperties("source_formatter_line_length_exclusions.properties");
            Thread thread1 = new Thread(){

                public void run() {
                    try {
                        SourceFormatter._formatJSP();
                        SourceFormatter._formatAntXML();
                        SourceFormatter._formatDDLStructuresXML();
                        SourceFormatter._formatFriendlyURLRoutesXML();
                        SourceFormatter._formatPortletXML();
                        SourceFormatter._formatSH();
                        SourceFormatter._formatSQL();
                        SourceFormatter._formatStrutsConfigXML();
                        SourceFormatter._formatTilesDefsXML();
                        SourceFormatter._formatWebXML();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            };
            Thread thread2 = new Thread(){

                public void run() {
                    try {
                        SourceFormatter._formatJava();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            };
            thread1.start();
            thread2.start();
            thread1.join();
            thread2.join();
            _sourceFormatterHelper.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static String stripJavaImports(String content, String packageDir, String className) throws IOException {
        Matcher matcher = _javaImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        Set classes = ClassUtil.getClasses((Reader)new UnsyncStringReader(content), (String)className);
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import ")) continue;
            int importX = line.indexOf(" ");
            int importY = line.lastIndexOf(".");
            String importPackage = line.substring(importX + 1, importY);
            String importClass = line.substring(importY + 1, line.length() - 1);
            if (packageDir.equals(importPackage)) continue;
            if (!importClass.equals("*")) {
                if (!classes.contains(importClass)) continue;
                sb.append(line);
                sb.append("\n");
                continue;
            }
            sb.append(line);
            sb.append("\n");
        }
        imports = SourceFormatter._formatImports(sb.toString(), 7);
        content = String.valueOf(content.substring(0, matcher.start())) + imports + content.substring(matcher.end());
        content = content.replaceFirst("(?m)^[ \t]*(package .*;)\\s*^[ \t]*import", "$1\n\nimport");
        content = content.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        return content;
    }

    private static void _addJSPIncludeFileNames(String fileName, Set<String> includeFileNames) {
        int y;
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return;
        }
        int x = 0;
        while ((x = content.indexOf("<%@ include file=", x)) != -1 && (x = content.indexOf("\"", x)) != -1 && (y = content.indexOf("\"", x + 1)) != -1) {
            String includeFileName = content.substring(x + 1, y);
            Matcher matcher = _jspIncludeFilePattern.matcher(includeFileName);
            if (!matcher.find()) {
                throw new RuntimeException("Invalid include " + includeFileName);
            }
            String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
            includeFileName = String.valueOf(docrootPath) + includeFileName;
            if ((includeFileName.endsWith("jsp") || includeFileName.endsWith("jspf")) && !includeFileNames.contains(includeFileName) && !includeFileName.contains("html/portlet/init.jsp")) {
                includeFileNames.add(includeFileName);
            }
            x = y;
        }
    }

    private static void _addJSPReferenceFileNames(String fileName, Set<String> includeFileNames) {
        for (Map.Entry<String, String> entry : _jspContents.entrySet()) {
            String referenceFileName = entry.getKey();
            String content = entry.getValue();
            if (!content.contains("<%@ include file=\"" + fileName) || includeFileNames.contains(referenceFileName)) continue;
            includeFileNames.add(referenceFileName);
        }
    }

    private static void _addJSPUnusedImports(String fileName, List<String> importLines, List<String> unneededImports) {
        for (String importLine : importLines) {
            HashSet<String> includeFileNames = new HashSet<String>();
            includeFileNames.add(fileName);
            HashSet<String> checkedFileNames = new HashSet<String>();
            int x = importLine.indexOf("\"");
            int y = importLine.indexOf("\"", x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            if (SourceFormatter._isJSPImportRequired(fileName, className = className.substring(className.lastIndexOf(".") + 1), includeFileNames, checkedFileNames)) continue;
            unneededImports.add(importLine);
        }
    }

    private static List<String> _addMethodParameterTypes(String line, List<String> methodParameterTypes) {
        int x = line.indexOf("(");
        if (x != -1 && (Validator.isNull((String)(line = line.substring(x + 1))) || line.startsWith(")"))) {
            return methodParameterTypes;
        }
        x = 0;
        while ((x = line.indexOf(" ")) != -1) {
            String parameterType = line.substring(0, x);
            if (parameterType.equals("throws")) {
                return methodParameterTypes;
            }
            methodParameterTypes.add(parameterType);
            int y = line.indexOf(",");
            int z = line.indexOf(")");
            if (y == -1 || z != -1 && z < y) {
                return methodParameterTypes;
            }
            line = line.substring(y + 1);
            line = line.trim();
        }
        return methodParameterTypes;
    }

    private static void _checkIfClause(String ifClause, String fileName, int lineCount) {
        if (ifClause.contains("//") || ifClause.contains("/*") || ifClause.contains("*/")) {
            return;
        }
        int quoteCount = StringUtil.count((String)ifClause, (String)"\"");
        if (quoteCount % 2 == 1) {
            return;
        }
        ifClause = SourceFormatter._stripQuotes(ifClause);
        ifClause = SourceFormatter._stripRedundantParentheses(ifClause);
        ifClause = StringUtil.replace((String)ifClause, (String[])new String[]{"'('", "')'"}, (String[])new String[]{"", ""});
        int level = 0;
        int max = StringUtil.count((String)ifClause, (String)"(");
        int previousParenthesisPos = -1;
        int[] levels = new int[max];
        int i2 = 0;
        while (i2 < ifClause.length()) {
            char c2 = ifClause.charAt(i2);
            if (c2 == '(' || c2 == ')') {
                if (previousParenthesisPos != -1) {
                    String s = ifClause.substring(previousParenthesisPos + 1, i2);
                    SourceFormatter._checkMissingParentheses(s, fileName, lineCount);
                }
                previousParenthesisPos = i2;
                if (c2 == '(') {
                    levels[level] = i2;
                    ++level;
                } else {
                    int posOpenParenthesis = levels[level - 1];
                    if (level > 1) {
                        String s;
                        char nextChar = ifClause.charAt(i2 + 1);
                        char previousChar = ifClause.charAt(posOpenParenthesis - 1);
                        if (!Character.isLetterOrDigit(nextChar) && nextChar != '.' && !Character.isLetterOrDigit(previousChar) && Validator.isNotNull((String)(s = ifClause.substring(posOpenParenthesis + 1, i2))) && !s.contains(" ")) {
                            _sourceFormatterHelper.printError(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                        }
                        if (previousChar == '(' && nextChar == ')') {
                            _sourceFormatterHelper.printError(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                        }
                    }
                    --level;
                }
            }
            ++i2;
        }
    }

    private static void _checkMissingParentheses(String s, String fileName, int lineCount) {
        boolean containsMathOperator;
        if (Validator.isNull((String)s)) {
            return;
        }
        boolean containsAndOrOperator = s.contains("&&") || s.contains("||");
        boolean containsCompareOperator = s.contains(" == ") || s.contains(" != ") || s.contains(" < ") || s.contains(" > ") || s.contains(" =< ") || s.contains(" => ") || s.contains(" <= ") || s.contains(" >= ");
        boolean bl = containsMathOperator = s.contains(" = ") || s.contains(" - ") || s.contains(" + ") || s.contains(" & ") || s.contains(" % ") || s.contains(" * ") || s.contains(" / ");
        if (containsCompareOperator && (containsAndOrOperator || containsMathOperator && !s.contains("["))) {
            _sourceFormatterHelper.printError(fileName, "missing parentheses: " + fileName + " " + lineCount);
        }
    }

    private static boolean _checkTaglibVulnerability(String jspContent, String vulnerability) {
        int pos1 = -1;
        do {
            if ((pos1 = jspContent.indexOf(vulnerability, pos1 + 1)) == -1) continue;
            int pos2 = jspContent.lastIndexOf(60, pos1);
            while (pos2 > 0 && jspContent.charAt(pos2 + 1) == '%') {
                pos2 = jspContent.lastIndexOf(60, pos2 - 1);
            }
            String tagContent = jspContent.substring(pos2, pos1);
            if (tagContent.startsWith("<aui:") || tagContent.startsWith("<liferay-portlet:") || tagContent.startsWith("<liferay-util:") || tagContent.startsWith("<portlet:")) continue;
            return true;
        } while (pos1 != -1);
        return false;
    }

    private static void _checkXSS(String fileName, String jspContent) {
        Matcher matcher = _xssPattern.matcher(jspContent);
        while (matcher.find()) {
            String documentIdVulnerability;
            String inlineStringVulnerability3;
            String inlineStringVulnerability2;
            String inlineStringVulnerability1;
            String inputVulnerability;
            boolean xssVulnerable = false;
            String jspVariable = matcher.group(1);
            String anchorVulnerability = " href=\"<%= " + jspVariable + " %>";
            if (SourceFormatter._checkTaglibVulnerability(jspContent, anchorVulnerability)) {
                xssVulnerable = true;
            }
            if (SourceFormatter._checkTaglibVulnerability(jspContent, inputVulnerability = " value=\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability1 = "'<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability2 = "(\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability3 = " \"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(documentIdVulnerability = ".<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (!xssVulnerable) continue;
            _sourceFormatterHelper.printError(fileName, "(xss): " + fileName + " (" + jspVariable + ")");
        }
    }

    private static void _compareJavaTermNames(String fileName, String previousJavaTermName, String javaTermName, int lineCount) {
        if (Validator.isNull((String)previousJavaTermName) || Validator.isNull((String)javaTermName)) {
            return;
        }
        if (javaTermName.equals("_log")) {
            _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + lineCount);
            return;
        }
        if (previousJavaTermName.equals("_instance") || previousJavaTermName.equals("_log")) {
            return;
        }
        if (javaTermName.equals("_instance")) {
            _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + lineCount);
            return;
        }
        if (previousJavaTermName.compareToIgnoreCase(javaTermName) <= 0) {
            return;
        }
        String javaTermNameLowerCase = javaTermName.toLowerCase();
        String previousJavaTermNameLowerCase = previousJavaTermName.toLowerCase();
        if (fileName.contains("persistence") && (previousJavaTermName.startsWith("doCount") && javaTermName.startsWith("doCount") || previousJavaTermName.startsWith("doFind") && javaTermName.startsWith("doFind") || previousJavaTermNameLowerCase.startsWith("count") && javaTermNameLowerCase.startsWith("count") || previousJavaTermNameLowerCase.startsWith("filter") && javaTermNameLowerCase.startsWith("filter") || previousJavaTermNameLowerCase.startsWith("find") && javaTermNameLowerCase.startsWith("find") || previousJavaTermNameLowerCase.startsWith("join") && javaTermNameLowerCase.startsWith("join"))) {
            return;
        }
        _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + lineCount);
    }

    private static void _compareMethodParameterTypes(String fileName, List<String> previousMethodParameterTypes, List<String> methodParameterTypes, int lineCount) {
        if (methodParameterTypes.isEmpty()) {
            _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + lineCount);
            return;
        }
        int i2 = 0;
        while (i2 < previousMethodParameterTypes.size()) {
            String parameterType;
            if (methodParameterTypes.size() < i2 + 1) {
                _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + lineCount);
                return;
            }
            String previousParameterType = previousMethodParameterTypes.get(i2);
            if (previousParameterType.endsWith("...")) {
                previousParameterType = StringUtil.replaceLast((String)previousParameterType, (String)"...", (String)"");
            }
            if ((parameterType = methodParameterTypes.get(i2)).endsWith("...")) {
                parameterType = StringUtil.replaceLast((String)parameterType, (String)"...", (String)"");
            }
            if (previousParameterType.compareToIgnoreCase(parameterType) < 0) {
                return;
            }
            if (previousParameterType.compareToIgnoreCase(parameterType) > 0) {
                _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + lineCount);
                return;
            }
            if (previousParameterType.compareTo(parameterType) > 0) {
                return;
            }
            if (previousParameterType.compareTo(parameterType) < 0) {
                _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + lineCount);
                return;
            }
            ++i2;
        }
    }

    private static String _fixAntXMLProjectName(String basedir, String fileName, String content) throws IOException {
        int x = 0;
        if (fileName.endsWith("-ext/build.xml")) {
            x = fileName.indexOf("ext/");
            x = x == -1 ? 0 : (x += 4);
        } else if (fileName.endsWith("-hook/build.xml")) {
            x = fileName.indexOf("hooks/");
            x = x == -1 ? 0 : (x += 6);
        } else if (fileName.endsWith("-layouttpl/build.xml")) {
            x = fileName.indexOf("layouttpl/");
            x = x == -1 ? 0 : (x += 10);
        } else if (fileName.endsWith("-portlet/build.xml")) {
            x = fileName.indexOf("portlets/");
            x = x == -1 ? 0 : (x += 9);
        } else if (fileName.endsWith("-theme/build.xml")) {
            x = fileName.indexOf("themes/");
            x = x == -1 ? 0 : (x += 7);
        } else if (fileName.endsWith("-web/build.xml") && !fileName.endsWith("/ext-web/build.xml")) {
            x = fileName.indexOf("webs/");
            x = x == -1 ? 0 : (x += 5);
        } else {
            return content;
        }
        int y = fileName.indexOf("/", x);
        String correctProjectElementText = "<project name=\"" + fileName.substring(x, y) + "\"";
        if (!content.contains(correctProjectElementText)) {
            x = content.indexOf("<project name=\"");
            y = content.indexOf("\"", x) + 1;
            y = content.indexOf("\"", y) + 1;
            content = String.valueOf(content.substring(0, x)) + correctProjectElementText + content.substring(y);
            _sourceFormatterHelper.printError(fileName, String.valueOf(fileName) + " has an incorrect project name");
            _fileUtil.write(String.valueOf(basedir) + fileName, content);
        }
        return content;
    }

    private static String _fixDataAccessConnection(String className, String content) {
        int x = content.indexOf("package ");
        int y = content.indexOf(59, x);
        if (x == -1 || y == -1) {
            return content;
        }
        String packageName = content.substring(x + 8, y);
        if (!(packageName.startsWith("com.liferay.portal.kernel.upgrade") || packageName.startsWith("com.liferay.portal.kernel.verify") || packageName.startsWith("com.liferay.portal.upgrade") || packageName.startsWith("com.liferay.portal.verify"))) {
            return content;
        }
        content = StringUtil.replace((String)content, (String)"DataAccess.getConnection", (String)"DataAccess.getUpgradeOptimizedConnection");
        return content;
    }

    private static void _formatAntXML() throws DocumentException, IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\b*.xml"});
        directoryScanner.setExcludes(new String[]{"**\\tools\\**"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        block0: for (String fileName : fileNames) {
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(String.valueOf(basedir) + fileName);
            content = SourceFormatter._fixAntXMLProjectName(basedir, fileName, content);
            Document document = _saxReaderUtil.read(content);
            Element rootElement = document.getRootElement();
            String previousName = "";
            List targetElements = rootElement.elements("target");
            for (Element targetElement : targetElements) {
                String name = targetElement.attributeValue("name");
                if (name.equals("Test")) {
                    name = name.toLowerCase();
                }
                if (name.compareTo(previousName) < -1) {
                    _sourceFormatterHelper.printError(fileName, String.valueOf(fileName) + " has an unordered target " + name);
                    continue block0;
                }
                previousName = name;
            }
        }
    }

    private static void _formatDDLStructuresXML() throws DocumentException, IOException {
        String basedir = "./portal-impl/src/com/liferay/portal/events/dependencies/";
        if (!_fileUtil.exists(basedir)) {
            return;
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\*structures.xml"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatDDLStructuresXML(content);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatDDLStructuresXML(String content) throws DocumentException, IOException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        rootElement.sortElementsByChildElement("structure", "name");
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            Element structureRootElement = structureElement.element("root");
            structureRootElement.sortElementsByAttribute("dynamic-element", "name");
            List dynamicElementElements = structureRootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                Element metaDataElement = dynamicElementElement.element("meta-data");
                metaDataElement.sortElementsByAttribute("entry", "name");
            }
        }
        return document.formattedString();
    }

    private static void _formatFriendlyURLRoutesXML() throws DocumentException, IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\*routes.xml"});
        directoryScanner.setExcludes(new String[]{"**\\classes\\**", "**\\bin\\**"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            String newContent;
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            if (content.contains("<!-- SourceFormatter.Ignore -->") || (newContent = SourceFormatter._formatFriendlyURLRoutesXML(content)) == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatFriendlyURLRoutesXML(String content) throws DocumentException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        ArrayList<ComparableRoute> comparableRoutes = new ArrayList<ComparableRoute>();
        for (Element routeElement : rootElement.elements("route")) {
            Object value;
            String pattern = routeElement.elementText("pattern");
            ComparableRoute comparableRoute = new ComparableRoute(pattern);
            for (Element element : routeElement.elements("generated-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addGeneratedParameter(string, (String)value);
            }
            for (Element element : routeElement.elements("ignored-parameter")) {
                String string = element.attributeValue("name");
                comparableRoute.addIgnoredParameter(string);
            }
            for (Element element : routeElement.elements("implicit-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addImplicitParameter(string, (String)value);
            }
            for (Element element : routeElement.elements("overridden-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addOverriddenParameter(string, (String)value);
            }
            comparableRoutes.add(comparableRoute);
        }
        Collections.sort(comparableRoutes);
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE routes PUBLIC \"-//Liferay//DTD Friendly URL ");
        sb.append("Routes 6.1.0//EN\" \"http://www.liferay.com/dtd/");
        sb.append("liferay-friendly-url-routes_6_1_0.dtd\">\n\n<routes>\n");
        for (ComparableRoute comparableRoute : comparableRoutes) {
            sb.append("\t<route>\n");
            sb.append("\t\t<pattern>");
            sb.append(comparableRoute.getPattern());
            sb.append("</pattern>\n");
            Map<String, String> generatedParameters = comparableRoute.getGeneratedParameters();
            for (Map.Entry entry : generatedParameters.entrySet()) {
                sb.append("\t\t<generated-parameter name=\"");
                sb.append((String)entry.getKey());
                sb.append("\">");
                sb.append((String)entry.getValue());
                sb.append("</generated-parameter>\n");
            }
            Set<String> set = comparableRoute.getIgnoredParameters();
            for (String entry : set) {
                sb.append("\t\t<ignored-parameter name=\"");
                sb.append(entry);
                sb.append("\" />\n");
            }
            Map<String, String> implicitParameters = comparableRoute.getImplicitParameters();
            for (Map.Entry entry : implicitParameters.entrySet()) {
                sb.append("\t\t<implicit-parameter name=\"");
                sb.append((String)entry.getKey());
                sb.append("\">");
                sb.append((String)entry.getValue());
                sb.append("</implicit-parameter>\n");
            }
            Map<String, String> map = comparableRoute.getOverriddenParameters();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                sb.append("\t\t<overridden-parameter name=\"");
                sb.append(entry.getKey());
                sb.append("\">");
                sb.append(entry.getValue());
                sb.append("</overridden-parameter>\n");
            }
            sb.append("\t</route>\n");
        }
        sb.append("</routes>");
        return sb.toString();
    }

    private static String _formatImports(String imports, int classStartPos) throws IOException {
        if (imports.contains("/*") || imports.contains("*/") || imports.contains("//")) {
            return String.valueOf(imports) + "\n";
        }
        List<String> importsList = new ArrayList();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import=") && !line.contains("import ") || importsList.contains(line)) continue;
            importsList.add(line);
        }
        importsList = ListUtil.sort(importsList);
        StringBundler sb = new StringBundler();
        String temp = null;
        int i2 = 0;
        while (i2 < importsList.size()) {
            String s = (String)importsList.get(i2);
            int pos = s.indexOf(".");
            if ((pos = s.indexOf(".", pos + 1)) == -1) {
                pos = s.indexOf(".");
            }
            String packageLevel = s.substring(classStartPos, pos);
            if (i2 != 0 && !packageLevel.equals(temp)) {
                sb.append("\n");
            }
            temp = packageLevel;
            sb.append(s);
            sb.append("\n");
            ++i2;
        }
        return sb.toString();
    }

    private static void _formatJava() throws IOException {
        String basedir = "./";
        String copyright = SourceFormatter._getCopyright();
        String oldCopyright = SourceFormatter._getOldCopyright();
        boolean portalJavaFiles = true;
        Collection<String> fileNames = null;
        if (_fileUtil.exists(String.valueOf(basedir) + "portal-impl")) {
            fileNames = SourceFormatter._getPortalJavaFiles();
        } else {
            portalJavaFiles = false;
            fileNames = SourceFormatter._getPluginJavaFiles();
        }
        for (String fileName : fileNames) {
            String customCopyright;
            int packagePathY;
            File file = new File(fileName);
            String content = _fileUtil.read(file);
            if (SourceFormatter._isGenerated(content)) continue;
            String className = file.getName();
            className = className.substring(0, className.length() - 5);
            String packagePath = fileName;
            int packagePathX = packagePath.indexOf(String.valueOf(File.separator) + "src" + File.separator);
            packagePath = packagePathX + 5 >= (packagePathY = packagePath.lastIndexOf(File.separator)) ? "" : packagePath.substring(packagePathX + 5, packagePathY);
            if ((packagePath = StringUtil.replace((String)packagePath, (String)File.separator, (String)".")).endsWith(".model") && content.contains("extends " + className + "Model")) continue;
            String newContent = content;
            if (newContent.contains("$\n */")) {
                _sourceFormatterHelper.printError(fileName, "*: " + fileName);
                newContent = StringUtil.replace((String)newContent, (String)"$\n */", (String)"$\n *\n */");
            }
            if (oldCopyright != null && newContent.contains(oldCopyright)) {
                newContent = StringUtil.replace((String)newContent, (String)oldCopyright, (String)copyright);
                _sourceFormatterHelper.printError(fileName, "old (c): " + fileName);
            }
            if (!(newContent.contains(copyright) || !Validator.isNull((String)(customCopyright = SourceFormatter._getCustomCopyright(file))) && newContent.contains(customCopyright))) {
                _sourceFormatterHelper.printError(fileName, "(c): " + fileName);
            }
            if (newContent.contains(String.valueOf(className) + ".java.html")) {
                _sourceFormatterHelper.printError(fileName, "Java2HTML: " + fileName);
            }
            if (newContent.contains(" * @author Raymond Aug") && !newContent.contains(" * @author Raymond Aug\u00e9")) {
                newContent = newContent.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
                _sourceFormatterHelper.printError(fileName, "UTF-8: " + fileName);
            }
            newContent = SourceFormatter._fixDataAccessConnection(className, newContent);
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil"}, (String[])new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil"});
            newContent = SourceFormatter.stripJavaImports(newContent, packagePath, className);
            if ((newContent = StringUtil.replace((String)newContent, (String[])new String[]{";\n/**", "\t/*\n\t *", "else{", "if(", "for(", "while(", "List <", "){\n", "]{\n", "\n\n\n"}, (String[])new String[]{";\n\n/**", "\t/**\n\t *", "else {", "if (", "for (", "while (", "List<", ") {\n", "] {\n", "\n\n"})).contains("*/\npackage ")) {
                _sourceFormatterHelper.printError(fileName, "package: " + fileName);
            }
            if (!newContent.endsWith("\n\n}") && !newContent.endsWith("{\n}")) {
                _sourceFormatterHelper.printError(fileName, "}: " + fileName);
            }
            if (portalJavaFiles && !className.equals("BaseServiceImpl") && className.endsWith("ServiceImpl") && newContent.contains("ServiceUtil.")) {
                _sourceFormatterHelper.printError(fileName, "ServiceUtil: " + fileName);
            }
            if (!className.equals("ProxyUtil") && newContent.contains("import java.lang.reflect.Proxy;")) {
                _sourceFormatterHelper.printError(fileName, "Proxy: " + fileName);
            }
            int pos1 = -1;
            while ((pos1 = newContent.indexOf("\ttry {", pos1 + 1)) != -1) {
                int pos2 = newContent.indexOf("\ttry {", pos1 + 1);
                int pos3 = newContent.indexOf("\"select count(", pos1);
                if (pos2 != -1 && pos3 != -1 && pos2 < pos3) continue;
                int pos4 = newContent.indexOf("rs.getLong(1)", pos1);
                int pos5 = newContent.indexOf("\tfinally {", pos1);
                if (pos3 == -1 || pos4 == -1 || pos5 == -1) break;
                if (pos3 >= pos4 || pos4 >= pos5) continue;
                _sourceFormatterHelper.printError(fileName, "Use getInt(1) for count: " + fileName);
            }
            String oldContent = newContent;
            while (!oldContent.equals(newContent = SourceFormatter._formatJavaContent(fileName, oldContent))) {
                oldContent = newContent;
            }
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatJavaContent(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        Object previousLine = "";
        int lineToSkipIfEmpty = 0;
        String javaTermName = null;
        int javaTermType = 0;
        String previousJavaTermName = null;
        int previousJavaTermType = 0;
        List<String> methodParameterTypes = new ArrayList<String>();
        List previousMethodParameterTypes = null;
        boolean readMethodParameterTypes = false;
        boolean hasSameMethodName = false;
        String ifClause = "";
        String packageName = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int y;
            int x;
            String excluded;
            String trimmedLine;
            String importPackageName;
            int pos;
            ++lineCount;
            if (line.trim().length() == 0) {
                line = "";
            }
            line = StringUtil.trimTrailing((String)line);
            if ((line = StringUtil.replace((String)line, (String[])new String[]{"* Copyright (c) 2000-2011 Liferay, Inc."}, (String[])new String[]{"* Copyright (c) 2000-2012 Liferay, Inc."})).startsWith("package ")) {
                packageName = line.substring(8, line.length() - 1);
            }
            if (line.startsWith("import ") && (pos = line.lastIndexOf(".")) != -1 && (importPackageName = line.substring(7, pos)).equals(packageName)) continue;
            if (line.startsWith(" ") && !line.startsWith(" *")) {
                if (!line.startsWith("    ")) {
                    while (line.startsWith(" ")) {
                        line = StringUtil.replaceFirst((String)line, (String)" ", (String)"");
                    }
                } else {
                    pos = 0;
                    String temp = line;
                    while (temp.startsWith("    ")) {
                        line = StringUtil.replaceFirst((String)line, (String)"    ", (String)"\t");
                        temp = line.substring(++pos);
                    }
                }
            }
            if (line.contains("\tfor (") && line.contains(":") && !line.contains(" :")) {
                line = StringUtil.replace((String)line, (String)":", (String)" :");
            }
            if (!(trimmedLine = StringUtil.trimLeading((String)(line = SourceFormatter._replacePrimitiveWrapperInstantiation(fileName, line, lineCount)))).equals("{") && line.endsWith("{") && !line.endsWith(" {")) {
                line = StringUtil.replaceLast((String)line, (String)"{", (String)" {");
            }
            line = SourceFormatter._sortExceptions(line);
            if ((trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (") || Validator.isNotNull((String)ifClause)) && (ifClause = Validator.isNull((String)ifClause) || ifClause.endsWith("(") ? String.valueOf(ifClause) + trimmedLine : String.valueOf(ifClause) + " " + trimmedLine).endsWith(") {")) {
                SourceFormatter._checkIfClause(ifClause, fileName, lineCount);
                ifClause = "";
            }
            if ((excluded = _javaTermAlphabetizeExclusionsProperties.getProperty(String.valueOf(StringUtil.replace((String)fileName, (String)"\\", (String)"/")) + "@" + lineCount)) == null) {
                excluded = _javaTermAlphabetizeExclusionsProperties.getProperty(StringUtil.replace((String)fileName, (String)"\\", (String)"/"));
            }
            if (line.startsWith("\tprivate ") || line.startsWith("\tprotected ") || line.startsWith("\tpublic ")) {
                hasSameMethodName = false;
                Tuple tuple = SourceFormatter._getJavaTermTuple(line);
                if (tuple != null && Validator.isNotNull((String)(javaTermName = (String)tuple.getObject(0)))) {
                    javaTermType = (Integer)tuple.getObject(1);
                    boolean isMethod = SourceFormatter._isInJavaTermTypeGroup(javaTermType, _TYPE_METHOD);
                    if (isMethod) {
                        readMethodParameterTypes = true;
                    }
                    if (SourceFormatter._isInJavaTermTypeGroup(javaTermType, _TYPE_VARIABLE_NOT_FINAL)) {
                        char firstChar = javaTermName.charAt(0);
                        if (firstChar == '_') {
                            firstChar = javaTermName.charAt(1);
                        }
                        if (Character.isUpperCase(firstChar)) {
                            _sourceFormatterHelper.printError(fileName, "final: " + fileName + " " + lineCount);
                        }
                    }
                    if (Validator.isNotNull(previousJavaTermName) && excluded == null) {
                        if (previousJavaTermType > javaTermType) {
                            _sourceFormatterHelper.printError(fileName, "order: " + fileName + " " + lineCount);
                        } else if (previousJavaTermType == javaTermType) {
                            if (isMethod && previousJavaTermName.equals(javaTermName)) {
                                hasSameMethodName = true;
                            } else {
                                SourceFormatter._compareJavaTermNames(fileName, previousJavaTermName, javaTermName, lineCount);
                            }
                        }
                    }
                    previousJavaTermName = javaTermName;
                    previousJavaTermType = javaTermType;
                }
            }
            if (readMethodParameterTypes) {
                methodParameterTypes = SourceFormatter._addMethodParameterTypes(trimmedLine, methodParameterTypes);
                if (trimmedLine.contains(")")) {
                    if (hasSameMethodName) {
                        SourceFormatter._compareMethodParameterTypes(fileName, previousMethodParameterTypes, methodParameterTypes, lineCount);
                    }
                    readMethodParameterTypes = false;
                    previousMethodParameterTypes = ListUtil.copy(methodParameterTypes);
                    methodParameterTypes.clear();
                }
            }
            if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                }
                if (!(!line.contains("\t ") || ((String)previousLine).endsWith("&&") || ((String)previousLine).endsWith("||") || ((String)previousLine).contains("\t((") || ((String)previousLine).contains("\t ") || ((String)previousLine).contains("\timplements ") || ((String)previousLine).contains("\tthrows "))) {
                    line = StringUtil.replace((String)line, (String)"\t ", (String)"\t");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.contains("Test")) {
                    line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                }
                if (!line.contains("\"")) {
                    if ((trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && line.contains(" (")) {
                        line = StringUtil.replace((String)line, (String)" (", (String)"(");
                    }
                    if (line.contains(" [")) {
                        line = StringUtil.replace((String)line, (String)" [", (String)"[");
                    }
                    int x2 = -1;
                    while ((x2 = line.indexOf(",", x2 + 1)) != -1) {
                        char previousChar;
                        char nextChar;
                        if (line.length() > x2 + 1 && (nextChar = line.charAt(x2 + 1)) != ' ' && nextChar != '\'') {
                            line = StringUtil.insert((String)line, (String)" ", (int)(x2 + 1));
                        }
                        if (x2 <= 0 || (previousChar = line.charAt(x2 - 1)) != ' ') continue;
                        line = line.substring(0, x2 - 1).concat(line.substring(x2));
                    }
                }
            }
            if ((line.contains(" && ") || line.contains(" || ")) && line.endsWith("(")) {
                _sourceFormatterHelper.printError(fileName, "line break: " + fileName + " " + lineCount);
            }
            if (line.contains(",") && !line.contains(")") && !line.contains(">") && !line.contains("\"") && line.endsWith("(")) {
                _sourceFormatterHelper.printError(fileName, "line break: " + fileName + " " + lineCount);
            }
            if (line.endsWith("+") && (x = line.indexOf(" = ")) != -1 && ((y = line.indexOf("\"")) == -1 || x < y)) {
                _sourceFormatterHelper.printError(fileName, "line break: " + fileName + " " + lineCount);
            }
            if (line.contains("    ") && !line.matches("\\s*\\*.*") && !fileName.endsWith("StringPool.java")) {
                _sourceFormatterHelper.printError(fileName, "tab: " + fileName + " " + lineCount);
            }
            if (line.contains("  {") && !line.matches("\\s*\\*.*")) {
                _sourceFormatterHelper.printError(fileName, "{:" + fileName + " " + lineCount);
            }
            if ((excluded = _lineLengthExclusionsProperties.getProperty(String.valueOf(StringUtil.replace((String)fileName, (String)"\\", (String)"/")) + "@" + lineCount)) == null) {
                excluded = _lineLengthExclusionsProperties.getProperty(StringUtil.replace((String)fileName, (String)"\\", (String)"/"));
            }
            Object[] combinedLines = null;
            if (!(excluded != null || line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_CREATE = ") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_DROP = ") || fileName.endsWith("Table.java") && line.contains(" index IX_"))) {
                if (SourceFormatter._getLineLength(line) > 80) {
                    _sourceFormatterHelper.printError(fileName, "> 80: " + fileName + " " + lineCount);
                } else {
                    int lineTabCount = StringUtil.count((String)line, (String)"\t");
                    int previousLineTabCount = StringUtil.count((String)previousLine, (String)"\t");
                    if (((String)previousLine).endsWith(",") && ((String)previousLine).contains("(") && !((String)previousLine).contains("for (") && lineTabCount > previousLineTabCount) {
                        _sourceFormatterHelper.printError(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    combinedLines = SourceFormatter._getCombinedLines(trimmedLine, (String)previousLine, lineTabCount, previousLineTabCount);
                }
            }
            if (Validator.isNotNull((Object[])combinedLines)) {
                previousLine = combinedLines[0];
                if (combinedLines.length > 1) {
                    Object addedToPreviousLine = combinedLines[1];
                    if (!Validator.isNotNull((String)addedToPreviousLine)) continue;
                    sb.append((String)previousLine);
                    sb.append("\n");
                    previousLine = StringUtil.replaceFirst((String)line, (String)addedToPreviousLine, (String)"");
                    continue;
                }
                if (!line.endsWith("{") || ((String)previousLine).contains(" class ")) continue;
                lineToSkipIfEmpty = lineCount + 1;
                continue;
            }
            if (lineCount > 1 && (Validator.isNotNull((String)previousLine) || lineToSkipIfEmpty != lineCount - 1)) {
                sb.append((String)previousLine);
                if (!(!((String)previousLine).endsWith("\t}") || !Validator.isNotNull((String)trimmedLine) || trimmedLine.equals(");") || trimmedLine.startsWith("}") || trimmedLine.startsWith("//") || trimmedLine.startsWith("catch ") || trimmedLine.startsWith("else ") || trimmedLine.startsWith("finally ") || trimmedLine.startsWith("while "))) {
                    sb.append("\n");
                }
                sb.append("\n");
            }
            previousLine = line;
        }
        sb.append((String)previousLine);
        unsyncBufferedReader.close();
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    private static void _formatJSP() throws IOException {
        String[] fileNames;
        String basedir = "./";
        String copyright = SourceFormatter._getCopyright();
        String oldCopyright = SourceFormatter._getOldCopyright();
        ArrayList<String> list = new ArrayList<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\portal\\aui\\**", "**\\bin\\**", "**\\null.jsp", "**\\tmp\\**", "**\\tools\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.jsp", "**\\*.jspf", "**\\*.vm"});
        list.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        String[] stringArray = fileNames = list.toArray(new String[list.size()]);
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            fileName = fileName.replace('\\', '/');
            _jspContents.put(fileName, content);
            ++n2;
        }
        boolean stripJSPImports = true;
        String[] stringArray2 = fileNames;
        int n3 = fileNames.length;
        n = 0;
        while (n < n3) {
            String content;
            String fileName = stringArray2[n];
            File file = new File(String.valueOf(basedir) + fileName);
            String oldContent = content = _fileUtil.read(file);
            String newContent = "";
            while (!oldContent.equals(newContent = SourceFormatter._formatJSPContent(fileName, oldContent))) {
                oldContent = newContent;
            }
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"<br/>", "\"/>", "\" >", "@page import", "\"%>", ")%>", "javascript: "}, (String[])new String[]{"<br />", "\" />", "\">", "@ page import", "\" %>", ") %>", "javascript:"});
            if (stripJSPImports) {
                try {
                    newContent = SourceFormatter._stripJSPImports(fileName, newContent);
                }
                catch (RuntimeException runtimeException) {
                    stripJSPImports = false;
                }
            }
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"* Copyright (c) 2000-2011 Liferay, Inc."}, (String[])new String[]{"* Copyright (c) 2000-2012 Liferay, Inc."});
            if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) {
                if (oldCopyright != null && newContent.contains(oldCopyright)) {
                    newContent = StringUtil.replace((String)newContent, (String)oldCopyright, (String)copyright);
                    _sourceFormatterHelper.printError(fileName, "old (c): " + fileName);
                }
                if (!newContent.contains(copyright)) {
                    String customCopyright = SourceFormatter._getCustomCopyright(file);
                    if (Validator.isNull((String)customCopyright) || !newContent.contains(customCopyright)) {
                        _sourceFormatterHelper.printError(fileName, "(c): " + fileName);
                    } else {
                        newContent = StringUtil.replace((String)newContent, (String)("<%\n" + customCopyright + "\n%>"), (String)("<%--\n" + customCopyright + "\n--%>"));
                    }
                } else {
                    newContent = StringUtil.replace((String)newContent, (String)("<%\n" + copyright + "\n%>"), (String)("<%--\n" + copyright + "\n--%>"));
                }
            }
            if ((newContent = StringUtil.replace((String)newContent, (String[])new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil."}, (String[])new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil."})).contains("    ") && !fileName.endsWith("template.vm")) {
                _sourceFormatterHelper.printError(fileName, "tab: " + fileName);
            }
            if (fileName.endsWith("init.jsp")) {
                boolean compressImports;
                int x = newContent.indexOf("<%@ page import=");
                int y = newContent.lastIndexOf("<%@ page import=");
                y = newContent.indexOf("%>", y);
                if (x != -1 && y != -1 && y > x && (compressImports = true)) {
                    String imports = newContent.substring(x, y);
                    imports = StringUtil.replace((String)imports, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "}, (String[])new String[]{"%><%@\r\n", "%><%@\n"});
                    newContent = String.valueOf(newContent.substring(0, x)) + imports + newContent.substring(y);
                }
            }
            SourceFormatter._checkXSS(fileName, newContent);
            if (newContent != null && !content.equals(newContent)) {
                _fileUtil.write(file, newContent);
                _sourceFormatterHelper.printError(fileName, file);
            }
            ++n;
        }
    }

    private static String _formatJSPContent(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        String previousLine = "";
        String currentAttributeAndValue = null;
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean readAttributes = false;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String includeFileName;
            Matcher matcher;
            int y;
            int x;
            ++lineCount;
            if (line.trim().length() == 0) {
                line = "";
            }
            if ((line = StringUtil.trimTrailing((String)line)).contains("<aui:button ") && line.contains("type=\"button\"")) {
                _sourceFormatterHelper.printError(fileName, "aui:button " + fileName + " " + lineCount);
            }
            String trimmedLine = StringUtil.trimLeading((String)line);
            String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
            if (trimmedPreviousLine.equals("%>") && Validator.isNotNull((String)line) && !trimmedLine.equals("-->")) {
                sb.append("\n");
            } else if (Validator.isNotNull((String)previousLine) && !trimmedPreviousLine.equals("<!--") && trimmedLine.equals("<%")) {
                sb.append("\n");
            } else {
                String lineBeforePreviousLine;
                if (trimmedPreviousLine.equals("<%") && Validator.isNull((String)line)) continue;
                if (trimmedPreviousLine.equals("<%") && trimmedLine.startsWith("//")) {
                    sb.append("\n");
                } else if (Validator.isNull((String)previousLine) && trimmedLine.equals("%>") && sb.index() > 2 && !(lineBeforePreviousLine = sb.stringAt(sb.index() - 3)).startsWith("//")) {
                    sb.setIndex(sb.index() - 1);
                }
            }
            if ((trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (")) && trimmedLine.endsWith(") {")) {
                SourceFormatter._checkIfClause(trimmedLine, fileName, lineCount);
            }
            if (readAttributes) {
                if (!trimmedLine.startsWith("/") && !trimmedLine.startsWith(">")) {
                    int pos = trimmedLine.indexOf("=");
                    if (pos != -1) {
                        String attribute = trimmedLine.substring(0, pos);
                        if (!trimmedLine.endsWith("\"") && !trimmedLine.endsWith("'")) {
                            _sourceFormatterHelper.printError(fileName, "attribute: " + fileName + " " + lineCount);
                            readAttributes = false;
                        } else if (Validator.isNotNull(previousAttribute)) {
                            if (!SourceFormatter._isJSPAttributName(attribute)) {
                                _sourceFormatterHelper.printError(fileName, "attribute: " + fileName + " " + lineCount);
                                readAttributes = false;
                            } else if (Validator.isNull(previousAttributeAndValue) && previousAttribute.compareTo(attribute) > 0) {
                                previousAttributeAndValue = previousLine;
                                currentAttributeAndValue = line;
                            }
                        }
                        if (!readAttributes) {
                            previousAttribute = null;
                            previousAttributeAndValue = null;
                        } else {
                            previousAttribute = attribute;
                        }
                    }
                } else {
                    previousAttribute = null;
                    readAttributes = false;
                }
            }
            if (trimmedLine.startsWith("<") && !trimmedLine.startsWith("<%") && !trimmedLine.startsWith("<!")) {
                if (!trimmedLine.contains(">") && !trimmedLine.contains(" ")) {
                    readAttributes = true;
                } else {
                    line = SourceFormatter._sortJSPAttributes(fileName, line, lineCount);
                }
            }
            if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.endsWith(".vm")) {
                    line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                }
            }
            if ((x = line.indexOf("<%@ include file")) != -1 && (y = line.indexOf("\"", (x = line.indexOf("\"", x)) + 1)) != -1 && !(matcher = _jspIncludeFilePattern.matcher(includeFileName = line.substring(x + 1, y))).find()) {
                _sourceFormatterHelper.printError(fileName, "include: " + fileName + " " + lineCount);
            }
            previousLine = line = SourceFormatter._replacePrimitiveWrapperInstantiation(fileName, line, lineCount);
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        content = SourceFormatter._formatTaglibQuotes(fileName, content, "\"");
        content = SourceFormatter._formatTaglibQuotes(fileName, content, "'");
        if (Validator.isNotNull(previousAttributeAndValue)) {
            content = StringUtil.replaceFirst((String)content, (String)(String.valueOf(previousAttributeAndValue) + "\n" + currentAttributeAndValue), (String)(String.valueOf(currentAttributeAndValue) + "\n" + previousAttributeAndValue));
        }
        return content;
    }

    private static void _formatPortletXML() throws DocumentException, IOException {
        String basedir = "./";
        if (_fileUtil.exists(String.valueOf(basedir) + "portal-impl")) {
            File file = new File(String.valueOf(basedir) + "portal-web/docroot/WEB-INF/portlet-custom.xml");
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatPortletXML(content);
            if (newContent != null && !content.equals(newContent)) {
                _fileUtil.write(file, newContent);
                _sourceFormatterHelper.printError(file.toString(), file);
            }
        } else {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(basedir);
            directoryScanner.setIncludes(new String[]{"**\\portlet.xml"});
            List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
            for (String fileName : fileNames) {
                File file = new File(String.valueOf(basedir) + fileName);
                String content = _fileUtil.read(file);
                String newContent = SourceFormatter._formatPortletXML(content);
                if (newContent == null || content.equals(newContent)) continue;
                _fileUtil.write(file, newContent);
                _sourceFormatterHelper.printError(fileName, file);
            }
        }
    }

    private static String _formatPortletXML(String content) throws DocumentException, IOException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            portletElement.sortElementsByChildElement("init-param", "name");
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            if (portletPreferencesElement == null) continue;
            portletPreferencesElement.sortElementsByChildElement("preference", "name");
        }
        return document.formattedString();
    }

    private static void _formatSH() throws IOException {
        SourceFormatter._formatSH("ext/create.sh");
        SourceFormatter._formatSH("hooks/create.sh");
        SourceFormatter._formatSH("layouttpl/create.sh");
        SourceFormatter._formatSH("portlets/create.sh");
        SourceFormatter._formatSH("themes/create.sh");
    }

    private static void _formatSH(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        String content = _fileUtil.read(new File(fileName), true);
        if (content.contains("\r")) {
            _sourceFormatterHelper.printError(fileName, "Invalid new line character");
            content = StringUtil.replace((String)content, (String)"\r", (String)"");
            _fileUtil.write(fileName, content);
        }
    }

    private static void _formatSQL() throws IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\sql\\*.sql"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatSQLContent(content);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatSQLContent(String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        String previousLineSqlCommand = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.trim().length() == 0) {
                line = "";
            }
            if (Validator.isNotNull((String)line) && !line.startsWith("\t")) {
                String sqlCommand = StringUtil.split((String)line, (char)' ')[0];
                if (Validator.isNotNull((String)previousLineSqlCommand) && !previousLineSqlCommand.equals(sqlCommand)) {
                    sb.append("\n");
                }
                previousLineSqlCommand = sqlCommand;
            } else {
                previousLineSqlCommand = "";
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private static void _formatStrutsConfigXML() throws IOException, DocumentException {
        String basedir = "./";
        if (!_fileUtil.exists(String.valueOf(basedir) + "portal-impl")) {
            return;
        }
        String fileName = "portal-web/docroot/WEB-INF/struts-config.xml";
        File file = new File(String.valueOf(basedir) + fileName);
        String content = _fileUtil.read(file);
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        Element actionMappingsElement = rootElement.element("action-mappings");
        List actionElements = actionMappingsElement.elements("action");
        String previousPath = "";
        for (Element actionElement : actionElements) {
            String path = actionElement.attributeValue("path");
            if (Validator.isNotNull((String)previousPath) && previousPath.compareTo(path) > 0 && (!previousPath.startsWith("/portal/") || path.startsWith("/portal/"))) {
                _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + path);
            }
            previousPath = path;
        }
    }

    private static String _formatTaglibQuotes(String fileName, String content, String quoteType) {
        String quoteFix = "'";
        if (quoteFix.equals(quoteType)) {
            quoteFix = "\"";
        }
        Pattern pattern = Pattern.compile(SourceFormatter._getTaglibRegex(quoteType));
        Matcher matcher = pattern.matcher(content);
        block0: while (matcher.find()) {
            int x = content.indexOf(String.valueOf(quoteType) + "<%=", matcher.start());
            int y = content.indexOf("%>" + quoteType, x);
            while (x != -1 && y != -1) {
                String result = content.substring(x + 1, y + 2);
                if (result.contains(quoteType)) {
                    int lineCount = 1;
                    char[] contentCharArray = content.toCharArray();
                    int i2 = 0;
                    while (i2 < x) {
                        if (contentCharArray[i2] == '\n') {
                            ++lineCount;
                        }
                        ++i2;
                    }
                    if (!result.contains(quoteFix)) {
                        StringBundler sb = new StringBundler(5);
                        sb.append(content.substring(0, x));
                        sb.append(quoteFix);
                        sb.append(result);
                        sb.append(quoteFix);
                        sb.append(content.substring(y + 3, content.length()));
                        content = sb.toString();
                    } else {
                        _sourceFormatterHelper.printError(fileName, "taglib: " + fileName + " " + lineCount);
                    }
                }
                if ((x = content.indexOf(String.valueOf(quoteType) + "<%=", y)) > matcher.end()) continue block0;
                y = content.indexOf("%>" + quoteType, x);
            }
        }
        return content;
    }

    private static void _formatTilesDefsXML() throws IOException, DocumentException {
        String basedir = "./";
        if (!_fileUtil.exists(String.valueOf(basedir) + "portal-impl")) {
            return;
        }
        String fileName = "portal-web/docroot/WEB-INF/tiles-defs.xml";
        File file = new File(String.valueOf(basedir) + fileName);
        String content = _fileUtil.read(file);
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        List definitionElements = rootElement.elements("definition");
        String previousName = "";
        for (Element definitionElement : definitionElements) {
            String name = definitionElement.attributeValue("name");
            if (Validator.isNotNull((String)previousName) && previousName.compareTo(name) > 0 && !previousName.equals("portlet")) {
                _sourceFormatterHelper.printError(fileName, "sort: " + fileName + " " + name);
            }
            previousName = name;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void _formatWebXML() throws IOException {
        String basedir = "./";
        if (_fileUtil.exists(String.valueOf(basedir) + "portal-impl")) {
            void var6_14;
            Properties properties = new Properties();
            String propertiesContent = _fileUtil.read(String.valueOf(basedir) + "portal-impl/src/portal.properties");
            PropertiesUtil.load((Properties)properties, (String)propertiesContent);
            Object[] locales = StringUtil.split((String)properties.getProperty("locales"));
            Arrays.sort(locales);
            TreeSet<Object> urlPatterns = new TreeSet<Object>();
            Object[] objectArray = locales;
            int n = locales.length;
            boolean n2 = false;
            while (var6_14 < n) {
                Object locale = objectArray[var6_14];
                int pos = ((String)locale).indexOf("_");
                String languageCode = ((String)locale).substring(0, pos);
                urlPatterns.add(languageCode);
                urlPatterns.add(locale);
                ++var6_14;
            }
            StringBundler sb = new StringBundler();
            for (String string : urlPatterns) {
                sb.append("\t<servlet-mapping>\n");
                sb.append("\t\t<servlet-name>I18n Servlet</servlet-name>\n");
                sb.append("\t\t<url-pattern>/" + string + "/*</url-pattern>\n");
                sb.append("\t</servlet-mapping>\n");
            }
            File file = new File(String.valueOf(basedir) + "portal-web/docroot/WEB-INF/web.xml");
            String content = _fileUtil.read(file);
            int x = content.indexOf("<servlet-mapping>");
            x = content.indexOf("<servlet-name>I18n Servlet</servlet-name>", x);
            x = content.lastIndexOf("<servlet-mapping>", x) - 1;
            int y = content.lastIndexOf("<servlet-name>I18n Servlet</servlet-name>");
            y = content.indexOf("</servlet-mapping>", y) + 19;
            String newContent = String.valueOf(content.substring(0, x)) + sb.toString() + content.substring(y);
            x = newContent.indexOf("<security-constraint>");
            x = newContent.indexOf("<web-resource-name>/c/portal/protected</web-resource-name>", x);
            x = newContent.indexOf("<url-pattern>", x) - 3;
            y = newContent.indexOf("<http-method>", x);
            y = newContent.lastIndexOf("</url-pattern>", y) + 15;
            sb = new StringBundler();
            sb.append("\t\t\t<url-pattern>/c/portal/protected</url-pattern>\n");
            for (String string : urlPatterns) {
                sb.append("\t\t\t<url-pattern>/" + string + "/c/portal/protected</url-pattern>\n");
            }
            if ((newContent = String.valueOf(newContent.substring(0, x)) + sb.toString() + newContent.substring(y)) != null && !content.equals(newContent)) {
                _fileUtil.write(file, newContent);
                System.out.println(file);
            }
        } else {
            String webXML = ContentUtil.get((String)"com/liferay/portal/deploy/dependencies/web.xml");
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(basedir);
            directoryScanner.setIncludes(new String[]{"**\\web.xml"});
            List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
            for (String fileName : fileNames) {
                String string = _fileUtil.read(String.valueOf(basedir) + fileName);
                if (!string.equals(webXML)) continue;
                _sourceFormatterHelper.printError(fileName, fileName);
            }
        }
    }

    private static String _getClassName(String line) {
        int pos = line.indexOf(" implements ");
        if (pos == -1) {
            pos = line.indexOf(" extends ");
        }
        if (pos == -1) {
            pos = line.indexOf("{");
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(" ");
        return line.substring(pos + 1);
    }

    private static String[] _getCombinedLines(String line, String previousLine, int lineTabCount, int previousLineTabCount) {
        if (Validator.isNull((String)previousLine)) {
            return null;
        }
        int previousLineLength = SourceFormatter._getLineLength(previousLine);
        String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
        if (line.length() + previousLineLength < 80) {
            if (trimmedPreviousLine.startsWith("for ") && previousLine.endsWith(":") && line.endsWith("{")) {
                return new String[]{String.valueOf(previousLine) + " " + line};
            }
            if ((previousLine.endsWith("=") || trimmedPreviousLine.equals("return")) && line.endsWith(";")) {
                return new String[]{String.valueOf(previousLine) + " " + line};
            }
            if ((trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("else ")) && (previousLine.endsWith("||") || previousLine.endsWith("&&")) && line.endsWith("{")) {
                return new String[]{String.valueOf(previousLine) + " " + line};
            }
            if ((line.startsWith("extends ") || line.startsWith("implements ") || line.startsWith("throws")) && line.endsWith("{") && lineTabCount == previousLineTabCount + 1) {
                return new String[]{String.valueOf(previousLine) + " " + line};
            }
        }
        if (previousLine.endsWith("=") && line.endsWith(";")) {
            String tempLine = line;
            int pos = 0;
            while (true) {
                int closeParenthesisCount;
                if ((pos = tempLine.indexOf("-")) == -1) {
                    pos = tempLine.indexOf("+");
                }
                if (pos == -1) {
                    pos = tempLine.indexOf("/");
                }
                if (pos == -1) {
                    pos = tempLine.indexOf("*");
                }
                if (pos == -1) break;
                String linePart = tempLine.substring(0, pos);
                int openParenthesisCount = StringUtil.count((String)linePart, (String)"(");
                if (openParenthesisCount == (closeParenthesisCount = StringUtil.count((String)linePart, (String)")"))) {
                    return null;
                }
                tempLine = String.valueOf(tempLine.substring(0, pos)) + tempLine.substring(pos + 1);
            }
            int x = line.indexOf("(");
            int y = line.indexOf(")");
            int z = line.indexOf("\"");
            if (x > 0 && x + 1 != y && (z == -1 || z > x) && line.charAt(x - 1) != ' ' && previousLineLength + 1 + x < 80) {
                String addToPreviousLine = line.substring(0, x + 1);
                if (addToPreviousLine.contains(" ")) {
                    return null;
                }
                return new String[]{String.valueOf(previousLine) + " " + addToPreviousLine, addToPreviousLine};
            }
        }
        if (previousLine.endsWith(",") && previousLineTabCount == lineTabCount && !previousLine.contains("}")) {
            int x = line.indexOf(",");
            if (x != -1) {
                while (previousLineLength + 1 + x < 80) {
                    String addToPreviousLine = line.substring(0, x + 1);
                    if (SourceFormatter._isValidJavaParameter(addToPreviousLine)) {
                        if (line.equals(addToPreviousLine)) {
                            return new String[]{String.valueOf(previousLine) + " " + addToPreviousLine};
                        }
                        return new String[]{String.valueOf(previousLine) + " " + addToPreviousLine, String.valueOf(addToPreviousLine) + " "};
                    }
                    String partAfterComma = line.substring(x + 1);
                    int pos = partAfterComma.indexOf(",");
                    if (pos != -1) {
                        x = x + pos + 1;
                        continue;
                    }
                    break;
                }
            } else if (!(line.endsWith("(") || line.endsWith("+") || line.endsWith(".") || line.startsWith("new ") && line.endsWith("{") || line.length() + previousLineLength >= 80)) {
                return new String[]{String.valueOf(previousLine) + " " + line, ""};
            }
        }
        if (!previousLine.endsWith("(")) {
            return null;
        }
        if (line.length() + previousLineLength > 80) {
            return null;
        }
        if (line.endsWith(";")) {
            return new String[]{String.valueOf(previousLine) + line};
        }
        if ((line.endsWith("{") || line.endsWith(")")) && (trimmedPreviousLine.startsWith("else ") || trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("private ") || trimmedPreviousLine.startsWith("protected ") || trimmedPreviousLine.startsWith("public "))) {
            return new String[]{String.valueOf(previousLine) + line};
        }
        return null;
    }

    private static String _getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(" ");
        return line.substring(x + 1);
    }

    private static String _getCopyright() throws IOException {
        String copyright = _fileUtil.read("copyright.txt");
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../copyright.txt");
        }
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../../copyright.txt");
        }
        return copyright;
    }

    private static String _getCustomCopyright(File file) throws IOException {
        String absolutePath = _fileUtil.getAbsolutePath(file);
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf("/", x)) != -1) {
            String copyright = _fileUtil.read(String.valueOf(absolutePath.substring(0, x + 1)) + "copyright.txt");
            if (Validator.isNotNull((String)copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }

    private static Properties _getExclusionsProperties(String fileName) throws IOException {
        String sourceFormatterExclusions;
        Properties exclusionsProperties = new Properties();
        ClassLoader classLoader = SourceFormatter.class.getClassLoader();
        URL url = classLoader.getResource(sourceFormatterExclusions = System.getProperty("source-formatter-exclusions", "com/liferay/portal/tools/dependencies/" + fileName));
        if (url == null) {
            return null;
        }
        InputStream inputStream = url.openStream();
        exclusionsProperties.load(inputStream);
        inputStream.close();
        return exclusionsProperties;
    }

    private static Tuple _getJavaTermTuple(String line) {
        int pos = line.indexOf("(");
        if (line.startsWith("\tpublic static final ") && (line.endsWith(";") || line.contains("="))) {
            return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 1});
        }
        if (line.startsWith("\tpublic static ")) {
            if (line.endsWith(";") || line.contains("=")) {
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 2});
            }
            if (pos != -1) {
                return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 3});
            }
            if (line.startsWith("\tpublic static class ")) {
                return new Tuple(new Object[]{SourceFormatter._getClassName(line), 7});
            }
        } else if (line.startsWith("\tpublic ")) {
            if (line.contains("=") || line.endsWith(";") && !line.contains("(")) {
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 6});
            }
            if (pos != -1) {
                int spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                if (spaceCount == 1) {
                    return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 4});
                }
                if (spaceCount > 1) {
                    return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 5});
                }
            } else if (line.startsWith("\tpublic class ")) {
                return new Tuple(new Object[]{SourceFormatter._getClassName(line), 8});
            }
        } else if (line.startsWith("\tprotected static final ")) {
            if (line.endsWith(";") || line.contains("=")) {
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 12});
            }
        } else if (line.startsWith("\tprotected static ")) {
            if (line.endsWith(";") || line.contains("=")) {
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 13});
            }
            if (pos != -1) {
                return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 9});
            }
            if (line.startsWith("\tprotected static class ")) {
                return new Tuple(new Object[]{SourceFormatter._getClassName(line), 15});
            }
        } else {
            if (line.startsWith("\tprotected ")) {
                if (pos != -1) {
                    if (!line.contains("=")) {
                        int spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                        if (spaceCount == 1) {
                            return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 10});
                        }
                        if (spaceCount > 1) {
                            return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 11});
                        }
                    }
                } else if (line.startsWith("\tprotected class ")) {
                    return new Tuple(new Object[]{SourceFormatter._getClassName(line), 16});
                }
                return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 14});
            }
            if (line.startsWith("\tprivate static final ")) {
                if (line.endsWith(";") || line.contains("=")) {
                    return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 20});
                }
            } else if (line.startsWith("\tprivate static ")) {
                if (line.endsWith(";") || line.contains("=")) {
                    return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 21});
                }
                if (pos != -1) {
                    return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 17});
                }
                if (line.startsWith("\tprivate static class ")) {
                    return new Tuple(new Object[]{SourceFormatter._getClassName(line), 23});
                }
            } else if (line.startsWith("\tprivate ")) {
                if (line.endsWith(";") || line.contains("=")) {
                    return new Tuple(new Object[]{SourceFormatter._getVariableName(line), 22});
                }
                if (pos != -1) {
                    int spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                    if (spaceCount == 1) {
                        return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 18});
                    }
                    if (spaceCount > 1) {
                        return new Tuple(new Object[]{SourceFormatter._getConstructorOrMethodName(line, pos), 19});
                    }
                } else if (line.startsWith("\tprivate class ")) {
                    return new Tuple(new Object[]{SourceFormatter._getClassName(line), 24});
                }
            }
        }
        return null;
    }

    private static List<String> _getJSPDuplicateImports(String fileName, String content, List<String> importLines) {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 || x >= y || !SourceFormatter._isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    private static int _getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (c2 == '\t') {
                int i2 = 0;
                while (i2 < tabLength) {
                    ++lineLength;
                    ++i2;
                }
                tabLength = 4;
            } else {
                ++lineLength;
                if (--tabLength <= 0) {
                    tabLength = 4;
                }
            }
            ++n2;
        }
        return lineLength;
    }

    private static String _getOldCopyright() throws IOException {
        String copyright = _fileUtil.read("old-copyright.txt");
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../old-copyright.txt");
        }
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../../old-copyright.txt");
        }
        return copyright;
    }

    private static Collection<String> _getPluginJavaFiles() {
        String basedir = "./";
        TreeSet<String> fileNames = new TreeSet<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\bin\\**", "**\\model\\*Clp.java", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\service\\**\\model\\*Model.java", "**\\service\\**\\model\\*Soap.java", "**\\service\\**\\model\\*Wrapper.java", "**\\service\\**\\service\\*Service.java", "**\\service\\**\\service\\*ServiceClp.java", "**\\service\\**\\service\\*ServiceFactory.java", "**\\service\\**\\service\\*ServiceUtil.java", "**\\service\\**\\service\\*ServiceWrapper.java", "**\\service\\**\\service\\ClpSerializer.java", "**\\service\\**\\service\\messaging\\*ClpMessageListener.java", "**\\service\\**\\service\\persistence\\*Finder.java", "**\\service\\**\\service\\persistence\\*Persistence.java", "**\\service\\**\\service\\persistence\\*Util.java", "**\\service\\base\\*ServiceBaseImpl.java", "**\\service\\base\\*ServiceClpInvoker.java", "**\\service\\http\\*JSONSerializer.java", "**\\service\\http\\*ServiceHttp.java", "**\\service\\http\\*ServiceJSON.java", "**\\service\\http\\*ServiceSoap.java", "**\\service\\persistence\\*PersistenceImpl.java", "**\\tmp\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        return fileNames;
    }

    private static Collection<String> _getPortalJavaFiles() {
        String basedir = "./";
        TreeSet<String> fileNames = new TreeSet<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\*_IW.java", "**\\PropsValues.java", "**\\bin\\**", "**\\classes\\*", "**\\counter\\service\\**", "**\\jsp\\*", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\portal\\service\\**", "**\\portal-client\\**", "**\\portal-service\\**\\model\\*Model.java", "**\\portal-service\\**\\model\\*Soap.java", "**\\portal-service\\**\\model\\*Wrapper.java", "**\\portal-web\\classes\\**\\*.java", "**\\portal-web\\test\\**\\*Test.java", "**\\portal-web\\test\\**\\*Tests.java", "**\\portlet\\**\\service\\**", "**\\tmp\\**", "**\\tools\\tck\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        excludes = new String[]{"**\\bin\\**", "**\\portal-client\\**", "**\\tools\\ext_tmpl\\**", "**\\*_IW.java", "**\\test\\**\\*PersistenceTest.java"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\com\\liferay\\portal\\service\\ServiceContext*.java", "**\\model\\BaseModel.java", "**\\model\\impl\\BaseModelImpl.java", "**\\service\\Base*.java", "**\\service\\PersistedModelLocalService*.java", "**\\service\\base\\PrincipalBean.java", "**\\service\\http\\*HttpTest.java", "**\\service\\http\\*SoapTest.java", "**\\service\\http\\TunnelUtil.java", "**\\service\\impl\\*.java", "**\\service\\jms\\*.java", "**\\service\\permission\\*.java", "**\\service\\persistence\\BasePersistence.java", "**\\service\\persistence\\BatchSession*.java", "**\\service\\persistence\\*FinderImpl.java", "**\\service\\persistence\\*Query.java", "**\\service\\persistence\\impl\\BasePersistenceImpl.java", "**\\portal-impl\\test\\**\\*.java", "**\\portal-service\\**\\liferay\\documentlibrary\\**.java", "**\\portal-service\\**\\liferay\\lock\\**.java", "**\\portal-service\\**\\liferay\\mail\\**.java", "**\\util-bridges\\**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        return fileNames;
    }

    private static String _getTaglibRegex(String quoteType) {
        StringBuilder sb = new StringBuilder();
        sb.append("<(");
        int i2 = 0;
        while (i2 < _TAG_LIBRARIES.length) {
            sb.append(_TAG_LIBRARIES[i2]);
            sb.append("|");
            ++i2;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("):([^>]|%>)*");
        sb.append(quoteType);
        sb.append("<%=.*");
        sb.append(quoteType);
        sb.append(".*%>");
        sb.append(quoteType);
        sb.append("([^>]|%>)*>");
        return sb.toString();
    }

    private static String _getVariableName(String line) {
        int x = line.indexOf("=");
        int y = line.lastIndexOf(" ");
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim((String)line);
            y = line.lastIndexOf(" ");
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    private static boolean _isGenerated(String content) {
        return content.contains("* @generated") || content.contains("$ANTLR");
    }

    private static boolean _isInJavaTermTypeGroup(int javaTermType, int[] javaTermTypeGroup) {
        int[] nArray = javaTermTypeGroup;
        int n = javaTermTypeGroup.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            if (javaTermType == type) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean _isJSPAttributName(String attributeName) {
        if (Validator.isNull((String)attributeName)) {
            return false;
        }
        Matcher matcher = _jspAttributeNamePattern.matcher(attributeName);
        return matcher.matches();
    }

    private static boolean _isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) {
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf("\"", y)) == -1) {
            return false;
        }
        int z = content.indexOf("\"", y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
        includeFileName = String.valueOf(docrootPath) + includeFileName;
        return SourceFormatter._isJSPDuplicateImport(includeFileName, importLine, true);
    }

    private static boolean _isJSPImportRequired(String fileName, String className, Set<String> includeFileNames, Set<String> checkedFileNames) {
        String[] includeFileNamesArray;
        if (checkedFileNames.contains(fileName)) {
            return false;
        }
        checkedFileNames.add(fileName);
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[^A-Za-z0-9_]" + className + "[^A-Za-z0-9_\"]");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return true;
        }
        SourceFormatter._addJSPIncludeFileNames(fileName, includeFileNames);
        String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
        fileName = fileName.replaceFirst(docrootPath, "");
        if (fileName.endsWith("init.jsp") || fileName.contains("init-ext.jsp")) {
            SourceFormatter._addJSPReferenceFileNames(fileName, includeFileNames);
        }
        String[] stringArray = includeFileNamesArray = includeFileNames.toArray(new String[includeFileNames.size()]);
        int n = includeFileNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String includeFileName = stringArray[n2];
            if (!checkedFileNames.contains(includeFileName) && SourceFormatter._isJSPImportRequired(includeFileName, className, includeFileNames, checkedFileNames)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean _isValidJavaParameter(String javaParameter) {
        int quoteCount = StringUtil.count((String)javaParameter, (String)"\"");
        if (quoteCount % 2 == 1) {
            return false;
        }
        javaParameter = SourceFormatter._stripQuotes(javaParameter);
        int openParenthesisCount = StringUtil.count((String)javaParameter, (String)"(");
        int closeParenthesisCount = StringUtil.count((String)javaParameter, (String)")");
        int lessThanCount = StringUtil.count((String)javaParameter, (String)"<");
        int greaterThanCount = StringUtil.count((String)javaParameter, (String)">");
        int openCurlyBraceCount = StringUtil.count((String)javaParameter, (String)"{");
        int closeCurlyBraceCount = StringUtil.count((String)javaParameter, (String)"}");
        return openParenthesisCount == closeParenthesisCount && lessThanCount == greaterThanCount && openCurlyBraceCount == closeCurlyBraceCount;
    }

    private static String _replacePrimitiveWrapperInstantiation(String fileName, String line, int lineCount) {
        return line;
    }

    private static String _sortExceptions(String line) {
        if (!line.endsWith("{") && !line.endsWith(";")) {
            return line;
        }
        int x = line.indexOf("throws ");
        if (x == -1) {
            return line;
        }
        String previousException = "";
        String[] exceptions = StringUtil.split((String)line.substring(x), (char)' ');
        int i2 = 1;
        while (i2 < exceptions.length) {
            String exception = exceptions[i2];
            if (exception.equals("{")) break;
            if (exception.endsWith(",") || exception.endsWith(";")) {
                exception = exception.substring(0, exception.length() - 1);
            }
            if (Validator.isNotNull((String)previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                return StringUtil.replace((String)line, (String)(String.valueOf(previousException) + ", " + exception), (String)(String.valueOf(exception) + ", " + previousException));
            }
            previousException = exception;
            ++i2;
        }
        return line;
    }

    private static String _sortJSPAttributes(String fileName, String line, int lineCount) {
        String s = line;
        int x = s.indexOf(" ");
        if (x == -1) {
            return line;
        }
        s = s.substring(x + 1);
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean wrongOrder = false;
        x = 0;
        while ((x = s.indexOf("=")) != -1 && s.length() > x + 1) {
            char delimeter;
            String attribute = s.substring(0, x);
            if (!SourceFormatter._isJSPAttributName(attribute)) {
                return line;
            }
            if (Validator.isNotNull(previousAttribute) && previousAttribute.compareTo(attribute) > 0) {
                wrongOrder = true;
            }
            if ((delimeter = (s = s.substring(x + 1)).charAt(0)) != '\'' && delimeter != '\"') {
                _sourceFormatterHelper.printError(fileName, "delimeter: " + fileName + " " + lineCount);
                return line;
            }
            int y = (s = s.substring(1)).indexOf(delimeter);
            if (y == -1 || s.length() <= y + 1) {
                return line;
            }
            String value = s.substring(0, y);
            if (delimeter == '\'' && !value.contains("\"")) {
                return StringUtil.replace((String)line, (String)("'" + value + "'"), (String)("\"" + value + "\""));
            }
            if (value.contains("<%") && !value.contains("%>")) {
                int z = s.indexOf("%>");
                if (z == -1) {
                    return line;
                }
                y = s.substring(z).indexOf(delimeter);
                value = s.substring(0, y + z);
            }
            StringBundler sb = new StringBundler(5);
            sb.append(attribute);
            sb.append("=");
            sb.append(delimeter);
            sb.append(value);
            sb.append(delimeter);
            String currentAttributeAndValue = sb.toString();
            if (wrongOrder) {
                if (line.contains(currentAttributeAndValue) && line.contains(previousAttributeAndValue)) {
                    line = StringUtil.replaceFirst((String)line, previousAttributeAndValue, (String)currentAttributeAndValue);
                    line = StringUtil.replaceLast((String)line, (String)currentAttributeAndValue, (String)previousAttributeAndValue);
                }
                return line;
            }
            s = s.substring(y + 1);
            s = StringUtil.trimLeading((String)s);
            previousAttribute = attribute;
            previousAttributeAndValue = currentAttributeAndValue;
        }
        return line;
    }

    private static String _stripJSPImports(String fileName, String content) throws IOException {
        String afterImports;
        if (!(fileName = fileName.replace('\\', '/')).contains("docroot") || fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = _jspImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        imports = StringUtil.replace((String)imports, (String[])new String[]{"%><%@\r\n", "%><%@\n"}, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "});
        if (!fileName.endsWith("html/common/init.jsp") && !fileName.endsWith("html/portal/init.jsp")) {
            ArrayList<String> importLines = new ArrayList<String>();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (!line.contains("import=")) continue;
                importLines.add(line);
            }
            List<String> unneededImports = SourceFormatter._getJSPDuplicateImports(fileName, content, importLines);
            SourceFormatter._addJSPUnusedImports(fileName, importLines, unneededImports);
            for (String unneededImport : unneededImports) {
                imports = StringUtil.replace((String)imports, (String)unneededImport, (String)"");
            }
        }
        imports = SourceFormatter._formatImports(imports, 17);
        String beforeImports = content.substring(0, matcher.start());
        if (Validator.isNull((String)imports)) {
            beforeImports = StringUtil.replaceLast((String)beforeImports, (String)"\n", (String)"");
        }
        if (Validator.isNull((String)(afterImports = content.substring(matcher.end())))) {
            imports = StringUtil.replaceLast((String)imports, (String)"\n", (String)"");
            content = String.valueOf(beforeImports) + imports;
            return content;
        }
        content = String.valueOf(beforeImports) + imports + "\n" + afterImports;
        return content;
    }

    private static String _stripRedundantParentheses(String s) {
        int x = 0;
        while (true) {
            x = s.indexOf("(", x + 1);
            int y = s.indexOf(")", x);
            if (x == -1 || y == -1) {
                return s;
            }
            String linePart = s.substring(x + 1, y);
            if (!Validator.isAlphanumericName((String)(linePart = StringUtil.replace((String)linePart, (String)",", (String)""))) && !Validator.isNull((String)linePart)) continue;
            s = String.valueOf(s.substring(0, x)) + s.substring(y + 1);
        }
    }

    private static String _stripQuotes(String s) {
        String[] parts = StringUtil.split((String)s, (char)'\"');
        int i2 = 1;
        while (i2 < parts.length) {
            s = StringUtil.replaceFirst((String)s, (String)("\"" + parts[i2] + "\""), (String)"");
            i2 += 2;
        }
        return s;
    }
}

