/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.jspc.resin;

import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.util.FileImpl;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tools.ant.DirectoryScanner;

public class BatchJspCompiler {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private String _appDir;
    private String _classDir;

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new BatchJspCompiler(args[0], args[1]);
    }

    public BatchJspCompiler(String appDir, String classDir) {
        try {
            this._appDir = appDir;
            this._classDir = classDir;
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(appDir);
            ds.setIncludes(new String[]{"**\\*.jsp"});
            ds.scan();
            Object[] fileNames = ds.getIncludedFiles();
            Arrays.sort(fileNames);
            this._compile((String[])fileNames);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void _compile(String[] fileNames) throws Exception {
        if (fileNames.length == 0) {
            return;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-app-dir");
        arguments.add(this._appDir);
        arguments.add("-class-dir");
        arguments.add(this._classDir);
        arguments.addAll(Arrays.asList(fileNames));
        MethodKey methodKey = new MethodKey("com.caucho.jsp.JspCompiler", "main", new Class[]{String[].class});
        MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{arguments.toArray(new String[arguments.size()])});
        try {
            methodHandler.invoke(false);
        }
        catch (Exception e2) {
            _fileUtil.write(String.valueOf(this._appDir) + "/../jspc_error", StackTraceUtil.getStackTrace((Throwable)e2));
        }
    }
}

