/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.counter.model.Counter;
import com.liferay.counter.model.impl.CounterModelImpl;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.PortletPreferences;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.model.impl.PermissionImpl;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.model.impl.ResourceCodeImpl;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.model.impl.ResourcePermissionImpl;
import com.liferay.portal.model.impl.RoleImpl;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.impl.AssetEntryImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.blogs.model.impl.BlogsStatsUserImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLSync;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryMetadataImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileRankImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLSyncImpl;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordImpl;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordSetImpl;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordVersionImpl;
import com.liferay.portlet.dynamicdatamapping.model.DDMContent;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureLink;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMContentImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStorageLinkImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStructureImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStructureLinkImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.impl.JournalArticleImpl;
import com.liferay.portlet.journal.model.impl.JournalArticleResourceImpl;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBDiscussionImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageImpl;
import com.liferay.portlet.messageboards.model.impl.MBStatsUserImpl;
import com.liferay.portlet.messageboards.model.impl.MBThreadImpl;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.impl.SocialActivityImpl;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.util.SimpleCounter;
import java.io.File;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFactory {
    private Role _administratorRole;
    private long _baseCreateTime = System.currentTimeMillis() + 31536000000L;
    private String _baseDir;
    private ClassName _blogsEntryClassName;
    private List<ClassName> _classNames;
    private Company _company;
    private SimpleCounter _counter;
    private List<CounterModelImpl> _counters;
    private ClassName _ddlRecordSetClassName;
    private ClassName _ddmContentClassName;
    private User _defaultUser;
    private SimpleCounter _dlDateCounter;
    private ClassName _dlFileEntryClassName;
    private ClassName _groupClassName;
    private List<Group> _groups;
    private Group _guestGroup;
    private Role _guestRole;
    private Map<String, Long> _individualResourceCodeIds;
    private Map<Long, String> _individualResourceNames;
    private ClassName _journalArticleClassName;
    private String _journalArticleContent;
    private int _maxGroupsCount;
    private int _maxUserToGroupCount;
    private ClassName _mbMessageClassName;
    private Role _organizationAdministratorRole;
    private Role _organizationOwnerRole;
    private Role _organizationUserRole;
    private Role _ownerRole;
    private SimpleCounter _permissionCounter;
    private Role _powerUserRole;
    private SimpleCounter _resourceCodeCounter;
    private List<ResourceCode> _resourceCodes;
    private SimpleCounter _resourceCounter;
    private SimpleCounter _resourcePermissionCounter;
    private ClassName _roleClassName;
    private List<Role> _roles;
    private Format _simpleDateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private Role _siteAdministratorRole;
    private Role _siteMemberRole;
    private Role _siteOwnerRole;
    private SimpleCounter _socialActivityCounter;
    private ClassName _userClassName;
    private Object[] _userNames;
    private Role _userRole;
    private ClassName _wikiPageClassName;

    public DataFactory(String baseDir, int maxGroupsCount, int maxJournalArticleSize, int maxUserToGroupCount, SimpleCounter counter, SimpleCounter dlDateCounter, SimpleCounter permissionCounter, SimpleCounter resourceCounter, SimpleCounter resourceCodeCounter, SimpleCounter resourcePermissionCounter, SimpleCounter socialActivityCounter) {
        try {
            this._baseDir = baseDir;
            this._maxGroupsCount = maxGroupsCount;
            this._maxUserToGroupCount = maxUserToGroupCount;
            this._counter = counter;
            this._dlDateCounter = dlDateCounter;
            this._permissionCounter = permissionCounter;
            this._resourceCounter = resourceCounter;
            this._resourceCodeCounter = resourceCodeCounter;
            this._resourcePermissionCounter = resourcePermissionCounter;
            this._socialActivityCounter = socialActivityCounter;
            this.initClassNames();
            this.initCompany();
            this.initDefaultUser();
            this.initGroups();
            this.initJournalArticle(maxJournalArticleSize);
            this.initResourceCodes();
            this.initRoles();
            this.initUserNames();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public AssetEntry addAssetEntry(long groupId, long userId, long classNameId, long classPK, boolean visible, String mimeType, String title) {
        AssetEntryImpl assetEntry = new AssetEntryImpl();
        assetEntry.setGroupId(groupId);
        assetEntry.setUserId(userId);
        assetEntry.setClassNameId(classNameId);
        assetEntry.setClassPK(classPK);
        assetEntry.setVisible(visible);
        assetEntry.setMimeType(mimeType);
        assetEntry.setTitle(title);
        return assetEntry;
    }

    public BlogsEntry addBlogsEntry(long groupId, long userId, String title, String urlTitle, String content) {
        BlogsEntryImpl blogsEntry = new BlogsEntryImpl();
        blogsEntry.setEntryId(this._counter.get());
        blogsEntry.setGroupId(groupId);
        blogsEntry.setUserId(userId);
        blogsEntry.setTitle(title);
        blogsEntry.setUrlTitle(urlTitle);
        blogsEntry.setContent(content);
        return blogsEntry;
    }

    public BlogsStatsUser addBlogsStatsUser(long groupId, long userId) {
        BlogsStatsUserImpl blogsStatsUser = new BlogsStatsUserImpl();
        blogsStatsUser.setGroupId(groupId);
        blogsStatsUser.setUserId(userId);
        return blogsStatsUser;
    }

    public Contact addContact(String firstName, String lastName) {
        ContactImpl contact = new ContactImpl();
        contact.setContactId(this._counter.get());
        contact.setAccountId(this._company.getAccountId());
        contact.setFirstName(firstName);
        contact.setLastName(lastName);
        return contact;
    }

    public DDLRecord addDDLRecord(long groupId, long companyId, long userId, long ddlRecordSetId) {
        DDLRecordImpl ddlRecord = new DDLRecordImpl();
        ddlRecord.setRecordId(this._counter.get());
        ddlRecord.setGroupId(groupId);
        ddlRecord.setCompanyId(companyId);
        ddlRecord.setUserId(userId);
        ddlRecord.setCreateDate(this.newCreateDate());
        ddlRecord.setRecordSetId(ddlRecordSetId);
        return ddlRecord;
    }

    public DDLRecordSet addDDLRecordSet(long groupId, long companyId, long userId, long ddmStructureId) {
        DDLRecordSetImpl ddlRecordSet = new DDLRecordSetImpl();
        ddlRecordSet.setRecordSetId(this._counter.get());
        ddlRecordSet.setGroupId(groupId);
        ddlRecordSet.setCompanyId(companyId);
        ddlRecordSet.setUserId(userId);
        ddlRecordSet.setDDMStructureId(ddmStructureId);
        return ddlRecordSet;
    }

    public DDLRecordVersion addDDLRecordVersion(DDLRecord ddlRecord) {
        DDLRecordVersionImpl ddlRecordVersion = new DDLRecordVersionImpl();
        ddlRecordVersion.setRecordVersionId(this._counter.get());
        ddlRecordVersion.setGroupId(ddlRecord.getGroupId());
        ddlRecordVersion.setCompanyId(ddlRecord.getCompanyId());
        ddlRecordVersion.setUserId(ddlRecord.getUserId());
        ddlRecordVersion.setRecordSetId(ddlRecord.getRecordSetId());
        ddlRecordVersion.setRecordId(ddlRecord.getRecordId());
        return ddlRecordVersion;
    }

    public DDMContent addDDMContent(long groupId, long companyId, long userId) {
        DDMContentImpl ddmContent = new DDMContentImpl();
        ddmContent.setContentId(this._counter.get());
        ddmContent.setGroupId(groupId);
        ddmContent.setCompanyId(companyId);
        ddmContent.setUserId(userId);
        return ddmContent;
    }

    public DDMStorageLink addDDMStorageLink(long classNameId, long classPK, long structureId) {
        DDMStorageLinkImpl ddmStorageLink = new DDMStorageLinkImpl();
        ddmStorageLink.setStorageLinkId(this._counter.get());
        ddmStorageLink.setClassNameId(classNameId);
        ddmStorageLink.setClassPK(classPK);
        ddmStorageLink.setStructureId(structureId);
        return ddmStorageLink;
    }

    public DDMStructure addDDMStructure(long groupId, long companyId, long userId, long classNameId) {
        DDMStructureImpl ddmStructure = new DDMStructureImpl();
        ddmStructure.setStructureId(this._counter.get());
        ddmStructure.setGroupId(groupId);
        ddmStructure.setCompanyId(companyId);
        ddmStructure.setUserId(userId);
        ddmStructure.setCreateDate(this.newCreateDate());
        ddmStructure.setClassNameId(classNameId);
        return ddmStructure;
    }

    public DDMStructureLink addDDMStructureLink(long classPK, long structureId) {
        DDMStructureLinkImpl ddmStructureLink = new DDMStructureLinkImpl();
        ddmStructureLink.setStructureLinkId(this._counter.get());
        ddmStructureLink.setClassNameId(this._dlFileEntryClassName.getClassNameId());
        ddmStructureLink.setClassPK(classPK);
        ddmStructureLink.setStructureId(structureId);
        return ddmStructureLink;
    }

    public DLFileEntry addDlFileEntry(long groupId, long companyId, long userId, long folderId, String extension, String mimeType, String name, String title, String description) {
        DLFileEntryImpl dlFileEntry = new DLFileEntryImpl();
        dlFileEntry.setFileEntryId(this._counter.get());
        dlFileEntry.setGroupId(groupId);
        dlFileEntry.setCompanyId(companyId);
        dlFileEntry.setUserId(userId);
        dlFileEntry.setCreateDate(this.newCreateDate());
        dlFileEntry.setRepositoryId(groupId);
        dlFileEntry.setFolderId(folderId);
        dlFileEntry.setName(name);
        dlFileEntry.setExtension(extension);
        dlFileEntry.setMimeType(mimeType);
        dlFileEntry.setTitle(title);
        dlFileEntry.setDescription(description);
        dlFileEntry.setSmallImageId(this._counter.get());
        dlFileEntry.setLargeImageId(this._counter.get());
        return dlFileEntry;
    }

    public DLFileEntryMetadata addDLFileEntryMetadata(long ddmStorageId, long ddmStructureId, long fileEntryId, long fileVersionId) {
        DLFileEntryMetadataImpl dlFileEntryMetadata = new DLFileEntryMetadataImpl();
        dlFileEntryMetadata.setFileEntryMetadataId(this._counter.get());
        dlFileEntryMetadata.setDDMStorageId(ddmStorageId);
        dlFileEntryMetadata.setDDMStructureId(ddmStructureId);
        dlFileEntryMetadata.setFileEntryId(fileEntryId);
        dlFileEntryMetadata.setFileVersionId(fileVersionId);
        return dlFileEntryMetadata;
    }

    public DLFileRank addDLFileRank(long groupId, long companyId, long userId, long fileEntryId) {
        DLFileRankImpl dlFileRank = new DLFileRankImpl();
        dlFileRank.setFileRankId(this._counter.get());
        dlFileRank.setGroupId(groupId);
        dlFileRank.setCompanyId(companyId);
        dlFileRank.setUserId(userId);
        dlFileRank.setFileEntryId(fileEntryId);
        return dlFileRank;
    }

    public DLFileVersion addDLFileVersion(DLFileEntry dlFileEntry) {
        DLFileVersionImpl dlFileVersion = new DLFileVersionImpl();
        dlFileVersion.setFileVersionId(this._counter.get());
        dlFileVersion.setGroupId(dlFileEntry.getGroupId());
        dlFileVersion.setCompanyId(dlFileEntry.getCompanyId());
        dlFileVersion.setUserId(dlFileEntry.getUserId());
        dlFileVersion.setRepositoryId(dlFileEntry.getRepositoryId());
        dlFileVersion.setFileEntryId(dlFileEntry.getFileEntryId());
        dlFileVersion.setExtension(dlFileEntry.getExtension());
        dlFileVersion.setMimeType(dlFileEntry.getMimeType());
        dlFileVersion.setTitle(dlFileEntry.getTitle());
        dlFileVersion.setDescription(dlFileEntry.getDescription());
        dlFileVersion.setSize(dlFileEntry.getSize());
        return dlFileVersion;
    }

    public DLFolder addDLFolder(long groupId, long companyId, long userId, long parentFolderId, String name, String description) {
        DLFolderImpl dlFolder = new DLFolderImpl();
        dlFolder.setFolderId(this._counter.get());
        dlFolder.setGroupId(groupId);
        dlFolder.setCompanyId(companyId);
        dlFolder.setUserId(userId);
        dlFolder.setCreateDate(this.newCreateDate());
        dlFolder.setRepositoryId(groupId);
        dlFolder.setParentFolderId(parentFolderId);
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        return dlFolder;
    }

    public DLSync addDLSync(long companyId, long fileId, long repositoryId, long parentFolderId, boolean typeFolder) {
        DLSyncImpl dlSync = new DLSyncImpl();
        dlSync.setSyncId(this._counter.get());
        dlSync.setCompanyId(companyId);
        dlSync.setFileId(fileId);
        dlSync.setRepositoryId(repositoryId);
        dlSync.setParentFolderId(parentFolderId);
        dlSync.setEvent("add");
        if (typeFolder) {
            dlSync.setType("folder");
        } else {
            dlSync.setType("file");
        }
        return dlSync;
    }

    public Group addGroup(long groupId, long classNameId, long classPK, String name, String friendlyURL, boolean site) {
        GroupImpl group = new GroupImpl();
        group.setGroupId(groupId);
        group.setClassNameId(classNameId);
        group.setClassPK(classPK);
        group.setName(name);
        group.setFriendlyURL(friendlyURL);
        group.setSite(site);
        return group;
    }

    public JournalArticle addJournalArticle(long resourcePrimKey, long groupId, long companyId, String articleId) {
        JournalArticleImpl journalArticle = new JournalArticleImpl();
        journalArticle.setId(this._counter.get());
        journalArticle.setResourcePrimKey(resourcePrimKey);
        journalArticle.setGroupId(groupId);
        journalArticle.setCompanyId(companyId);
        journalArticle.setArticleId(articleId);
        journalArticle.setContent(this._journalArticleContent);
        return journalArticle;
    }

    public JournalArticleResource addJournalArticleResource(long groupId) {
        JournalArticleResourceImpl journalArticleResource = new JournalArticleResourceImpl();
        journalArticleResource.setResourcePrimKey(this._counter.get());
        journalArticleResource.setGroupId(groupId);
        journalArticleResource.setArticleId(String.valueOf(this._counter.get()));
        return journalArticleResource;
    }

    public Layout addLayout(int layoutId, String name, String friendlyURL, String column1, String column2) {
        LayoutImpl layout = new LayoutImpl();
        layout.setPlid(this._counter.get());
        layout.setPrivateLayout(false);
        layout.setLayoutId(layoutId);
        layout.setName(name);
        layout.setFriendlyURL(friendlyURL);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.setProperty("layout-template-id", "2_columns_ii");
        typeSettingsProperties.setProperty("column-1", column1);
        typeSettingsProperties.setProperty("column-2", column2);
        String typeSettings = StringUtil.replace((String)typeSettingsProperties.toString(), (String)"\n", (String)"\\n");
        layout.setTypeSettings(typeSettings);
        return layout;
    }

    public MBCategory addMBCategory(long categoryId, long groupId, long companyId, long userId, String name, String description, int threadCount, int messageCount) {
        MBCategoryImpl mbCategory = new MBCategoryImpl();
        mbCategory.setCategoryId(categoryId);
        mbCategory.setGroupId(groupId);
        mbCategory.setCompanyId(companyId);
        mbCategory.setUserId(userId);
        mbCategory.setName(name);
        mbCategory.setDescription(description);
        mbCategory.setDisplayStyle(MBCategoryConstants.DEFAULT_DISPLAY_STYLE);
        mbCategory.setThreadCount(threadCount);
        mbCategory.setMessageCount(messageCount);
        return mbCategory;
    }

    public MBDiscussion addMBDiscussion(long classNameId, long classPK, long threadId) {
        MBDiscussionImpl mbDiscussion = new MBDiscussionImpl();
        mbDiscussion.setDiscussionId(this._counter.get());
        mbDiscussion.setClassNameId(classNameId);
        mbDiscussion.setClassPK(classPK);
        mbDiscussion.setThreadId(threadId);
        return mbDiscussion;
    }

    public MBMessage addMBMessage(long messageId, long groupId, long userId, long classNameId, long classPK, long categoryId, long threadId, long rootMessageId, long parentMessageId, String subject, String body) {
        MBMessageImpl mbMessage = new MBMessageImpl();
        mbMessage.setMessageId(messageId);
        mbMessage.setGroupId(groupId);
        mbMessage.setUserId(userId);
        mbMessage.setClassNameId(classNameId);
        mbMessage.setClassPK(classPK);
        mbMessage.setCategoryId(categoryId);
        mbMessage.setThreadId(threadId);
        mbMessage.setRootMessageId(rootMessageId);
        mbMessage.setParentMessageId(parentMessageId);
        mbMessage.setSubject(subject);
        mbMessage.setBody(body);
        return mbMessage;
    }

    public MBStatsUser addMBStatsUser(long groupId, long userId) {
        MBStatsUserImpl mbStatsUser = new MBStatsUserImpl();
        mbStatsUser.setGroupId(groupId);
        mbStatsUser.setUserId(userId);
        return mbStatsUser;
    }

    public MBThread addMBThread(long threadId, long groupId, long companyId, long categoryId, long rootMessageId, int messageCount, long lastPostByUserId) {
        MBThreadImpl mbThread = new MBThreadImpl();
        mbThread.setThreadId(threadId);
        mbThread.setGroupId(groupId);
        mbThread.setCompanyId(companyId);
        mbThread.setCategoryId(categoryId);
        mbThread.setRootMessageId(rootMessageId);
        mbThread.setRootMessageUserId(lastPostByUserId);
        mbThread.setMessageCount(messageCount);
        mbThread.setLastPostByUserId(lastPostByUserId);
        return mbThread;
    }

    public List<Permission> addPermissions(Resource resource) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        String name = this._individualResourceNames.get(resource.getCodeId());
        List actions = ResourceActionsUtil.getModelResourceActions((String)name);
        for (String action : actions) {
            PermissionImpl permission = new PermissionImpl();
            permission.setPermissionId(this._permissionCounter.get());
            permission.setCompanyId(this._company.getCompanyId());
            permission.setActionId(action);
            permission.setResourceId(resource.getResourceId());
            permissions.add(permission);
        }
        return permissions;
    }

    public PortletPreferences addPortletPreferences(long ownerId, long plid, String portletId, String preferences) {
        PortletPreferencesImpl portletPreferences = new PortletPreferencesImpl();
        portletPreferences.setPortletPreferencesId(this._counter.get());
        portletPreferences.setOwnerId(ownerId);
        portletPreferences.setOwnerType(3);
        portletPreferences.setPlid(plid);
        portletPreferences.setPortletId(portletId);
        portletPreferences.setPreferences(preferences);
        return portletPreferences;
    }

    public Resource addResource(String name, String primKey) {
        Long codeId = this._individualResourceCodeIds.get(name);
        ResourceImpl resource = new ResourceImpl();
        resource.setResourceId(this._resourceCounter.get());
        resource.setCodeId(codeId);
        resource.setPrimKey(primKey);
        return resource;
    }

    public List<ResourcePermission> addResourcePermission(long companyId, String name, String primKey) {
        ArrayList<ResourcePermission> resourcePermissions = new ArrayList<ResourcePermission>(2);
        ResourcePermissionImpl resourcePermission = new ResourcePermissionImpl();
        resourcePermission.setResourcePermissionId(this._resourcePermissionCounter.get());
        resourcePermission.setCompanyId(companyId);
        resourcePermission.setName(name);
        resourcePermission.setScope(4);
        resourcePermission.setPrimKey(primKey);
        resourcePermission.setRoleId(this._ownerRole.getRoleId());
        resourcePermission.setOwnerId(this._defaultUser.getUserId());
        resourcePermission.setActionIds(1L);
        resourcePermissions.add(resourcePermission);
        resourcePermission = new ResourcePermissionImpl();
        resourcePermission.setResourcePermissionId(this._resourcePermissionCounter.get());
        resourcePermission.setCompanyId(companyId);
        resourcePermission.setName(name);
        resourcePermission.setScope(4);
        resourcePermission.setPrimKey(primKey);
        resourcePermission.setRoleId(this._guestRole.getRoleId());
        resourcePermission.setOwnerId(0L);
        resourcePermission.setActionIds(1L);
        resourcePermissions.add(resourcePermission);
        return resourcePermissions;
    }

    public List<KeyValuePair> addRolesPermissions(Resource resource, List<Permission> permissions, Role memberRole) {
        KeyValuePair kvp;
        ArrayList<KeyValuePair> rolesPermissions = new ArrayList<KeyValuePair>();
        for (Permission permission : permissions) {
            KeyValuePair kvp2 = new KeyValuePair();
            kvp2.setKey(String.valueOf(this._ownerRole.getRoleId()));
            kvp2.setValue(String.valueOf(permission.getPermissionId()));
            rolesPermissions.add(kvp2);
        }
        String name = this._individualResourceNames.get(resource.getCodeId());
        if (memberRole != null) {
            List groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
            for (Permission permission : permissions) {
                if (!groupDefaultActions.contains(permission.getActionId())) continue;
                kvp = new KeyValuePair();
                kvp.setKey(String.valueOf(memberRole.getRoleId()));
                kvp.setValue(String.valueOf(permission.getPermissionId()));
                rolesPermissions.add(kvp);
            }
        }
        List guestDefaultactions = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)name);
        for (Permission permission : permissions) {
            if (!guestDefaultactions.contains(permission.getActionId())) continue;
            kvp = new KeyValuePair();
            kvp.setKey(String.valueOf(this._guestRole.getRoleId()));
            kvp.setValue(String.valueOf(permission.getPermissionId()));
            rolesPermissions.add(kvp);
        }
        return rolesPermissions;
    }

    public SocialActivity addSocialActivity(long groupId, long companyId, long userId, long classNameId, long classPK) {
        SocialActivityImpl socialActivity = new SocialActivityImpl();
        socialActivity.setActivityId(this._socialActivityCounter.get());
        socialActivity.setGroupId(groupId);
        socialActivity.setCompanyId(companyId);
        socialActivity.setUserId(userId);
        socialActivity.setClassNameId(classNameId);
        socialActivity.setClassPK(classPK);
        return socialActivity;
    }

    public User addUser(boolean defaultUser, String screenName) {
        UserImpl user = new UserImpl();
        user.setUserId(this._counter.get());
        user.setDefaultUser(defaultUser);
        if (Validator.isNull((String)screenName)) {
            screenName = String.valueOf(user.getUserId());
        }
        user.setScreenName(screenName);
        String emailAddress = String.valueOf(screenName) + "@liferay.com";
        user.setEmailAddress(emailAddress);
        return user;
    }

    public List<Long> addUserToGroupIds(long groupId) {
        ArrayList<Long> groupIds = new ArrayList<Long>(this._maxUserToGroupCount + 1);
        groupIds.add(this._guestGroup.getGroupId());
        if (groupId + (long)this._maxUserToGroupCount > (long)this._maxGroupsCount) {
            groupId = groupId - (long)this._maxUserToGroupCount + 1L;
        }
        int i2 = 0;
        while (i2 < this._maxUserToGroupCount) {
            groupIds.add(groupId + (long)i2);
            ++i2;
        }
        return groupIds;
    }

    public WikiNode addWikiNode(long groupId, long userId, String name, String description) {
        WikiNodeImpl wikiNode = new WikiNodeImpl();
        wikiNode.setNodeId(this._counter.get());
        wikiNode.setGroupId(groupId);
        wikiNode.setUserId(userId);
        wikiNode.setName(name);
        wikiNode.setDescription(description);
        return wikiNode;
    }

    public WikiPage addWikiPage(long groupId, long userId, long nodeId, String title, double version, String content, boolean head) {
        WikiPageImpl wikiPage = new WikiPageImpl();
        wikiPage.setPageId(this._counter.get());
        wikiPage.setResourcePrimKey(this._counter.get());
        wikiPage.setGroupId(groupId);
        wikiPage.setUserId(userId);
        wikiPage.setNodeId(nodeId);
        wikiPage.setTitle(title);
        wikiPage.setVersion(version);
        wikiPage.setContent(content);
        wikiPage.setHead(head);
        return wikiPage;
    }

    public Role getAdministratorRole() {
        return this._administratorRole;
    }

    public ClassName getBlogsEntryClassName() {
        return this._blogsEntryClassName;
    }

    public List<ClassName> getClassNames() {
        return this._classNames;
    }

    public Company getCompany() {
        return this._company;
    }

    public List<CounterModelImpl> getCounters() {
        return this._counters;
    }

    public String getDateLong(Date date) {
        return String.valueOf(date.getTime());
    }

    public String getDateString(Date date) {
        return this._simpleDateFormat.format(date);
    }

    public ClassName getDDLRecordSetClassName() {
        return this._ddlRecordSetClassName;
    }

    public ClassName getDDMContentClassName() {
        return this._ddmContentClassName;
    }

    public User getDefaultUser() {
        return this._defaultUser;
    }

    public ClassName getDLFileEntryClassName() {
        return this._dlFileEntryClassName;
    }

    public ClassName getGroupClassName() {
        return this._groupClassName;
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public Group getGuestGroup() {
        return this._guestGroup;
    }

    public Role getGuestRole() {
        return this._guestRole;
    }

    public ClassName getJournalArticleClassName() {
        return this._journalArticleClassName;
    }

    public ClassName getMBMessageClassName() {
        return this._mbMessageClassName;
    }

    public Role getOrganizationAdministratorRole() {
        return this._organizationAdministratorRole;
    }

    public Role getOrganizationOwnerRole() {
        return this._organizationOwnerRole;
    }

    public Role getOrganizationUserRole() {
        return this._organizationUserRole;
    }

    public Role getPowerUserRole() {
        return this._powerUserRole;
    }

    public List<ResourceCode> getResourceCodes() {
        return this._resourceCodes;
    }

    public ClassName getRoleClassName() {
        return this._roleClassName;
    }

    public List<Role> getRoles() {
        return this._roles;
    }

    public Role getSiteAdministratorRole() {
        return this._siteAdministratorRole;
    }

    public Role getSiteMemberRole() {
        return this._siteMemberRole;
    }

    public Role getSiteOwnerRole() {
        return this._siteOwnerRole;
    }

    public ClassName getUserClassName() {
        return this._userClassName;
    }

    public Object[] getUserNames() {
        return this._userNames;
    }

    public Role getUserRole() {
        return this._userRole;
    }

    public ClassName getWikiPageClassName() {
        return this._wikiPageClassName;
    }

    public void initClassNames() {
        if (this._classNames != null) {
            return;
        }
        this._classNames = new ArrayList<ClassName>();
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            ClassNameImpl className = new ClassNameImpl();
            className.setClassNameId(this._counter.get());
            className.setValue(model);
            this._classNames.add(className);
            if (model.equals(BlogsEntry.class.getName())) {
                this._blogsEntryClassName = className;
                continue;
            }
            if (model.equals(DDLRecordSet.class.getName())) {
                this._ddlRecordSetClassName = className;
                continue;
            }
            if (model.equals(DDMContent.class.getName())) {
                this._ddmContentClassName = className;
                continue;
            }
            if (model.equals(DLFileEntry.class.getName())) {
                this._dlFileEntryClassName = className;
                continue;
            }
            if (model.equals(Group.class.getName())) {
                this._groupClassName = className;
                continue;
            }
            if (model.equals(JournalArticle.class.getName())) {
                this._journalArticleClassName = className;
                continue;
            }
            if (model.equals(MBMessage.class.getName())) {
                this._mbMessageClassName = className;
                continue;
            }
            if (model.equals(Role.class.getName())) {
                this._roleClassName = className;
                continue;
            }
            if (model.equals(User.class.getName())) {
                this._userClassName = className;
                continue;
            }
            if (!model.equals(WikiPage.class.getName())) continue;
            this._wikiPageClassName = className;
        }
    }

    public void initCompany() {
        this._company = new CompanyImpl();
        this._company.setCompanyId(this._counter.get());
        this._company.setAccountId(this._counter.get());
    }

    public void initCounters() {
        if (this._counters != null) {
            return;
        }
        this._counters = new ArrayList<CounterModelImpl>();
        CounterModelImpl counter = new CounterModelImpl();
        counter.setName(Counter.class.getName());
        counter.setCurrentId(this._counter.get());
        this._counters.add(counter);
        counter = new CounterModelImpl();
        counter.setName(Permission.class.getName());
        counter.setCurrentId(this._permissionCounter.get());
        this._counters.add(counter);
        counter = new CounterModelImpl();
        counter.setName(Resource.class.getName());
        counter.setCurrentId(this._resourceCounter.get());
        this._counters.add(counter);
        counter = new CounterModelImpl();
        counter.setName(ResourceCode.class.getName());
        counter.setCurrentId(this._resourceCodeCounter.get());
        this._counters.add(counter);
        counter = new CounterModelImpl();
        counter.setName(ResourcePermission.class.getName());
        counter.setCurrentId(this._resourcePermissionCounter.get());
        this._counters.add(counter);
        counter = new CounterModelImpl();
        counter.setName(SocialActivity.class.getName());
        counter.setCurrentId(this._socialActivityCounter.get());
        this._counters.add(counter);
    }

    public void initDefaultUser() {
        this._defaultUser = new UserImpl();
        this._defaultUser.setUserId(this._counter.get());
    }

    public void initGroups() {
        if (this._groups != null) {
            return;
        }
        this._groups = new ArrayList<Group>();
        GroupImpl group = new GroupImpl();
        group.setGroupId(this._counter.get());
        group.setClassNameId(this._groupClassName.getClassNameId());
        group.setClassPK(group.getGroupId());
        group.setName("Guest");
        group.setFriendlyURL("/guest");
        group.setSite(true);
        this._groups.add(group);
        this._guestGroup = group;
    }

    public void initJournalArticle(int maxJournalArticleSize) throws Exception {
        if (maxJournalArticleSize <= 0) {
            maxJournalArticleSize = 1;
        }
        char[] chars = new char[maxJournalArticleSize];
        int i2 = 0;
        while (i2 < maxJournalArticleSize) {
            chars[i2] = (char)(97 + i2 % 26);
            ++i2;
        }
        this._journalArticleContent = new String(chars);
    }

    public void initResourceCodes() throws Exception {
        if (this._resourceCodes != null) {
            return;
        }
        this._resourceCodes = new ArrayList<ResourceCode>();
        this._individualResourceCodeIds = new HashMap<String, Long>();
        this._individualResourceNames = new HashMap<Long, String>();
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            this.initResourceCodes(model);
        }
        Document document = SAXReaderUtil.read((File)new File(this._baseDir, "../portal-web/docroot/WEB-INF/portlet-custom.xml"), (boolean)false);
        Element rootElement = document.getRootElement();
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            String portletName = portletElement.elementText("portlet-name");
            this.initResourceCodes(portletName);
        }
    }

    public void initResourceCodes(String name) {
        ResourceCode resourceCode = this.newResourceCode();
        resourceCode.setName(name);
        resourceCode.setScope(1);
        this._resourceCodes.add(resourceCode);
        resourceCode = this.newResourceCode();
        resourceCode.setName(name);
        resourceCode.setScope(2);
        this._resourceCodes.add(resourceCode);
        resourceCode = this.newResourceCode();
        resourceCode.setName(name);
        resourceCode.setScope(3);
        this._resourceCodes.add(resourceCode);
        resourceCode = this.newResourceCode();
        resourceCode.setName(name);
        resourceCode.setScope(4);
        this._resourceCodes.add(resourceCode);
        this._individualResourceCodeIds.put(name, resourceCode.getCodeId());
        this._individualResourceNames.put(resourceCode.getCodeId(), name);
    }

    public void initRoles() {
        if (this._roles != null) {
            return;
        }
        this._roles = new ArrayList<Role>();
        Role role = this.newRole();
        role.setName("Administrator");
        role.setType(1);
        this._roles.add(role);
        this._administratorRole = role;
        role = this.newRole();
        role.setName("Guest");
        role.setType(1);
        this._roles.add(role);
        this._guestRole = role;
        role = this.newRole();
        role.setName("Organization Administrator");
        role.setType(3);
        this._roles.add(role);
        this._organizationAdministratorRole = role;
        role = this.newRole();
        role.setName("Organization Owner");
        role.setType(3);
        this._roles.add(role);
        this._organizationOwnerRole = role;
        role = this.newRole();
        role.setName("Organization User");
        role.setType(3);
        this._roles.add(role);
        this._organizationUserRole = role;
        role = this.newRole();
        role.setName("Owner");
        role.setType(1);
        this._roles.add(role);
        this._ownerRole = role;
        role = this.newRole();
        role.setName("Power User");
        role.setType(1);
        this._roles.add(role);
        this._powerUserRole = role;
        role = this.newRole();
        role.setName("Site Administrator");
        role.setType(2);
        this._roles.add(role);
        this._siteAdministratorRole = role;
        role = this.newRole();
        role.setName("Site Member");
        role.setType(2);
        this._roles.add(role);
        this._siteMemberRole = role;
        role = this.newRole();
        role.setName("Site Owner");
        role.setType(2);
        this._roles.add(role);
        this._siteOwnerRole = role;
        role = this.newRole();
        role.setName("User");
        role.setType(1);
        this._roles.add(role);
        this._userRole = role;
    }

    public void initUserNames() throws Exception {
        if (this._userNames != null) {
            return;
        }
        this._userNames = new Object[2];
        String dependenciesDir = "../portal-impl/src/com/liferay/portal/tools/samplesqlbuilder/dependencies/";
        List firstNames = ListUtil.fromFile((File)new File(this._baseDir, String.valueOf(dependenciesDir) + "first_names.txt"));
        List lastNames = ListUtil.fromFile((File)new File(this._baseDir, String.valueOf(dependenciesDir) + "last_names.txt"));
        this._userNames[0] = firstNames;
        this._userNames[1] = lastNames;
    }

    public IntegerWrapper newInteger() {
        return new IntegerWrapper();
    }

    protected Date newCreateDate() {
        return new Date(this._baseCreateTime + this._dlDateCounter.get() * 1000L);
    }

    protected ResourceCode newResourceCode() {
        ResourceCodeImpl resourceCode = new ResourceCodeImpl();
        resourceCode.setCodeId(this._resourceCodeCounter.get());
        return resourceCode;
    }

    protected Role newRole() {
        RoleImpl role = new RoleImpl();
        role.setRoleId(this._counter.get());
        role.setClassNameId(this._roleClassName.getClassNameId());
        role.setClassPK(role.getRoleId());
        return role;
    }
}

