/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.portal.dao.db.MySQLDB;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.io.CharPipe;
import com.liferay.portal.kernel.io.OutputStreamWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncTeeWriter;
import com.liferay.portal.kernel.util.DateUtil_IW;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil_IW;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.samplesqlbuilder.DataFactory;
import com.liferay.portal.tools.samplesqlbuilder.SampleMySQLDB;
import com.liferay.portal.tools.samplesqlbuilder.SequentialUUID;
import com.liferay.portal.util.InitUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.util.SimpleCounter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleSQLBuilder {
    private static final int _PIPE_BUFFER_SIZE = 0x1000000;
    private static final String _TPL_ROOT = "com/liferay/portal/tools/samplesqlbuilder/dependencies/";
    private static final int _WRITER_BUFFER_SIZE = 16384;
    private SimpleCounter _counter;
    private DataFactory _dataFactory;
    private DB _db;
    private String _dbType;
    private SimpleCounter _dlDateCounter;
    private Map<String, StringBundler> _insertSQLs = new ConcurrentHashMap<String, StringBundler>();
    private Map<String, Writer> _insertSQLWriters = new ConcurrentHashMap<String, Writer>();
    private int _maxBlogsEntryCommentCount;
    private int _maxBlogsEntryCount;
    private int _maxDDLRecordCount;
    private int _maxDDLRecordSetCount;
    private int _maxDLFileEntryCount;
    private int _maxDLFileEntrySize;
    private int _maxDLFolderCount;
    private int _maxDLFolderDepth;
    private int _maxGroupCount;
    private int _maxJournalArticleCount;
    private int _maxMBCategoryCount;
    private int _maxMBMessageCount;
    private int _maxMBThreadCount;
    private int _maxUserCount;
    private int _maxUserToGroupCount;
    private int _maxWikiNodeCount;
    private int _maxWikiPageCommentCount;
    private int _maxWikiPageCount;
    private int _optimizeBufferSize;
    private List<String> _otherSQLs = new ArrayList<String>();
    private String _outputDir;
    private boolean _outputMerge;
    private SimpleCounter _permissionCounter;
    private SimpleCounter _resourceCodeCounter;
    private SimpleCounter _resourceCounter;
    private SimpleCounter _resourcePermissionCounter;
    private boolean _securityEnabled;
    private SimpleCounter _socialActivityCounter;
    private File _tempDir;
    private String _tplBlogsEntry = "com/liferay/portal/tools/samplesqlbuilder/dependencies/blogs_entry.ftl";
    private String _tplDDLRecord = "com/liferay/portal/tools/samplesqlbuilder/dependencies/ddl_record.ftl";
    private String _tplDLFileEntry = "com/liferay/portal/tools/samplesqlbuilder/dependencies/dl_file_entry.ftl";
    private String _tplDLFolder = "com/liferay/portal/tools/samplesqlbuilder/dependencies/dl_folder.ftl";
    private String _tplDLFolders = "com/liferay/portal/tools/samplesqlbuilder/dependencies/dl_folders.ftl";
    private String _tplGroup = "com/liferay/portal/tools/samplesqlbuilder/dependencies/group.ftl";
    private String _tplJournalArticle = "com/liferay/portal/tools/samplesqlbuilder/dependencies/journal_article.ftl";
    private String _tplMBCategory = "com/liferay/portal/tools/samplesqlbuilder/dependencies/mb_category.ftl";
    private String _tplMBMessage = "com/liferay/portal/tools/samplesqlbuilder/dependencies/mb_message.ftl";
    private String _tplResourcePermission = "com/liferay/portal/tools/samplesqlbuilder/dependencies/resource_permission.ftl";
    private String _tplSample = "com/liferay/portal/tools/samplesqlbuilder/dependencies/sample.ftl";
    private String _tplSecurity = "com/liferay/portal/tools/samplesqlbuilder/dependencies/security.ftl";
    private String _tplUser = "com/liferay/portal/tools/samplesqlbuilder/dependencies/user.ftl";
    private String _tplWikiPage = "com/liferay/portal/tools/samplesqlbuilder/dependencies/wiki_page.ftl";
    private SimpleCounter _userScreenNameIncrementer;
    private Writer _writerBlogsCSV;
    private Writer _writerCompanyCSV;
    private Writer _writerDocumentLibraryCSV;
    private Writer _writerDynamicDataListsCSV;
    private Writer _writerLayoutCSV;
    private Writer _writerMessageBoardsCSV;
    private Writer _writerRepositoryCSV;
    private Writer _writerSampleSQL;
    private Writer _writerUserCSV;
    private Writer _writerWikiCSV;

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        InitUtil.initWithSpring();
        String baseDir = arguments.get("sample.sql.base.dir");
        String dbType = arguments.get("sample.sql.db.type");
        int maxBlogsEntryCommentCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.blogs.entry.comment.count"));
        int maxBlogsEntryCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.blogs.entry.count"));
        int maxDDLRecordCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.ddl.record.count"));
        int maxDDLRecordSetCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.ddl.record.set.count"));
        int maxDLFileEntryCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.dl.file.entry.count"));
        int maxDLFileEntrySize = GetterUtil.getInteger((String)arguments.get("sample.sql.max.dl.file.entry.size"));
        int maxDLFolderCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.dl.folder.count"));
        int maxDLFolderDepth = GetterUtil.getInteger((String)arguments.get("sample.sql.max.dl.folder.depth"));
        int maxGroupCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.group.count"));
        int maxJournalArticleCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.journal.article.count"));
        int maxJournalArticleSize = GetterUtil.getInteger((String)arguments.get("sample.sql.max.journal.article.size"));
        int maxMBCategoryCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.mb.category.count"));
        int maxMBMessageCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.mb.message.count"));
        int maxMBThreadCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.mb.thread.count"));
        int maxUserCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.user.count"));
        int maxUserToGroupCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.user.to.group.count"));
        int maxWikiNodeCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.wiki.node.count"));
        int maxWikiPageCommentCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.wiki.page.comment.count"));
        int maxWikiPageCount = GetterUtil.getInteger((String)arguments.get("sample.sql.max.wiki.page.count"));
        int optimizeBufferSize = GetterUtil.getInteger((String)arguments.get("sample.sql.optimize.buffer.size"));
        String outputDir = arguments.get("sample.sql.output.dir");
        boolean outputMerge = GetterUtil.getBoolean((String)arguments.get("sample.sql.output.merge"));
        boolean securityEnabled = GetterUtil.getBoolean((String)arguments.get("sample.sql.security.enabled"));
        new SampleSQLBuilder(arguments, baseDir, dbType, maxBlogsEntryCommentCount, maxBlogsEntryCount, maxDDLRecordCount, maxDDLRecordSetCount, maxDLFileEntryCount, maxDLFileEntrySize, maxDLFolderCount, maxDLFolderDepth, maxGroupCount, maxJournalArticleCount, maxJournalArticleSize, maxMBCategoryCount, maxMBMessageCount, maxMBThreadCount, maxUserCount, maxUserToGroupCount, maxWikiNodeCount, maxWikiPageCommentCount, maxWikiPageCount, optimizeBufferSize, outputDir, outputMerge, securityEnabled);
    }

    public SampleSQLBuilder(Map<String, String> arguments, String baseDir, String dbType, int maxBlogsEntryCommentCount, int maxBlogsEntryCount, int maxDDLRecordCount, int maxDDLRecordSetCount, int maxDLFileEntryCount, int maxDLFileEntrySize, int maxDLFolderCount, int maxDLFolderDepth, int maxGroupCount, int maxJournalArticleCount, int maxJournalArticleSize, int maxMBCategoryCount, int maxMBMessageCount, int maxMBThreadCount, int maxUserCount, int maxUserToGroupCount, int maxWikiNodeCount, int maxWikiPageCommentCount, int maxWikiPageCount, int optimizeBufferSize, String outputDir, boolean outputMerge, boolean securityEnabled) {
        try {
            this._dbType = dbType;
            this._maxBlogsEntryCommentCount = maxBlogsEntryCommentCount;
            this._maxBlogsEntryCount = maxBlogsEntryCount;
            this._maxDDLRecordCount = maxDDLRecordCount;
            this._maxDDLRecordSetCount = maxDDLRecordSetCount;
            this._maxDLFileEntryCount = maxDLFileEntryCount;
            this._maxDLFileEntrySize = maxDLFileEntrySize;
            this._maxDLFolderCount = maxDLFolderCount;
            this._maxDLFolderDepth = maxDLFolderDepth;
            this._maxGroupCount = maxGroupCount;
            this._maxJournalArticleCount = maxJournalArticleCount;
            this._maxMBCategoryCount = maxMBCategoryCount;
            this._maxMBMessageCount = maxMBMessageCount;
            this._maxMBThreadCount = maxMBThreadCount;
            this._maxUserCount = maxUserCount;
            this._maxUserToGroupCount = maxUserToGroupCount;
            this._maxWikiNodeCount = maxWikiNodeCount;
            this._maxWikiPageCommentCount = maxWikiPageCommentCount;
            this._maxWikiPageCount = maxWikiPageCount;
            this._optimizeBufferSize = optimizeBufferSize;
            this._outputDir = outputDir;
            this._outputMerge = outputMerge;
            this._securityEnabled = securityEnabled;
            int totalMThreadCount = maxMBCategoryCount * maxMBThreadCount;
            int totalMBMessageCount = totalMThreadCount * maxMBMessageCount;
            int counterOffset = this._maxGroupCount + this._maxGroupCount * (maxMBCategoryCount + totalMThreadCount + totalMBMessageCount) + 1;
            this._counter = new SimpleCounter((long)counterOffset);
            this._dlDateCounter = new SimpleCounter();
            this._permissionCounter = new SimpleCounter();
            this._resourceCounter = new SimpleCounter();
            this._resourceCodeCounter = new SimpleCounter();
            this._resourcePermissionCounter = new SimpleCounter();
            this._socialActivityCounter = new SimpleCounter();
            this._userScreenNameIncrementer = new SimpleCounter();
            this._dataFactory = new DataFactory(baseDir, this._maxGroupCount, maxJournalArticleSize, this._maxUserToGroupCount, this._counter, this._dlDateCounter, this._permissionCounter, this._resourceCounter, this._resourceCodeCounter, this._resourcePermissionCounter, this._socialActivityCounter);
            this._db = DBFactoryUtil.getDB((String)this._dbType);
            if (this._db instanceof MySQLDB) {
                this._db = new SampleMySQLDB();
            }
            FileUtil.delete((String)(String.valueOf(this._outputDir) + "/sample-" + this._dbType + ".sql"));
            FileUtil.deltree((String)(String.valueOf(this._outputDir) + "/output"));
            this._tempDir = new File(this._outputDir, "temp");
            this._tempDir.mkdirs();
            CharPipe charPipe = new CharPipe(0x1000000);
            this.generateSQL(charPipe);
            try {
                this.compressSQL(charPipe.getReader());
                this.mergeSQL();
            }
            finally {
                FileUtil.deltree((File)this._tempDir);
            }
            StringBundler sb = new StringBundler();
            List keys = ListUtil.fromMapKeys(arguments);
            Collections.sort(keys);
            for (String key : keys) {
                if (!key.startsWith("sample.sql")) continue;
                String value = arguments.get(key);
                sb.append(key);
                sb.append("=");
                sb.append(value);
                sb.append("\n");
            }
            FileUtil.write((File)new File(this._outputDir, "benchmarks-actual.properties"), (String)sb.toString());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void insertBlogsEntry(BlogsEntry blogsEntry) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "blogsEntry", blogsEntry);
        this.processTemplate(this._tplBlogsEntry, context);
    }

    public void insertDDLRecord(DDLRecord ddlRecord, DDLRecordSet ddlRecordSet) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "ddlRecord", ddlRecord);
        this.put(context, "ddlRecordSet", ddlRecordSet);
        this.processTemplate(this._tplDDLRecord, context);
    }

    public void insertDDLRecordSet(DDMStructure ddmStructure) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "ddmStructure", ddmStructure);
        this.processTemplate(this._tplDLFolders, context);
    }

    public void insertDLFileEntry(DLFileEntry dlFileEntry, DDMStructure ddmStructure) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "ddmStructure", ddmStructure);
        this.put(context, "dlFileEntry", dlFileEntry);
        this.processTemplate(this._tplDLFileEntry, context);
    }

    public void insertDLFolder(DLFolder dlFolder, DDMStructure ddmStructure) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "ddmStructure", ddmStructure);
        this.put(context, "dlFolder", dlFolder);
        this.processTemplate(this._tplDLFolder, context);
    }

    public void insertDLFolders(long parentDLFolderId, int dlFolderDepth, DDMStructure ddmStructure) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "ddmStructure", ddmStructure);
        this.put(context, "dlFolderDepth", dlFolderDepth);
        this.put(context, "parentDLFolderId", parentDLFolderId);
        this.processTemplate(this._tplDLFolders, context);
    }

    public void insertGroup(Group group, List<Layout> privateLayouts, List<Layout> publicLayouts) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "group", group);
        this.put(context, "privateLayouts", privateLayouts);
        this.put(context, "publicLayouts", publicLayouts);
        this.processTemplate(this._tplGroup, context);
    }

    public void insertJournalArticle(long groupId, List<Layout> journalArticleLayouts) throws Exception {
        if (journalArticleLayouts == null || journalArticleLayouts.isEmpty()) {
            return;
        }
        Map<String, Object> context = this.getContext();
        this.put(context, "groupId", groupId);
        this.put(context, "journalArticleLayouts", journalArticleLayouts);
        this.processTemplate(this._tplJournalArticle, context);
    }

    public void insertMBCategory(MBCategory mbCategory) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "mbCategory", mbCategory);
        this.processTemplate(this._tplMBCategory, context);
    }

    public void insertMBMessage(MBMessage mbMessage) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "mbMessage", mbMessage);
        this.processTemplate(this._tplMBMessage, context);
    }

    public void insertResourcePermission(String name, String primKey) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "resourceName", name);
        this.put(context, "resourcePrimkey", primKey);
        this.processTemplate(this._tplResourcePermission, context);
    }

    public void insertSecurity(String name, long primKey) throws Exception {
        this.insertSecurity(name, String.valueOf(primKey));
    }

    public void insertSecurity(String name, String primKey) throws Exception {
        if (!this._securityEnabled) {
            return;
        }
        Map<String, Object> context = this.getContext();
        Resource resource = this._dataFactory.addResource(name, primKey);
        this.put(context, "resource", resource);
        this.processTemplate(this._tplSecurity, context);
    }

    public void insertUser(Contact contact, Group group, List<Long> groupIds, List<Long> organizationIds, List<Layout> privateLayouts, List<Layout> publicLayouts, List<Role> roleIds, User user) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "contact", contact);
        this.put(context, "group", group);
        this.put(context, "groupIds", groupIds);
        this.put(context, "organizationIds", organizationIds);
        this.put(context, "privateLayouts", privateLayouts);
        this.put(context, "publicLayouts", publicLayouts);
        this.put(context, "roleIds", roleIds);
        this.put(context, "user", user);
        this.processTemplate(this._tplUser, context);
    }

    public void insertWikiPage(WikiNode wikiNode, WikiPage wikiPage) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "wikiNode", wikiNode);
        this.put(context, "wikiPage", wikiPage);
        this.processTemplate(this._tplWikiPage, context);
    }

    protected void compressInsertSQL(String insertSQL) throws IOException {
        String tableName = insertSQL.substring(0, insertSQL.indexOf(32));
        int pos = insertSQL.indexOf(" values ") + 8;
        String values = insertSQL.substring(pos, insertSQL.length() - 1);
        StringBundler sb = this._insertSQLs.get(tableName);
        if (sb == null || sb.index() == 0) {
            sb = new StringBundler();
            this._insertSQLs.put(tableName, sb);
            sb.append("insert into ");
            sb.append(insertSQL.substring(0, pos));
            sb.append("\n");
        } else {
            sb.append(",\n");
        }
        sb.append(values);
        if (sb.index() >= this._optimizeBufferSize) {
            sb.append(";\n");
            String sql = this._db.buildSQL(sb.toString());
            sb.setIndex(0);
            this.writeToInsertSQLFile(tableName, sql);
        }
    }

    protected void compressSQL(Reader reader) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);
        String s = null;
        while ((s = unsyncBufferedReader.readLine()) != null) {
            if ((s = s.trim()).length() <= 0) continue;
            if (s.startsWith("insert into ")) {
                this.compressInsertSQL(s.substring(12));
                continue;
            }
            if (s.length() <= 0) continue;
            this._otherSQLs.add(s);
        }
        unsyncBufferedReader.close();
    }

    protected Writer createFileWriter(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream);
        return this.createUnsyncBufferedWriter((Writer)writer);
    }

    protected Writer createFileWriter(String fileName) throws IOException {
        File file = new File(fileName);
        return this.createFileWriter(file);
    }

    protected Writer createUnsyncBufferedWriter(Writer writer) {
        return new UnsyncBufferedWriter(writer, 16384){

            public void flush() {
            }
        };
    }

    protected void generateSQL(final CharPipe charPipe) {
        final Writer writer = this.createUnsyncBufferedWriter(charPipe.getWriter());
        Thread thread = new Thread(){

            public void run() {
                try {
                    SampleSQLBuilder.this._writerSampleSQL = (Writer)new UnsyncTeeWriter(writer, SampleSQLBuilder.this.createFileWriter(String.valueOf(SampleSQLBuilder.this._outputDir) + "/sample.sql"));
                    this.createSample();
                    SampleSQLBuilder.this._writerSampleSQL.close();
                    charPipe.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }

            protected void createSample() throws Exception {
                SampleSQLBuilder.this._writerBlogsCSV = this.getWriter("blogs.csv");
                SampleSQLBuilder.this._writerCompanyCSV = this.getWriter("company.csv");
                SampleSQLBuilder.this._writerDocumentLibraryCSV = this.getWriter("document_library.csv");
                SampleSQLBuilder.this._writerDynamicDataListsCSV = this.getWriter("dynamic_data_lists.csv");
                SampleSQLBuilder.this._writerLayoutCSV = this.getWriter("layout.csv");
                SampleSQLBuilder.this._writerMessageBoardsCSV = this.getWriter("message_boards.csv");
                SampleSQLBuilder.this._writerRepositoryCSV = this.getWriter("repository.csv");
                SampleSQLBuilder.this._writerUserCSV = this.getWriter("user.csv");
                SampleSQLBuilder.this._writerWikiCSV = this.getWriter("wiki.csv");
                Map<String, Object> context = SampleSQLBuilder.this.getContext();
                SampleSQLBuilder.this.processTemplate(SampleSQLBuilder.this._tplSample, context);
                SampleSQLBuilder.this._writerBlogsCSV.close();
                SampleSQLBuilder.this._writerCompanyCSV.close();
                SampleSQLBuilder.this._writerDocumentLibraryCSV.close();
                SampleSQLBuilder.this._writerDynamicDataListsCSV.close();
                SampleSQLBuilder.this._writerLayoutCSV.close();
                SampleSQLBuilder.this._writerMessageBoardsCSV.close();
                SampleSQLBuilder.this._writerRepositoryCSV.close();
                SampleSQLBuilder.this._writerUserCSV.close();
                SampleSQLBuilder.this._writerWikiCSV.close();
            }

            protected Writer getWriter(String fileName) throws Exception {
                return SampleSQLBuilder.this.createFileWriter(new File(String.valueOf(SampleSQLBuilder.this._outputDir) + "/" + fileName));
            }
        };
        thread.start();
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Company company = this._dataFactory.getCompany();
        User defaultUser = this._dataFactory.getDefaultUser();
        this.put(context, "companyId", company.getCompanyId());
        this.put(context, "counter", this._counter);
        this.put(context, "dataFactory", this._dataFactory);
        this.put(context, "dateUtil", DateUtil_IW.getInstance());
        this.put(context, "defaultUserId", defaultUser.getCompanyId());
        this.put(context, "maxDLFileEntrySize", this._maxDLFileEntrySize);
        this.put(context, "maxBlogsEntryCommentCount", this._maxBlogsEntryCommentCount);
        this.put(context, "maxBlogsEntryCount", this._maxBlogsEntryCount);
        this.put(context, "maxDDLRecordCount", this._maxDDLRecordCount);
        this.put(context, "maxDDLRecordSetCount", this._maxDDLRecordSetCount);
        this.put(context, "maxDLFileEntryCount", this._maxDLFileEntryCount);
        this.put(context, "maxDLFolderCount", this._maxDLFolderCount);
        this.put(context, "maxDLFolderDepth", this._maxDLFolderDepth);
        this.put(context, "maxGroupCount", this._maxGroupCount);
        this.put(context, "maxJournalArticleCount", this._maxJournalArticleCount);
        this.put(context, "maxMBCategoryCount", this._maxMBCategoryCount);
        this.put(context, "maxMBMessageCount", this._maxMBMessageCount);
        this.put(context, "maxMBThreadCount", this._maxMBThreadCount);
        this.put(context, "maxUserCount", this._maxUserCount);
        this.put(context, "maxUserToGroupCount", this._maxUserToGroupCount);
        this.put(context, "maxWikiNodeCount", this._maxWikiNodeCount);
        this.put(context, "maxWikiPageCommentCount", this._maxWikiPageCommentCount);
        this.put(context, "maxWikiPageCount", this._maxWikiPageCount);
        this.put(context, "portalUUIDUtil", SequentialUUID.getSequentialUUID());
        this.put(context, "sampleSQLBuilder", this);
        this.put(context, "stringUtil", StringUtil_IW.getInstance());
        this.put(context, "userScreenNameIncrementer", this._userScreenNameIncrementer);
        this.put(context, "writerBlogsCSV", this._writerBlogsCSV);
        this.put(context, "writerCompanyCSV", this._writerCompanyCSV);
        this.put(context, "writerDocumentLibraryCSV", this._writerDocumentLibraryCSV);
        this.put(context, "writerDynamicDataListsCSV", this._writerDynamicDataListsCSV);
        this.put(context, "writerLayoutCSV", this._writerLayoutCSV);
        this.put(context, "writerMessageBoardsCSV", this._writerMessageBoardsCSV);
        this.put(context, "writerRepositoryCSV", this._writerRepositoryCSV);
        this.put(context, "writerUserCSV", this._writerUserCSV);
        this.put(context, "writerWikiCSV", this._writerWikiCSV);
        return context;
    }

    protected File getInsertSQLFile(String tableName) {
        return new File(this._tempDir, String.valueOf(tableName) + ".sql");
    }

    protected void mergeSQL() throws IOException {
        File outputFile = new File(String.valueOf(this._outputDir) + "/sample-" + this._dbType + ".sql");
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        if (this._outputMerge) {
            fileOutputStream = new FileOutputStream(outputFile);
            fileChannel = fileOutputStream.getChannel();
        }
        Set<Map.Entry<String, StringBundler>> insertSQLs = this._insertSQLs.entrySet();
        for (Map.Entry<String, StringBundler> entry : insertSQLs) {
            String tableName = entry.getKey();
            String sql = this._db.buildSQL(entry.getValue().toString());
            this.writeToInsertSQLFile(tableName, sql);
            Writer insertSQLWriter = this._insertSQLWriters.remove(tableName);
            insertSQLWriter.write(";\n");
            insertSQLWriter.close();
            if (!this._outputMerge) continue;
            File insertSQLFile = this.getInsertSQLFile(tableName);
            FileInputStream insertSQLFileInputStream = new FileInputStream(insertSQLFile);
            FileChannel insertSQLFileChannel = insertSQLFileInputStream.getChannel();
            insertSQLFileChannel.transferTo(0L, insertSQLFileChannel.size(), fileChannel);
            insertSQLFileChannel.close();
            insertSQLFile.delete();
        }
        Object writer = null;
        writer = this._outputMerge ? new OutputStreamWriter((OutputStream)fileOutputStream) : new FileWriter(this.getInsertSQLFile("others"));
        for (String sql : this._otherSQLs) {
            sql = this._db.buildSQL(sql);
            ((Writer)writer).write(sql);
            ((Writer)writer).write("\n");
        }
        ((Writer)writer).close();
        File outputFolder = new File(this._outputDir, "output");
        if (!this._outputMerge && !this._tempDir.renameTo(outputFolder)) {
            FileUtil.copyDirectory((File)this._tempDir, (File)outputFolder);
        }
    }

    protected void processTemplate(String name, Map<String, Object> context) throws Exception {
        FreeMarkerUtil.process(name, context, this._writerSampleSQL);
    }

    protected void put(Map<String, Object> context, String key, Object value) {
        context.put(key, value);
    }

    protected void writeToInsertSQLFile(String tableName, String sql) throws IOException {
        Writer writer = this._insertSQLWriters.get(tableName);
        if (writer == null) {
            File file = this.getInsertSQLFile(tableName);
            writer = this.createFileWriter(file);
            this._insertSQLWriters.put(tableName, writer);
        }
        writer.write(sql);
    }
}

