/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_1_0.util;

import com.liferay.portal.kernel.upgrade.util.BaseUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.blogs.util.BlogsUtil;
import java.util.HashSet;
import java.util.Set;

public class BlogsEntryUrlTitleUpgradeColumnImpl
extends BaseUpgradeColumnImpl {
    private UpgradeColumn _entryIdColumn;
    private UpgradeColumn _titleColumn;
    private Set<String> _urlTitles;

    public BlogsEntryUrlTitleUpgradeColumnImpl(UpgradeColumn entryIdColumn, UpgradeColumn titleColumn) {
        super("urlTitle");
        this._entryIdColumn = entryIdColumn;
        this._titleColumn = titleColumn;
        this._urlTitles = new HashSet<String>();
    }

    public Object getNewValue(Object oldValue) throws Exception {
        String oldUrlTitle;
        String newUrlTitle = oldUrlTitle = "";
        if (Validator.isNull((String)oldUrlTitle)) {
            long entryId = (Long)this._entryIdColumn.getOldValue();
            String title = (String)this._titleColumn.getOldValue();
            newUrlTitle = this.getUrlTitle(entryId, title);
            this._urlTitles.add(newUrlTitle);
        }
        return newUrlTitle;
    }

    protected String getUrlTitle(long entryId, String title) {
        String urlTitle;
        String newUrlTitle = urlTitle = BlogsUtil.getUrlTitle(entryId, title);
        int i2 = 1;
        while (this._urlTitles.contains(newUrlTitle)) {
            newUrlTitle = String.valueOf(urlTitle) + "_" + i2;
            ++i2;
        }
        return newUrlTitle;
    }
}

