/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_1_5;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.v5_1_5.util.DLFileEntryTable;
import com.liferay.portal.upgrade.v5_1_5.util.DLFileRankTable;
import com.liferay.portal.upgrade.v5_1_5.util.DLFileShortcutTable;
import com.liferay.portal.upgrade.v5_1_5.util.DLFileVersionTable;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.portlet.PortletPreferences;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static final String _GET_LAYOUT = "select companyId from Layout where plid = ?";

    protected void deletePortletPreferences(long portletPreferencesId) throws Exception {
        this.runSQL("delete from PortletPreferences where portletPreferencesId = " + portletPreferencesId);
    }

    protected void doUpgrade() throws Exception {
        UpgradeTable upgradeTable;
        try {
            this.runSQL("alter_column_type DLFileEntry name VARCHAR(255) null");
        }
        catch (Exception exception) {
            upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileEntry", (Object[][])DLFileEntryTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[0]);
            upgradeTable.setCreateSQL("create table DLFileEntry (uuid_ VARCHAR(75) null,fileEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,versionUserId LONG,versionUserName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,name VARCHAR(255) null,title VARCHAR(255) null,description STRING null,version DOUBLE,size_ INTEGER,readCount INTEGER,extraSettings TEXT null)");
            upgradeTable.setIndexesSQL(DLFileEntryTable.TABLE_SQL_ADD_INDEXES);
            upgradeTable.updateTable();
        }
        try {
            this.runSQL("alter_column_type DLFileRank name VARCHAR(255) null");
        }
        catch (Exception exception) {
            upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileRank", (Object[][])DLFileRankTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[0]);
            upgradeTable.setCreateSQL("create table DLFileRank (fileRankId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,createDate DATE null,folderId LONG,name VARCHAR(255) null)");
            upgradeTable.setIndexesSQL(DLFileRankTable.TABLE_SQL_ADD_INDEXES);
            upgradeTable.updateTable();
        }
        try {
            this.runSQL("alter_column_type DLFileShortcut toName VARCHAR(255) null");
        }
        catch (Exception exception) {
            upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileShortcut", (Object[][])DLFileShortcutTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[0]);
            upgradeTable.setCreateSQL("create table DLFileShortcut (uuid_ VARCHAR(75) null,fileShortcutId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,toFolderId LONG,toName VARCHAR(255) null)");
            upgradeTable.setIndexesSQL(DLFileShortcutTable.TABLE_SQL_ADD_INDEXES);
            upgradeTable.updateTable();
        }
        try {
            this.runSQL("alter_column_type DLFileVersion name VARCHAR(255) null");
        }
        catch (Exception exception) {
            upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileVersion", (Object[][])DLFileVersionTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[0]);
            upgradeTable.setCreateSQL("create table DLFileVersion (fileVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,folderId LONG,name VARCHAR(255) null,version DOUBLE,size_ INTEGER)");
            upgradeTable.setIndexesSQL(DLFileVersionTable.TABLE_SQL_ADD_INDEXES);
            upgradeTable.updateTable();
        }
        this.updateGroupId();
        this.updatePortletPreferences();
    }

    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement(_GET_LAYOUT);
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                layout = new Object[]{companyId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return layout;
    }

    protected void updateGroupId() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("update DLFileEntry set groupId = (select groupId from ");
        sb.append("DLFolder where DLFolder.folderId = DLFileEntry.folderId)");
        this.runSQL(sb.toString());
        sb = new StringBuilder();
        sb.append("update DLFileRank set groupId = (select groupId from ");
        sb.append("DLFolder where DLFolder.folderId = DLFileRank.folderId)");
        this.runSQL(sb.toString());
        sb = new StringBuilder();
        sb.append("update DLFileShortcut set groupId = (select groupId from ");
        sb.append("DLFolder where DLFolder.folderId = ");
        sb.append("DLFileShortcut.folderId)");
        this.runSQL(sb.toString());
        sb = new StringBuilder();
        sb.append("update DLFileVersion set groupId = (select groupId from ");
        sb.append("DLFolder where DLFolder.folderId = DLFileVersion.folderId)");
        this.runSQL(sb.toString());
    }

    protected void updatePortletPreferences() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select portletPreferencesId, ownerId, ownerType, plid, portletId, preferences from PortletPreferences where portletId = '20' and preferences like '%<name>fileEntryColumns</name><value></value>%'");
            rs = ps.executeQuery();
            while (rs.next()) {
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                long ownerId = rs.getLong("ownerId");
                int ownerType = rs.getInt("ownerType");
                long plid = rs.getLong("plid");
                String portletId = rs.getString("portletId");
                String preferences = rs.getString("preferences");
                Object[] layout = this.getLayout(plid);
                if (layout != null) {
                    long companyId = (Long)layout[0];
                    String newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
                    this.updatePortletPreferences(portletPreferencesId, newPreferences);
                    continue;
                }
                this.deletePortletPreferences(portletPreferencesId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updatePortletPreferences(long portletPreferencesId, String preferences) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update PortletPreferences set preferences = ? where portletPreferencesId = " + portletPreferencesId);
            ps.setString(1, preferences);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        String fileEntryColumns = portletPreferences.getValue("fileEntryColumns", "");
        if (Validator.isNull((String)fileEntryColumns)) {
            portletPreferences.reset("fileEntryColumns");
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

