/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_1_5.util;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public abstract class DependencyManager {
    protected Object[][] columns;
    protected Object[][] extraColumns;
    protected String primaryKeyName;
    protected String tableName;

    public void setColumns(Object[][] columns) {
        this.columns = columns;
    }

    public void setExtraColumns(Object[][] extraColumns) {
        this.extraColumns = extraColumns;
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this.primaryKeyName = primaryKeyName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void update(long newPrimaryKeyValue) throws Exception {
        this.update(0L, null, null, newPrimaryKeyValue, null, null);
    }

    public abstract void update(long var1, Object[] var3, Object[] var4, long var5, Object[] var7, Object[] var8) throws Exception;

    protected void deleteDuplicateData(String tableName, long primaryKeyValue) throws Exception {
        this.deleteDuplicateData(tableName, this.primaryKeyName, primaryKeyValue);
    }

    protected void deleteDuplicateData(String tableName, String columnName, long columnValue) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("delete from ");
            sb.append(tableName);
            sb.append(" where ");
            sb.append(columnName);
            sb.append(" = ?");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setLong(1, columnValue);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateDuplicateData(String tableName, long oldPrimaryKeyValue, long newPrimaryKeyValue) throws Exception {
        this.updateDuplicateData(tableName, this.primaryKeyName, oldPrimaryKeyValue, newPrimaryKeyValue);
    }

    protected void updateDuplicateData(String tableName, String columnName, long oldColumnValue, long newColumnValue) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("update ");
            sb.append(tableName);
            sb.append(" set ");
            sb.append(columnName);
            sb.append(" = ? where ");
            sb.append(columnName);
            sb.append(" = ?");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setLong(1, newColumnValue);
            ps.setLong(2, oldColumnValue);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

