/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_1_7_to_5_2_7;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.v5_2_3.util.DependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.ExpandoColumnDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.ExpandoRowDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.ExpandoTableDependencyManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeDuplicates
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeDuplicates.class);

    protected void deleteDuplicateExpando() throws Exception {
        ExpandoTableDependencyManager expandoTableDependencyManager = new ExpandoTableDependencyManager();
        this.deleteDuplicates("ExpandoTable", "tableId", (Object[][])new Object[][]{{"companyId", -5}, {"classNameId", -5}, {"name", 12}}, expandoTableDependencyManager);
        ExpandoRowDependencyManager expandoRowDependencyManager = new ExpandoRowDependencyManager();
        this.deleteDuplicates("ExpandoRow", "rowId_", (Object[][])new Object[][]{{"tableId", -5}, {"classPK", -5}}, expandoRowDependencyManager);
        ExpandoColumnDependencyManager expandoColumnDependencyManager = new ExpandoColumnDependencyManager();
        this.deleteDuplicates("ExpandoColumn", "columnId", (Object[][])new Object[][]{{"tableId", -5}, {"name", 12}}, expandoColumnDependencyManager);
        this.deleteDuplicates("ExpandoValue", "valueId", new Object[][]{{"columnId", -5}, {"rowId_", -5}});
        this.deleteDuplicates("ExpandoValue", "valueId", new Object[][]{{"tableId", -5}, {"columnId", -5}, {"classPK", -5}});
    }

    protected void deleteDuplicates(String tableName, String primaryKeyName, Object[][] columns) throws Exception {
        this.deleteDuplicates(tableName, primaryKeyName, columns, null, null);
    }

    protected void deleteDuplicates(String tableName, String primaryKeyName, Object[][] columns, DependencyManager dependencyManager) throws Exception {
        this.deleteDuplicates(tableName, primaryKeyName, columns, null, dependencyManager);
    }

    protected void deleteDuplicates(String tableName, String primaryKeyName, Object[][] columns, Object[][] extraColumns) throws Exception {
        this.deleteDuplicates(tableName, primaryKeyName, columns, extraColumns, null);
    }

    protected void deleteDuplicates(String tableName, String primaryKeyName, Object[][] columns, Object[][] extraColumns, DependencyManager dependencyManager) throws Exception {
        if (_log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Checking for duplicate data from ");
            sb.append(tableName);
            sb.append(" for unique index (");
            int i2 = 0;
            while (i2 < columns.length) {
                sb.append(columns[i2][0]);
                if (i2 + 1 < columns.length) {
                    sb.append(", ");
                }
                ++i2;
            }
            sb.append(")");
            _log.info((Object)sb.toString());
        }
        if (dependencyManager != null) {
            dependencyManager.setTableName(tableName);
            dependencyManager.setPrimaryKeyName(primaryKeyName);
            dependencyManager.setColumns(columns);
            dependencyManager.setExtraColumns(extraColumns);
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("select ");
            sb.append(primaryKeyName);
            int i3 = 0;
            while (i3 < columns.length) {
                sb.append(", ");
                sb.append(columns[i3][0]);
                ++i3;
            }
            if (extraColumns != null) {
                i3 = 0;
                while (i3 < extraColumns.length) {
                    sb.append(", ");
                    sb.append(extraColumns[i3][0]);
                    ++i3;
                }
            }
            sb.append(" from ");
            sb.append(tableName);
            sb.append(" order by ");
            i3 = 0;
            while (i3 < columns.length) {
                sb.append(columns[i3][0]);
                sb.append(", ");
                ++i3;
            }
            sb.append(primaryKeyName);
            String sql = sb.toString();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Execute SQL " + sql));
            }
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            boolean supportsStringCaseSensitiveQuery = this.isSupportsStringCaseSensitiveQuery();
            long previousPrimaryKeyValue = 0L;
            Object[] previousColumnValues = new Object[columns.length];
            Object[] previousExtraColumnValues = null;
            if (extraColumns != null) {
                previousExtraColumnValues = new Object[extraColumns.length];
            }
            while (rs.next()) {
                long primaryKeyValue = rs.getLong(primaryKeyName);
                Object[] columnValues = this.getColumnValues(rs, columns);
                Object[] extraColumnValues = this.getColumnValues(rs, extraColumns);
                boolean duplicate = true;
                int i4 = 0;
                while (i4 < columnValues.length) {
                    Object columnValue = columnValues[i4];
                    Object previousColumnValue = previousColumnValues[i4];
                    if (columnValue == null || previousColumnValue == null) {
                        duplicate = false;
                    } else if (!supportsStringCaseSensitiveQuery && columns[i4][1].equals(12)) {
                        String columnValueString = (String)columnValue;
                        String previousColumnValueString = (String)previousColumnValue;
                        if (!columnValueString.equalsIgnoreCase(previousColumnValueString)) {
                            duplicate = false;
                        }
                    } else if (!columnValue.equals(previousColumnValue)) {
                        duplicate = false;
                    }
                    if (!duplicate) break;
                    ++i4;
                }
                if (duplicate) {
                    this.runSQL("delete from " + tableName + " where " + primaryKeyName + " = " + primaryKeyValue);
                    if (dependencyManager == null) continue;
                    if (_log.isInfoEnabled()) {
                        sb = new StringBuilder();
                        sb.append("Resolving duplicate data from ");
                        sb.append(tableName);
                        sb.append(" with primary keys ");
                        sb.append(primaryKeyValue);
                        sb.append(" and ");
                        sb.append(previousPrimaryKeyValue);
                        _log.info((Object)sb.toString());
                    }
                    dependencyManager.update(previousPrimaryKeyValue, previousColumnValues, previousExtraColumnValues, primaryKeyValue, columnValues, extraColumnValues);
                    continue;
                }
                previousPrimaryKeyValue = primaryKeyValue;
                i4 = 0;
                while (i4 < columnValues.length) {
                    previousColumnValues[i4] = columnValues[i4];
                    ++i4;
                }
                if (extraColumnValues == null) continue;
                i4 = 0;
                while (i4 < extraColumnValues.length) {
                    previousExtraColumnValues[i4] = extraColumnValues[i4];
                    ++i4;
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void doUpgrade() throws Exception {
        this.deleteDuplicateExpando();
    }

    protected Object[] getColumnValues(ResultSet rs, Object[][] columns) throws Exception {
        if (columns == null) {
            return null;
        }
        Object[] columnValues = new Object[columns.length];
        int i2 = 0;
        while (i2 < columns.length) {
            String columnName = (String)columns[i2][0];
            Integer columnType = (Integer)columns[i2][1];
            if (columnType == -5) {
                columnValues[i2] = rs.getLong(columnName);
            } else if (columnType == 16) {
                columnValues[i2] = rs.getBoolean(columnName);
            } else if (columnType == 8) {
                columnValues[i2] = rs.getDouble(columnName);
            } else if (columnType == 4) {
                columnValues[i2] = rs.getInt(columnName);
            } else if (columnType == 93) {
                columnValues[i2] = rs.getTimestamp(columnName);
            } else if (columnType == 12) {
                columnValues[i2] = rs.getString(columnName);
            } else {
                throw new UpgradeException("Upgrade code using unsupported class type " + columnType);
            }
            ++i2;
        }
        return columnValues;
    }
}

