/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradePortletId
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        String[][] portletIdsArray = this.getPortletIdsArray();
        int i2 = 0;
        while (i2 < portletIdsArray.length) {
            String[] portletIds = portletIdsArray[i2];
            String oldRootPortletId = portletIds[0];
            String newRootPortletId = portletIds[1];
            this.updatePortlet(oldRootPortletId, newRootPortletId);
            this.updateResource(oldRootPortletId, newRootPortletId);
            this.updateResourceCode(oldRootPortletId, newRootPortletId);
            ++i2;
        }
    }

    protected String[][] getPortletIdsArray() {
        return new String[][]{{"109", "1_WAR_webformportlet"}, {"google_adsense_portlet_WAR_googleadsenseportlet", "1_WAR_googleadsenseportlet"}, {"google_gadget_portlet_WAR_googlegadgetportlet", "1_WAR_googlegadgetportlet"}, {"google_maps_portlet_WAR_googlemapsportlet", "1_WAR_googlemapsportlet"}};
    }

    protected void updateLayout(long plid, String typeSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateLayout(long plid, String oldPortletId, String newPortletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select typeSettings from Layout where plid = " + plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = StringUtil.replace((String)typeSettings, (String)oldPortletId, (String)newPortletId);
                this.updateLayout(plid, newTypeSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL("update Portlet set portletId = '" + newRootPortletId + "' where portletId = '" + oldRootPortletId + "'");
    }

    protected void updateResource(String oldRootPortletId, String newRootPortletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select primKey from Resource_ where primKey like ?");
            ps.setString(1, "%_LAYOUT_" + oldRootPortletId + "%");
            rs = ps.executeQuery();
            while (rs.next()) {
                String oldPrimKey = rs.getString("primKey");
                int pos = oldPrimKey.indexOf("_LAYOUT_");
                long plid = GetterUtil.getLong((String)oldPrimKey.substring(0, pos));
                String portletId = oldPrimKey.substring(pos + "_LAYOUT_".length());
                String newPrimKey = String.valueOf(plid) + "_LAYOUT_" + newRootPortletId;
                String oldPortletId = oldRootPortletId;
                String newPortletId = newRootPortletId;
                pos = portletId.indexOf("_INSTANCE_");
                if (pos != -1) {
                    portletId = portletId.substring(0, pos);
                    String instanceId = oldPrimKey.substring(pos + "_INSTANCE_".length());
                    newPrimKey = String.valueOf(newPrimKey) + "_INSTANCE_" + instanceId;
                    oldPortletId = String.valueOf(oldPortletId) + "_INSTANCE_" + instanceId;
                    newPortletId = String.valueOf(newPortletId) + "_INSTANCE_" + instanceId;
                }
                if (!portletId.equals(oldRootPortletId)) continue;
                this.runSQL("update Resource_ set primKey = '" + newPrimKey + "' where primKey = '" + oldPrimKey + "'");
                this.updateLayout(plid, oldPortletId, newPortletId);
                this.runSQL("update PortletPreferences set portletId = '" + newPortletId + "' where portletId = '" + oldPortletId + "'");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateResourceCode(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL("update ResourceCode set name = '" + newRootPortletId + "' where name = '" + oldRootPortletId + "'");
    }
}

