/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_3;

import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.v5_2_3.util.DLFileEntryTable;
import com.liferay.portal.upgrade.v5_2_3.util.DLFileRankTable;
import com.liferay.portal.upgrade.v5_2_3.util.DLFileShortcutTable;
import com.liferay.portal.upgrade.v5_2_3.util.DLFileVersionTable;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.sql.SQLException;
import javax.portlet.PortletPreferences;

public class UpgradeDocumentLibrary
extends BaseUpgradePortletPreferences {
    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter_column_type DLFileEntry name VARCHAR(255) null");
            this.runSQL("alter_column_type DLFileRank name VARCHAR(255) null");
            this.runSQL("alter_column_type DLFileShortcut toName VARCHAR(255) null");
            this.runSQL("alter_column_type DLFileVersion name VARCHAR(255) null");
        }
        catch (SQLException sQLException) {
            this.upgradeTable("DLFileEntry", DLFileEntryTable.TABLE_COLUMNS, "create table DLFileEntry (uuid_ VARCHAR(75) null,fileEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,versionUserId LONG,versionUserName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,name VARCHAR(255) null,title VARCHAR(255) null,description STRING null,version DOUBLE,size_ INTEGER,readCount INTEGER,extraSettings TEXT null)", DLFileEntryTable.TABLE_SQL_ADD_INDEXES);
            this.upgradeTable("DLFileRank", DLFileRankTable.TABLE_COLUMNS, "create table DLFileRank (fileRankId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,createDate DATE null,folderId LONG,name VARCHAR(255) null)", DLFileRankTable.TABLE_SQL_ADD_INDEXES);
            this.upgradeTable("DLFileShortcut", DLFileShortcutTable.TABLE_COLUMNS, "create table DLFileShortcut (uuid_ VARCHAR(75) null,fileShortcutId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,toFolderId LONG,toName VARCHAR(255) null)", DLFileShortcutTable.TABLE_SQL_ADD_INDEXES);
            this.upgradeTable("DLFileVersion", DLFileVersionTable.TABLE_COLUMNS, "create table DLFileVersion (fileVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,folderId LONG,name VARCHAR(255) null,version DOUBLE,size_ INTEGER)", DLFileVersionTable.TABLE_SQL_ADD_INDEXES);
        }
        this.updateGroupId();
        this.updatePortletPreferences();
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        return "portletId = '20' and preferences like '%<name>fileEntryColumns</name><value></value>%'";
    }

    protected void updateGroupId() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("update DLFileEntry set groupId = (select groupId from ");
        sb.append("DLFolder where DLFolder.folderId = DLFileEntry.folderId)");
        this.runSQL(sb.toString());
        sb.setIndex(0);
        sb.append("update DLFileRank set groupId = (select groupId from ");
        sb.append("DLFolder where DLFolder.folderId = DLFileRank.folderId)");
        this.runSQL(sb.toString());
        sb.setIndex(0);
        sb.append("update DLFileShortcut set groupId = (select groupId from ");
        sb.append("DLFolder where DLFolder.folderId = ");
        sb.append("DLFileShortcut.folderId)");
        this.runSQL(sb.toString());
        sb.setIndex(0);
        sb.append("update DLFileVersion set groupId = (select groupId from ");
        sb.append("DLFolder where DLFolder.folderId = DLFileVersion.folderId)");
        this.runSQL(sb.toString());
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        String fileEntryColumns = portletPreferences.getValue("fileEntryColumns", "");
        if (Validator.isNull((String)fileEntryColumns)) {
            portletPreferences.reset("fileEntryColumns");
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

