/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_5;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.DateUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.upgrade.v5_2_5.util.SocialActivityTable;
import com.liferay.portal.upgrade.v5_2_5.util.SocialRelationTable;
import com.liferay.portal.upgrade.v5_2_5.util.SocialRequestTable;
import com.liferay.portal.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeSocial
extends UpgradeProcess {
    private static final String _GET_GROUP = "select * from Group_ where groupId = ?";
    private static final String _GET_LAYOUT = "select * from Layout where plid = ?";
    private static Log _log = LogFactoryUtil.getLog(UpgradeSocial.class);

    protected void doUpgrade() throws Exception {
        this.updateGroupId();
        DateUpgradeColumnImpl createDateColumn = new DateUpgradeColumnImpl("createDate");
        DateUpgradeColumnImpl modifiedDateColumn = new DateUpgradeColumnImpl("modifiedDate");
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"SocialActivity", (Object[][])SocialActivityTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{createDateColumn});
        upgradeTable.setCreateSQL("create table SocialActivity (activityId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,createDate LONG,mirrorActivityId LONG,classNameId LONG,classPK LONG,type_ INTEGER,extraData STRING null,receiverUserId LONG)");
        upgradeTable.setIndexesSQL(SocialActivityTable.TABLE_SQL_ADD_INDEXES);
        upgradeTable.updateTable();
        upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"SocialRelation", (Object[][])SocialRelationTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{createDateColumn});
        upgradeTable.setCreateSQL("create table SocialRelation (uuid_ VARCHAR(75) null,relationId LONG not null primary key,companyId LONG,createDate LONG,userId1 LONG,userId2 LONG,type_ INTEGER)");
        upgradeTable.setIndexesSQL(SocialRelationTable.TABLE_SQL_ADD_INDEXES);
        upgradeTable.updateTable();
        upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"SocialRequest", (Object[][])SocialRequestTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{createDateColumn, modifiedDateColumn});
        upgradeTable.setCreateSQL("create table SocialRequest (uuid_ VARCHAR(75) null,requestId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,createDate LONG,modifiedDate LONG,classNameId LONG,classPK LONG,type_ INTEGER,extraData STRING null,receiverUserId LONG,status INTEGER)");
        upgradeTable.setIndexesSQL(SocialRequestTable.TABLE_SQL_ADD_INDEXES);
        upgradeTable.updateTable();
    }

    protected Object[] getGroup(long groupId) throws Exception {
        Object[] group = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement(_GET_GROUP);
            ps.setLong(1, groupId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long classNameId = rs.getLong("classNameId");
                long classPK = rs.getLong("classPK");
                group = new Object[]{classNameId, classPK};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return group;
    }

    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement(_GET_LAYOUT);
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                layout = new Object[]{groupId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return layout;
    }

    protected void updateGroupId() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select distinct(groupId) from SocialActivity where groupId > 0");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                try {
                    this.updateGroupId(groupId);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Throwable)e2);
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateGroupId(long groupId) throws Exception {
        Object[] group = this.getGroup(groupId);
        if (group == null) {
            return;
        }
        long classNameId = (Long)group[0];
        if (classNameId != PortalUtil.getClassNameId((String)Layout.class.getName())) {
            return;
        }
        long classPK = (Long)group[1];
        Object[] layout = this.getLayout(classPK);
        if (layout == null) {
            return;
        }
        long layoutGroupId = (Long)layout[0];
        this.runSQL("update SocialActivity set groupId = " + layoutGroupId + " where groupId = " + groupId);
    }
}

