/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_11;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.upgrade.v6_0_11.util.DLFileVersionTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateFileRanks();
        this.updateFileShortcuts();
        this.updateFileVersions();
    }

    protected long getFileEntryId(long groupId, long folderId, String name) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select fileEntryId from DLFileEntry where groupId = ? and folderId = ? and name = ?");
                ps.setLong(1, groupId);
                ps.setLong(2, folderId);
                ps.setString(3, name);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("fileEntryId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected long getGroupId(long folderId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long groupId = 0L;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId from DLFolder where folderId = ?");
            ps.setLong(1, folderId);
            rs = ps.executeQuery();
            if (rs.next()) {
                groupId = rs.getLong("groupId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return groupId;
    }

    protected void updateFileRanks() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, fileRankId, folderId, name from DLFileRank");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long fileRankId = rs.getLong("fileRankId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                long fileEntryId = this.getFileEntryId(groupId, folderId, name);
                this.runSQL("update DLFileRank set fileEntryId = " + fileEntryId + " where fileRankId = " + fileRankId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("alter table DLFileRank drop column folderId");
        this.runSQL("alter table DLFileRank drop column name");
    }

    protected void updateFileShortcuts() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileShortcutId, toFolderId, toName from DLFileShortcut");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileShortcutId = rs.getLong("fileShortcutId");
                long toFolderId = rs.getLong("toFolderId");
                String toName = rs.getString("toName");
                long groupId = this.getGroupId(toFolderId);
                long toFileEntryId = this.getFileEntryId(groupId, toFolderId, toName);
                this.runSQL("update DLFileShortcut set toFileEntryId = " + toFileEntryId + " where fileShortcutId = " + fileShortcutId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("alter table DLFileShortcut drop column toFolderId");
        this.runSQL("alter table DLFileShortcut drop column toName");
    }

    protected void updateFileVersions() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, fileVersionId, folderId, name from DLFileVersion");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long fileVersionId = rs.getLong("fileVersionId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                long fileEntryId = this.getFileEntryId(groupId, folderId, name);
                this.runSQL("update DLFileVersion set fileEntryId = " + fileEntryId + " where fileVersionId = " + fileVersionId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        try {
            this.runSQL("alter_column_type DLFileVersion extraSettings TEXT null");
            this.runSQL("alter_column_type DLFileVersion title VARCHAR(255) null");
            this.runSQL("alter table DLFileVersion drop column folderId");
            this.runSQL("alter table DLFileVersion drop column name");
        }
        catch (Exception exception) {
            UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileVersion", (Object[][])DLFileVersionTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[0]);
            upgradeTable.setCreateSQL("create table DLFileVersion (fileVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,fileEntryId LONG,extension VARCHAR(75) null,title VARCHAR(255) null,description STRING null,changeLog VARCHAR(75) null,extraSettings TEXT null,version VARCHAR(75) null,size_ LONG,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)");
            upgradeTable.setIndexesSQL(DLFileVersionTable.TABLE_SQL_ADD_INDEXES);
            upgradeTable.updateTable();
        }
    }
}

