/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_12;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateFileEntries();
        this.updateFileVersions();
        this.updateLocks();
    }

    protected long getFileEntryId(long groupId, long folderId, String name) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select fileEntryId from DLFileEntry where groupId = ? and folderId = ? and name = ?");
                ps.setLong(1, groupId);
                ps.setLong(2, folderId);
                ps.setString(3, name);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("fileEntryId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected void updateFileEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileEntryId, extension from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileEntryId = rs.getLong("fileEntryId");
                String extension = rs.getString("extension");
                String mimeType = MimeTypesUtil.getContentType((String)("A." + extension));
                this.runSQL("update DLFileEntry set mimeType = '" + mimeType + "' where fileEntryId = " + fileEntryId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateFileVersions() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileVersionId, extension from DLFileVersion");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileVersionId = rs.getLong("fileVersionId");
                String extension = rs.getString("extension");
                String mimeType = MimeTypesUtil.getContentType((String)("A." + extension));
                this.runSQL("update DLFileVersion set mimeType = '" + mimeType + "' where fileVersionId = " + fileVersionId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateLocks() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select lockId, key_ from Lock_ where className = ?");
            ps.setString(1, DLFileEntry.class.getName());
            rs = ps.executeQuery();
            while (rs.next()) {
                String name;
                long folderId;
                long groupId;
                long fileEntryId;
                long lockId = rs.getLong("lockId");
                String key = rs.getString("key_");
                String[] keyArray = StringUtil.split((String)key, (String)"#");
                if (keyArray.length != 3 || (fileEntryId = this.getFileEntryId(groupId = GetterUtil.getLong((String)keyArray[0]), folderId = GetterUtil.getLong((String)keyArray[1]), name = keyArray[2])) <= 0L) continue;
                this.runSQL("update Lock_ set key_ = '" + fileEntryId + "' where lockId = " + lockId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

