/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_12;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeMessageBoards
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateMessage();
        this.updateRatings();
        this.updateThread();
    }

    protected void updateMessage() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select messageId, body from MBMessage where (body like '%<3%') or (body like '%>_>%') or (body like '%<_<%')");
            rs = ps.executeQuery();
            while (rs.next()) {
                long messageId = rs.getLong("messageId");
                String body = rs.getString("body");
                body = StringUtil.replace((String)body, (String[])new String[]{"<3", ">_>", "<_<"}, (String[])new String[]{":love:", ":glare:", ":dry:"});
                this.updateMessage(messageId, body);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateMessage(long messageId, String body) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update MBMessage set body = ? where messageId = " + messageId);
            ps.setString(1, body);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateRatings() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select MBMessage.messageId from MBMessage where MBMessage.categoryId = -1");
            rs = ps.executeQuery();
            while (rs.next()) {
                long messageId = rs.getLong("messageId");
                this.updateRatings(messageId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateRatings(long classPK) throws Exception {
        long discussionClassNameId = PortalUtil.getClassNameId(MBDiscussion.class);
        long messageClassNameId = PortalUtil.getClassNameId(MBMessage.class);
        this.runSQL("update RatingsStats set classNameId = " + discussionClassNameId + " where classNameId = " + messageClassNameId + " and classPK = " + classPK);
        this.runSQL("update RatingsEntry set classNameId = " + discussionClassNameId + " where classNameId = " + messageClassNameId + " and classPK = " + classPK);
    }

    protected void updateThread() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select MBThread.threadId, MBMessage.companyId, MBMessage.userId from MBThread inner join MBMessage on MBThread.rootMessageId = MBMessage.messageId");
            rs = ps.executeQuery();
            while (rs.next()) {
                long threadId = rs.getLong("threadId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                this.runSQL("update MBThread set companyId = " + companyId + ", rootMessageUserId = " + userId + " where threadId = " + threadId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

