/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_12;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradePortletPreferences
extends UpgradeProcess {
    protected void addPortalPreferences(long ownerId, int ownerType, String preferences) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into PortalPreferences (portalPreferencesId, ownerId, ownerType, preferences) values (?, ?, ?, ?)");
            ps.setLong(1, this.increment());
            ps.setLong(2, ownerId);
            ps.setInt(3, ownerType);
            ps.setString(4, preferences);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addPortletPreferences(long ownerId, int ownerType, long plid, String portletId, String preferences) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into PortletPreferences (portletPreferencesId, ownerId, ownerType, plid, portletId, preferences) values (?, ?, ?, ?, ?, ?)");
            ps.setLong(1, this.increment());
            ps.setLong(2, ownerId);
            ps.setInt(3, ownerType);
            ps.setLong(4, plid);
            ps.setString(5, portletId);
            ps.setString(6, preferences);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        this.updatePortalPreferences();
        this.updatePortletPreferencesOwner();
    }

    protected long getOwnerId(long plid) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select groupId from Layout where plid = " + plid);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("groupId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected long getPortletPreferencesId(long ownerId, int ownerType, long plid, String portletId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select portletPreferencesId from PortletPreferences where ownerId = ? and ownerType = ? and plid = ? and portletId = ?");
                ps.setLong(1, ownerId);
                ps.setInt(2, ownerType);
                ps.setLong(3, plid);
                ps.setString(4, portletId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("portletPreferencesId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected void updatePortalPreferences() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select ownerId, ownerType, preferences from PortletPreferences where portletId = ?");
            ps.setString(1, "LIFERAY_PORTAL");
            rs = ps.executeQuery();
            while (rs.next()) {
                long ownerId = rs.getLong("ownerId");
                int ownerType = rs.getInt("ownerType");
                String preferences = rs.getString("preferences");
                this.addPortalPreferences(ownerId, ownerType, preferences);
            }
            this.runSQL("delete from PortletPreferences where portletId = 'LIFERAY_PORTAL'");
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updatePortletPreferencesOwner() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(8);
            sb.append("select portletPreferencesId, plid, portletId, ");
            sb.append("preferences from PortletPreferences where ownerId = ");
            sb.append(0L);
            sb.append(" and ownerType = ");
            sb.append(3);
            sb.append(" and portletId in ('8', '19', '33')");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                long portletPreferencesId;
                long plid = rs.getLong("plid");
                String portletId = rs.getString("portletId");
                String preferences = rs.getString("preferences");
                long ownerId = this.getOwnerId(plid);
                if (ownerId == 0L || (portletPreferencesId = this.getPortletPreferencesId(ownerId, 2, 0L, portletId)) != 0L) continue;
                this.addPortletPreferences(ownerId, 2, 0L, portletId, preferences);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

