/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_12;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeScheduler
extends UpgradeProcess {
    protected void deleteJob(String jobName, String jobGroup) throws Exception {
        this.runSQL("delete from QUARTZ_CRON_TRIGGERS where TRIGGER_NAME = '" + jobName + "' and TRIGGER_GROUP = '" + jobGroup + "'");
        this.runSQL("delete from QUARTZ_JOB_DETAILS where JOB_NAME = '" + jobName + "' and JOB_GROUP = '" + jobGroup + "'");
        this.runSQL("delete from QUARTZ_SIMPLE_TRIGGERS where TRIGGER_NAME = '" + jobName + "' and TRIGGER_GROUP = '" + jobGroup + "'");
        this.runSQL("delete from QUARTZ_TRIGGERS where TRIGGER_NAME = '" + jobName + "' and TRIGGER_GROUP = '" + jobGroup + "'");
    }

    protected void doUpgrade() throws Exception {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        List<Object[]> arrays = this.getUpgradeQuartzData();
        if (arrays.isEmpty()) {
            return;
        }
        for (Object[] array : arrays) {
            String jobName = (String)array[0];
            String jobGroup = (String)array[1];
            byte[] jobData = (byte[])array[2];
            if (jobData == null) {
                this.deleteJob(jobName, jobGroup);
                continue;
            }
            this.updateJobDetail(jobName, jobGroup, jobData);
        }
    }

    protected List<Object[]> getUpgradeQuartzData() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Object[]> arrays = new ArrayList<Object[]>();
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select JOB_NAME, JOB_GROUP, JOB_DATA from QUARTZ_JOB_DETAILS");
            rs = ps.executeQuery();
            while (rs.next()) {
                String jobName = rs.getString("JOB_NAME");
                String jobGroup = rs.getString("JOB_GROUP");
                byte[] jobData = rs.getBytes("JOB_DATA");
                Object[] array = new Object[3];
                if (jobData == null) {
                    array[0] = jobName;
                    array[1] = jobGroup;
                    array[2] = null;
                    arrays.add(array);
                    continue;
                }
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)new UnsyncByteArrayInputStream(jobData));
                Map jobDataMap = (Map)objectInputStream.readObject();
                objectInputStream.close();
                String destinationName = (String)jobDataMap.get("DESTINATION_NAME");
                if (!destinationName.equals("liferay/layouts_local_publisher") && !destinationName.equals("liferay/layouts_remote_publisher")) {
                    array[0] = jobName;
                    array[1] = jobGroup;
                    array[2] = null;
                    arrays.add(array);
                    continue;
                }
                JobState jobState = (JobState)jobDataMap.get("JOB_STATE");
                if (jobState == null) {
                    jobDataMap.put("STORAGE_TYPE", StorageType.PERSISTED.toString());
                    String messageJSON = (String)jobDataMap.get("MESSAGE");
                    Message message = (Message)JSONFactoryUtil.deserialize((String)messageJSON);
                    int exceptionsMaxSize = message.getInteger("EXCEPTIONS_MAX_SIZE");
                    jobState = new JobState(TriggerState.NORMAL, exceptionsMaxSize);
                    jobDataMap.put("JOB_STATE", jobState);
                }
                UnsyncByteArrayOutputStream newJobDataOutputStream = new UnsyncByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)newJobDataOutputStream);
                objectOutputStream.writeObject(jobDataMap);
                objectOutputStream.close();
                jobData = newJobDataOutputStream.toByteArray();
                array[0] = jobName;
                array[1] = jobGroup;
                array[2] = jobData;
                arrays.add(array);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return arrays;
    }

    protected void updateJobDetail(String jobName, String jobGroup, byte[] jobData) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update QUARTZ_JOB_DETAILS set JOB_DATA = ? where JOB_NAME = ? and JOB_GROUP = ?");
            ps.setBytes(1, jobData);
            ps.setString(2, jobName);
            ps.setString(3, jobGroup);
            ps.executeUpdate();
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }
}

