/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_12;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeUserName
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateTable("BookmarksEntry");
        this.updateTable("BookmarksFolder");
        this.updateTable("IGFolder");
        this.updateTable("IGImage");
    }

    protected void updateTable(String tableName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(8);
            sb.append("select distinct User_.userId, User_.firstName, ");
            sb.append("User_.middleName, User_.lastName from User_ ");
            sb.append("inner join ");
            sb.append(tableName);
            sb.append(" on ");
            sb.append(tableName);
            sb.append(".userId = User_.userId where " + tableName);
            sb.append(".userName is null or " + tableName + ".userName = ''");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long userId = rs.getLong("userId");
                String firstName = rs.getString("firstName");
                String middleName = rs.getString("middleName");
                String lastName = rs.getString("lastName");
                FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
                String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
                fullName = fullName.replace("'", "''");
                this.runSQL("update " + tableName + " set userName = '" + fullName + "' where userId = " + userId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

