/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_3;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateFileEntries();
        this.updateFileVersions();
    }

    protected List<Long> getFileVersionIds(long folderId, String name) throws Exception {
        ArrayList<Long> arrayList;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileVersionId from DLFileVersion where folderId = ? and name = ? order by version desc");
            ps.setLong(1, folderId);
            ps.setString(2, name);
            rs = ps.executeQuery();
            ArrayList<Long> fileVersionIds = new ArrayList<Long>();
            while (rs.next()) {
                long fileVersionId = rs.getLong("fileVersionId");
                fileVersionIds.add(fileVersionId);
            }
            arrayList = fileVersionIds;
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return arrayList;
    }

    protected void updateFileEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Long> tableIds = new ArrayList<Long>();
        try {
            long classNameId = PortalUtil.getClassNameId(DLFileEntry.class);
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select tableId from ExpandoTable where classNameId = " + classNameId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long tableId = rs.getLong("tableId");
                tableIds.add(tableId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select uuid_, fileEntryId, groupId, folderId, name, title from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                String uuid_ = rs.getString("uuid_");
                long fileEntryId = rs.getLong("fileEntryId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String title = rs.getString("title");
                String extension = FileUtil.getExtension((String)title);
                this.runSQL("update DLFileEntry set extension = '" + extension + "' where uuid_ = '" + uuid_ + "' and groupId = " + groupId);
                long latestFileVersionId = 0L;
                List<Long> fileVersionIds = this.getFileVersionIds(folderId, name);
                if (!fileVersionIds.isEmpty()) {
                    latestFileVersionId = fileVersionIds.get(0);
                }
                Iterator iterator = tableIds.iterator();
                while (iterator.hasNext()) {
                    long tableId = (Long)iterator.next();
                    this.runSQL("update ExpandoRow set classPK = " + latestFileVersionId + " where tableId = " + tableId + " and classPK = " + fileEntryId);
                    this.runSQL("update ExpandoValue set classPK = " + latestFileVersionId + " where tableId = " + tableId + " and classPK = " + fileEntryId);
                }
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
    }

    protected void updateFileVersion(long fileVersionId, String extension, String title, String description, String extraSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DLFileVersion set extension = ?, title = ?, description = ?, extraSettings = ? where fileVersionId = ?");
            ps.setString(1, extension);
            ps.setString(2, title);
            ps.setString(3, description);
            ps.setString(4, extraSettings);
            ps.setLong(5, fileVersionId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateFileVersions() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select folderId, name, extension, title, description, extraSettings from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String extension = rs.getString("extension");
                String title = rs.getString("title");
                String description = rs.getString("description");
                String extraSettings = rs.getString("extraSettings");
                List<Long> fileVersionIds = this.getFileVersionIds(folderId, name);
                for (long fileVersionId : fileVersionIds) {
                    this.updateFileVersion(fileVersionId, extension, title, description, extraSettings);
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

