/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.net.HttpURLConnection;
import java.net.URL;

public class BrowserLauncher
implements Runnable {
    private static final String[] _BROWSERS = new String[]{"firefox", "mozilla", "konqueror", "opera"};

    public void run() {
        if (Validator.isNull((String)PropsValues.BROWSER_LAUNCHER_URL)) {
            return;
        }
        int i2 = 0;
        while (i2 < 5) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
            try {
                URL url = new URL(PropsValues.BROWSER_LAUNCHER_URL);
                HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
                int responseCode = urlc.getResponseCode();
                if (responseCode == 200) {
                    try {
                        this.launchBrowser();
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            catch (Exception exception) {}
            ++i2;
        }
    }

    protected void launchBrowser() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        if (OSDetector.isApple()) {
            this.launchBrowserApple(runtime);
        } else if (OSDetector.isWindows()) {
            this.launchBrowserWindows(runtime);
        } else {
            this.launchBrowserUnix(runtime);
        }
    }

    protected void launchBrowserApple(Runtime runtime) throws Exception {
        runtime.exec("open " + PropsValues.BROWSER_LAUNCHER_URL);
    }

    protected void launchBrowserUnix(Runtime runtime) throws Exception {
        if (_BROWSERS.length == 0) {
            runtime.exec(new String[]{"sh", "-c", ""});
        }
        StringBundler sb = new StringBundler(_BROWSERS.length * 5 - 1);
        int i2 = 0;
        while (i2 < _BROWSERS.length) {
            if (i2 != 0) {
                sb.append(" || ");
            }
            sb.append(_BROWSERS[i2]);
            sb.append(" \"");
            sb.append(PropsValues.BROWSER_LAUNCHER_URL);
            sb.append("\" ");
            ++i2;
        }
        runtime.exec(new String[]{"sh", "-c", sb.toString()});
    }

    protected void launchBrowserWindows(Runtime runtime) throws Exception {
        runtime.exec("cmd.exe /c start " + PropsValues.BROWSER_LAUNCHER_URL);
    }
}

