/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.lock.LockListener;
import com.liferay.portal.kernel.lock.LockListenerRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.util.PropsUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LockListenerRegistryImpl
implements LockListenerRegistry {
    private static Log _log = LogFactoryUtil.getLog(LockListenerRegistryImpl.class);
    private Map<String, LockListener> _lockListeners = new ConcurrentHashMap<String, LockListener>();

    public LockListenerRegistryImpl() {
        String[] lockListenerClassNames;
        String[] stringArray = lockListenerClassNames = PropsUtil.getArray("lock.listeners");
        int n = lockListenerClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String lockListenerClassName = stringArray[n2];
            try {
                LockListener lockListener = (LockListener)InstanceFactory.newInstance((String)lockListenerClassName);
                this.register(lockListener);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            ++n2;
        }
    }

    public LockListener getLockListener(String className) {
        return this._lockListeners.get(className);
    }

    public void register(LockListener lockListener) {
        this._lockListeners.put(lockListener.getClassName(), lockListener);
    }

    public void unregister(LockListener lockListener) {
        this._lockListeners.remove(lockListener.getClassName());
    }
}

