/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.mozilla.javascript.ErrorReporter;
import com.yahoo.platform.yui.mozilla.javascript.EvaluatorException;
import java.io.Reader;
import java.io.Writer;

public class MinifierUtil {
    private static Log _log = LogFactoryUtil.getLog(MinifierUtil.class);
    private static MinifierUtil _instance = new MinifierUtil();

    public static String minifyCss(String content) {
        return _instance._minifyCss(content);
    }

    public static String minifyJavaScript(String content) {
        return _instance._minifyJavaScript(content);
    }

    private MinifierUtil() {
    }

    private String _minifyCss(String content) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            CssCompressor cssCompressor = new CssCompressor((Reader)new UnsyncStringReader(content));
            cssCompressor.compress((Writer)unsyncStringWriter, PropsValues.YUI_COMPRESSOR_CSS_LINE_BREAK);
        }
        catch (Exception exception) {
            _log.error((Object)("CSS Minifier failed for\n" + content));
            unsyncStringWriter.append((CharSequence)content);
        }
        return unsyncStringWriter.toString();
    }

    private String _minifyJavaScript(String content) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            JavaScriptCompressor javaScriptCompressor = new JavaScriptCompressor((Reader)new UnsyncStringReader(content), (ErrorReporter)new JavaScriptErrorReporter());
            javaScriptCompressor.compress((Writer)unsyncStringWriter, PropsValues.YUI_COMPRESSOR_JS_LINE_BREAK, PropsValues.YUI_COMPRESSOR_JS_MUNGE, PropsValues.YUI_COMPRESSOR_JS_VERBOSE, PropsValues.YUI_COMPRESSOR_JS_PRESERVE_ALL_SEMICOLONS, PropsValues.YUI_COMPRESSOR_JS_DISABLE_OPTIMIZATIONS);
        }
        catch (Exception exception) {
            _log.error((Object)("JavaScript Minifier failed for\n" + content));
            unsyncStringWriter.append((CharSequence)content);
        }
        return unsyncStringWriter.toString();
    }

    private class JavaScriptErrorReporter
    implements ErrorReporter {
        private JavaScriptErrorReporter() {
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                _log.error((Object)message);
            } else {
                _log.error((Object)(String.valueOf(line) + ": " + lineOffset + ": " + message));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (!_log.isWarnEnabled()) {
                return;
            }
            if (line < 0) {
                _log.warn((Object)message);
            } else {
                _log.warn((Object)(String.valueOf(line) + ": " + lineOffset + ": " + message));
            }
        }
    }
}

