/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactory;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Date;

public class OrderByComparatorFactoryImpl
implements OrderByComparatorFactory {
    public OrderByComparator create(String tableName, Object ... columns) {
        if (columns.length == 0 || columns.length % 2 != 0) {
            throw new IllegalArgumentException("Columns length is not an even number");
        }
        return new DefaultOrderByComparator(tableName, columns);
    }

    protected class DefaultOrderByComparator
    extends OrderByComparator {
        private static final String _ORDER_BY_ASC = " ASC";
        private static final String _ORDER_BY_DESC = " DESC";
        private Object[] _columns;
        private String _tableName;

        public int compare(Object object1, Object object2) {
            int i2 = 0;
            while (i2 < this._columns.length) {
                Comparable columnValueComparable2;
                Comparable columnValueComparable1;
                int value;
                String columnName = String.valueOf(this._columns[i2]);
                boolean columnAscending = Boolean.valueOf(String.valueOf(this._columns[i2 + 1]));
                Class columnClass = BeanPropertiesUtil.getObjectTypeSilent((Object)object1, (String)columnName);
                Object columnInstance = null;
                try {
                    columnInstance = columnClass.newInstance();
                }
                catch (Exception exception) {}
                Object columnValue1 = BeanPropertiesUtil.getObjectSilent((Object)object1, (String)columnName);
                Object columnValue2 = BeanPropertiesUtil.getObjectSilent((Object)object2, (String)columnName);
                if (columnInstance instanceof Date) {
                    Date columnValueDate1 = (Date)columnValue1;
                    Date columnValueDate2 = (Date)columnValue2;
                    value = DateUtil.compareTo((Date)columnValueDate1, (Date)columnValueDate2);
                    if (value != 0) {
                        if (columnAscending) {
                            return value;
                        }
                        return -value;
                    }
                } else if (columnInstance instanceof Comparable && (value = (columnValueComparable1 = (Comparable)columnValue1).compareTo(columnValueComparable2 = (Comparable)columnValue2)) != 0) {
                    if (columnAscending) {
                        return value;
                    }
                    return -value;
                }
                i2 += 2;
            }
            return 0;
        }

        public String getOrderBy() {
            StringBundler sb = new StringBundler();
            int i2 = 0;
            while (i2 < this._columns.length) {
                if (i2 != 0) {
                    sb.append(",");
                }
                sb.append(this._tableName);
                sb.append(".");
                String columnName = String.valueOf(this._columns[i2]);
                boolean columnAscending = Boolean.valueOf(String.valueOf(this._columns[i2 + 1]));
                sb.append(columnName);
                if (columnAscending) {
                    sb.append(_ORDER_BY_ASC);
                } else {
                    sb.append(_ORDER_BY_DESC);
                }
                i2 += 2;
            }
            return sb.toString();
        }

        public boolean isAscending(String field) {
            String orderBy = this.getOrderBy();
            if (orderBy == null) {
                return false;
            }
            int x = orderBy.indexOf("." + field + " ");
            if (x == -1) {
                return false;
            }
            int y = orderBy.indexOf(_ORDER_BY_ASC, x);
            if (y == -1) {
                return false;
            }
            int z = orderBy.indexOf(_ORDER_BY_DESC, x);
            return z < 0 || z >= y;
        }

        private DefaultOrderByComparator(String tableName, Object ... columns) {
            this._tableName = tableName;
            this._columns = columns;
        }
    }
}

