/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.velocity.VelocityResourceListener;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ClassLoaderVelocityResourceListener
extends VelocityResourceListener {
    private static Log _log = LogFactoryUtil.getLog(ClassLoaderVelocityResourceListener.class);

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        try {
            return this.doGetResourceStream(source);
        }
        catch (Exception exception) {
            throw new ResourceNotFoundException(source);
        }
    }

    protected InputStream doGetResourceStream(String source) throws Exception {
        if (source.contains("_JOURNAL_CONTEXT_") || source.contains("_SERVLET_CONTEXT_") || source.contains("_THEME_LOADER_CONTEXT_")) {
            return null;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        return classLoader.getResourceAsStream(source);
    }
}

