/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.velocity.VelocityResourceListener;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;

public class JournalTemplateVelocityResourceListener
extends VelocityResourceListener {
    private static final String _SOURCE_PREFIX = "_JOURNAL_CONTEXT_".concat("/");
    private static Log _log = LogFactoryUtil.getLog(JournalTemplateVelocityResourceListener.class);

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        try {
            return this.doGetResourceStream(source);
        }
        catch (Exception exception) {
            throw new ResourceNotFoundException(source);
        }
    }

    protected InputStream doGetResourceStream(String source) throws Exception {
        int pos = source.indexOf(_SOURCE_PREFIX);
        if (pos == -1) {
            return null;
        }
        int x = source.indexOf(47, pos);
        int y = source.indexOf(47, x + 1);
        int z = source.indexOf(47, y + 1);
        long companyId = GetterUtil.getLong((String)source.substring(x + 1, y));
        long groupId = GetterUtil.getLong((String)source.substring(y + 1, z));
        String templateId = source.substring(z + 1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading {companyId=" + companyId + ", groupId=" + groupId + ", templateId=" + templateId + "}"));
        }
        JournalTemplate journalTemplate = JournalTemplateLocalServiceUtil.getTemplate((long)groupId, (String)templateId);
        String xsl = journalTemplate.getXsl();
        return new UnsyncByteArrayInputStream(xsl.getBytes());
    }
}

