/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.velocity.VelocityResourceListener;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class LiferayResourceLoader
extends ResourceLoader {
    private static Log _log = LogFactoryUtil.getLog(LiferayResourceLoader.class);
    private static VelocityResourceListener[] _velocityResourceListeners = new VelocityResourceListener[0];

    public static void setVelocityResourceListeners(String[] velocityResourceListeners) {
        _velocityResourceListeners = new VelocityResourceListener[velocityResourceListeners.length];
        int i2 = 0;
        while (i2 < velocityResourceListeners.length) {
            try {
                Class<?> clazz = Class.forName(velocityResourceListeners[i2]);
                LiferayResourceLoader._velocityResourceListeners[i2] = (VelocityResourceListener)clazz.newInstance();
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
                LiferayResourceLoader._velocityResourceListeners[i2] = null;
            }
            ++i2;
        }
    }

    public long getLastModified(Resource resource) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get last modified for " + resource.getName()));
        }
        return 0L;
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        InputStream is = this.doGetResourceStream(source);
        if (is == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Could not find " + source));
            }
            throw new ResourceNotFoundException(source);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Successfully got " + source));
        }
        return is;
    }

    public void init(ExtendedProperties props) {
        this.setModificationCheckInterval(PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_MODIFICATION_CHECK_INTERVAL);
    }

    public boolean isSourceModified(Resource resource) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Check modified status for " + resource.getName()));
        }
        return false;
    }

    public boolean resourceExists(String resourceName) {
        InputStream is = null;
        try {
            is = this.doGetResourceStream(resourceName);
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (ResourceNotFoundException resourceNotFoundException) {}
        return is != null;
    }

    protected InputStream doGetResourceStream(String source) throws ResourceNotFoundException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get resource for " + source));
        }
        InputStream is = null;
        int i2 = 0;
        while (is == null && i2 < _velocityResourceListeners.length) {
            VelocityResourceListener velocityResourceListener = _velocityResourceListeners[i2];
            if (velocityResourceListener != null) {
                is = velocityResourceListener.getResourceStream(source);
            }
            ++i2;
        }
        return is;
    }
}

