/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.velocity.VelocityResourceListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ThemeLoaderVelocityResourceListener
extends VelocityResourceListener {
    private static Log _log = LogFactoryUtil.getLog(ThemeLoaderVelocityResourceListener.class);

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        try {
            return this.doGetResourceStream(source);
        }
        catch (Exception exception) {
            throw new ResourceNotFoundException(source);
        }
    }

    protected InputStream doGetResourceStream(String source) throws Exception {
        String themesPath;
        int pos = source.indexOf("_THEME_LOADER_CONTEXT_");
        if (pos == -1) {
            return null;
        }
        String servletContextName = source.substring(0, pos);
        ThemeLoader themeLoader = ThemeLoaderFactory.getThemeLoader(servletContextName);
        if (themeLoader == null) {
            _log.error((Object)(String.valueOf(source) + " is not valid because " + servletContextName + " does not map to a theme loader"));
            return null;
        }
        String name = source.substring(pos + "_THEME_LOADER_CONTEXT_".length());
        if (name.startsWith(themesPath = themeLoader.getThemesPath())) {
            name = name.substring(themesPath.length());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(name) + " is associated with the theme loader " + servletContextName + " " + themeLoader));
        }
        File fileStorage = themeLoader.getFileStorage();
        return new FileInputStream(String.valueOf(fileStorage.getPath()) + name);
    }
}

