/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngine;
import com.liferay.portal.kernel.velocity.VelocityVariablesUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.velocity.FastExtendedProperties;
import com.liferay.portal.velocity.LiferayMethodExceptionEventHandler;
import com.liferay.portal.velocity.LiferayResourceCacheUtil;
import com.liferay.portal.velocity.LiferayResourceLoader;
import com.liferay.portal.velocity.PACLVelocityContextImpl;
import com.liferay.portal.velocity.StringResourceRepositoryImpl;
import com.liferay.portal.velocity.VelocityContextImpl;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;

public class VelocityEngineImpl
implements VelocityEngine {
    private static final String _RESOURCE_LOADER = "resource.loader";
    private static final String _RESOURCE_TEMPLATE_NAME_SPACE = String.valueOf(1);
    private static Log _log = LogFactoryUtil.getLog(VelocityEngineImpl.class);
    private Map<ClassLoader, VelocityContextImpl> _classLoaderVelocityContexts = new ConcurrentHashMap<ClassLoader, VelocityContextImpl>();
    private VelocityContextImpl _restrictedToolsContext;
    private VelocityContextImpl _standardToolsContext;
    private org.apache.velocity.app.VelocityEngine _velocityEngine;

    public void clearClassLoader(ClassLoader classLoader) {
        this._classLoaderVelocityContexts.remove(classLoader);
    }

    public void flushTemplate(String velocityTemplateId) {
        StringResourceRepository stringResourceRepository = StringResourceLoader.getRepository();
        if (stringResourceRepository != null) {
            stringResourceRepository.removeStringResource(velocityTemplateId);
        }
        LiferayResourceCacheUtil.remove(this._getResourceCacheKey(velocityTemplateId));
    }

    public VelocityContext getEmptyContext() {
        return new VelocityContextImpl();
    }

    public VelocityContext getRestrictedToolsContext() {
        return this._restrictedToolsContext;
    }

    public VelocityContext getStandardToolsContext() {
        return this._standardToolsContext;
    }

    public VelocityContext getWrappedClassLoaderToolsContext() {
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        PACLPolicy threadLocalPACLPolicy = PortalSecurityManagerThreadLocal.getPACLPolicy();
        PACLPolicy contextClassLoaderPACLPolicy = PACLPolicyManager.getPACLPolicy(contextClassLoader);
        try {
            PortalSecurityManagerThreadLocal.setPACLPolicy(contextClassLoaderPACLPolicy);
            VelocityContextImpl velocityContextImpl = this._classLoaderVelocityContexts.get(contextClassLoader);
            if (velocityContextImpl == null) {
                velocityContextImpl = new VelocityContextImpl();
                VelocityVariablesUtil.insertHelperUtilities((VelocityContext)velocityContextImpl, null);
                this._classLoaderVelocityContexts.put(contextClassLoader, velocityContextImpl);
            }
            PACLVelocityContextImpl pACLVelocityContextImpl = new PACLVelocityContextImpl(velocityContextImpl.getWrappedVelocityContext(), contextClassLoaderPACLPolicy);
            return pACLVelocityContextImpl;
        }
        finally {
            PortalSecurityManagerThreadLocal.setPACLPolicy(threadLocalPACLPolicy);
        }
    }

    public VelocityContext getWrappedRestrictedToolsContext() {
        return new VelocityContextImpl(this._restrictedToolsContext.getWrappedVelocityContext());
    }

    public VelocityContext getWrappedStandardToolsContext() {
        return new VelocityContextImpl(this._standardToolsContext.getWrappedVelocityContext());
    }

    public void init() throws Exception {
        if (this._velocityEngine != null) {
            return;
        }
        this._velocityEngine = new org.apache.velocity.app.VelocityEngine();
        LiferayResourceLoader.setVelocityResourceListeners(PropsValues.VELOCITY_ENGINE_RESOURCE_LISTENERS);
        FastExtendedProperties extendedProperties = new FastExtendedProperties();
        extendedProperties.setProperty("eventhandler.methodexception.class", LiferayMethodExceptionEventHandler.class.getName());
        extendedProperties.setProperty("introspector.restrict.classes", StringUtil.merge((Object[])PropsValues.VELOCITY_ENGINE_RESTRICTED_CLASSES));
        extendedProperties.setProperty("introspector.restrict.packages", StringUtil.merge((Object[])PropsValues.VELOCITY_ENGINE_RESTRICTED_PACKAGES));
        extendedProperties.setProperty(_RESOURCE_LOADER, "string,servlet");
        extendedProperties.setProperty("string.resource.loader.cache", String.valueOf(PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_CACHE_ENABLED));
        extendedProperties.setProperty("string.resource.loader.class", StringResourceLoader.class.getName());
        extendedProperties.setProperty("string.resource.loader.repository.class", StringResourceRepositoryImpl.class.getName());
        extendedProperties.setProperty("servlet.resource.loader.cache", String.valueOf(PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_CACHE_ENABLED));
        extendedProperties.setProperty("servlet.resource.loader.class", LiferayResourceLoader.class.getName());
        extendedProperties.setProperty("resource.manager.class", PropsUtil.get("velocity.engine.resource.manager"));
        extendedProperties.setProperty("resource.manager.cache.class", PropsUtil.get("velocity.engine.resource.manager.cache"));
        extendedProperties.setProperty("velocimacro.library", PropsUtil.get("velocity.engine.velocimacro.library"));
        extendedProperties.setProperty("velocimacro.library.autoreload", String.valueOf(!PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_CACHE_ENABLED));
        extendedProperties.setProperty("velocimacro.permissions.allow.inline.to.replace.global", String.valueOf(!PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_CACHE_ENABLED));
        extendedProperties.setProperty("runtime.log.logsystem.class", PropsUtil.get("velocity.engine.logger"));
        extendedProperties.setProperty("runtime.log.logsystem.log4j.category", PropsUtil.get("velocity.engine.logger.category"));
        this._velocityEngine.setExtendedProperties((ExtendedProperties)extendedProperties);
        this._velocityEngine.init();
        this._restrictedToolsContext = new VelocityContextImpl();
        VelocityVariablesUtil.insertHelperUtilities((VelocityContext)this._restrictedToolsContext, (String[])PropsValues.JOURNAL_TEMPLATE_VELOCITY_RESTRICTED_VARIABLES);
        this._standardToolsContext = new VelocityContextImpl();
        VelocityVariablesUtil.insertHelperUtilities((VelocityContext)this._standardToolsContext, null);
    }

    public boolean mergeTemplate(String velocityTemplateId, String velocityTemplateContent, VelocityContext velocityContext, Writer writer) throws Exception {
        if (Validator.isNotNull((String)velocityTemplateContent)) {
            LiferayResourceCacheUtil.remove(this._getResourceCacheKey(velocityTemplateId));
            StringResourceRepository stringResourceRepository = StringResourceLoader.getRepository();
            stringResourceRepository.putStringResource(velocityTemplateId, velocityTemplateContent);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added " + velocityTemplateId + " to the Velocity template repository"));
            }
        }
        VelocityContextImpl velocityContextImpl = (VelocityContextImpl)velocityContext;
        PACLPolicy threadLocalPACLPolicy = PortalSecurityManagerThreadLocal.getPACLPolicy();
        try {
            if (velocityContextImpl instanceof PACLVelocityContextImpl) {
                PACLVelocityContextImpl paclContextImpl = (PACLVelocityContextImpl)velocityContextImpl;
                PortalSecurityManagerThreadLocal.setPACLPolicy(paclContextImpl.getPaclPolicy());
            }
            boolean bl = this._velocityEngine.mergeTemplate(velocityTemplateId, "UTF-8", (Context)velocityContextImpl.getWrappedVelocityContext(), writer);
            return bl;
        }
        finally {
            if (velocityContextImpl instanceof PACLVelocityContextImpl) {
                PortalSecurityManagerThreadLocal.setPACLPolicy(threadLocalPACLPolicy);
            }
        }
    }

    public boolean mergeTemplate(String velocityTemplateId, VelocityContext velocityContext, Writer writer) throws Exception {
        return this.mergeTemplate(velocityTemplateId, null, velocityContext, writer);
    }

    public boolean resourceExists(String resource) {
        return this._velocityEngine.resourceExists(resource);
    }

    private String _getResourceCacheKey(String velocityTemplateId) {
        return _RESOURCE_TEMPLATE_NAME_SPACE.concat(velocityTemplateId);
    }
}

