/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class VerifyDocumentLibrary
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyDocumentLibrary.class);

    protected void addDLFileVersion(DLFileEntry dlFileEntry) throws SystemException {
        long fileVersionId = CounterLocalServiceUtil.increment();
        DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.createDLFileVersion((long)fileVersionId);
        dlFileVersion.setGroupId(dlFileEntry.getGroupId());
        dlFileVersion.setCompanyId(dlFileEntry.getCompanyId());
        long versionUserId = dlFileEntry.getVersionUserId();
        if (versionUserId <= 0L) {
            versionUserId = dlFileEntry.getUserId();
        }
        dlFileVersion.setUserId(versionUserId);
        String versionUserName = GetterUtil.getString((String)dlFileEntry.getVersionUserName(), (String)dlFileEntry.getUserName());
        dlFileVersion.setUserName(versionUserName);
        dlFileVersion.setCreateDate(dlFileEntry.getModifiedDate());
        dlFileVersion.setModifiedDate(dlFileEntry.getModifiedDate());
        dlFileVersion.setRepositoryId(dlFileEntry.getRepositoryId());
        dlFileVersion.setFolderId(dlFileEntry.getFolderId());
        dlFileVersion.setFileEntryId(dlFileEntry.getFileEntryId());
        dlFileVersion.setExtension(dlFileEntry.getExtension());
        dlFileVersion.setMimeType(dlFileEntry.getMimeType());
        dlFileVersion.setTitle(dlFileEntry.getTitle());
        dlFileVersion.setDescription(dlFileEntry.getDescription());
        dlFileVersion.setExtraSettings(dlFileEntry.getExtraSettings());
        dlFileVersion.setFileEntryTypeId(dlFileEntry.getFileEntryTypeId());
        dlFileVersion.setVersion(dlFileEntry.getVersion());
        dlFileVersion.setSize(dlFileEntry.getSize());
        dlFileVersion.setStatus(0);
        dlFileVersion.setStatusByUserId(versionUserId);
        dlFileVersion.setStatusByUserName(versionUserName);
        dlFileVersion.setStatusDate(new Date());
        DLFileVersionLocalServiceUtil.updateDLFileVersion((DLFileVersion)dlFileVersion);
    }

    protected void checkDLFileEntryType() throws Exception {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)0L);
        if (dlFileEntryType != null) {
            return;
        }
        Date now = new Date();
        dlFileEntryType = DLFileEntryTypeLocalServiceUtil.createDLFileEntryType((long)0L);
        dlFileEntryType.setCreateDate(now);
        dlFileEntryType.setModifiedDate(now);
        dlFileEntryType.setName("Basic Document");
        DLFileEntryTypeLocalServiceUtil.updateDLFileEntryType((DLFileEntryType)dlFileEntryType);
    }

    protected void checkMimeTypes() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getFileEntriesByMimeType((String)"application/octet-stream");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with " + "application/octet-stream"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            String title;
            InputStream inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)dlFileEntry.getUserId(), (long)dlFileEntry.getFileEntryId(), (String)dlFileEntry.getVersion(), (boolean)false);
            String mimeType = MimeTypesUtil.getContentType((InputStream)inputStream, (String)(title = DLUtil.getTitleWithExtension((String)dlFileEntry.getTitle(), (String)dlFileEntry.getExtension())));
            if (mimeType.equals("application/octet-stream")) continue;
            dlFileEntry.setMimeType(mimeType);
            DLFileEntryLocalServiceUtil.updateDLFileEntry((DLFileEntry)dlFileEntry);
            DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
            dlFileVersion.setMimeType(mimeType);
            DLFileVersionLocalServiceUtil.updateDLFileVersion((DLFileVersion)dlFileVersion);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Fixed file entries with invalid mime types");
        }
    }

    protected void checkMisversionedDLFileEntries() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getMisversionedFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with invalid version"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            this.copyDLFileEntry(dlFileEntry);
            this.addDLFileVersion(dlFileEntry);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Fixed misversioned file entries");
        }
    }

    protected void copyDLFileEntry(DLFileEntry dlFileEntry) throws PortalException, SystemException {
        String version;
        String name;
        long dataRepositoryId;
        long companyId = dlFileEntry.getCompanyId();
        if (DLStoreUtil.hasFile((long)companyId, (long)(dataRepositoryId = dlFileEntry.getDataRepositoryId()), (String)(name = dlFileEntry.getName()), (String)(version = dlFileEntry.getVersion()))) {
            return;
        }
        FileVersionVersionComparator comparator = new FileVersionVersionComparator();
        List dlFileVersions = dlFileEntry.getFileVersions(0);
        if (dlFileVersions.isEmpty()) {
            dlFileVersions = dlFileEntry.getFileVersions(-1);
        }
        if (dlFileVersions.isEmpty()) {
            DLStoreUtil.addFile((long)companyId, (long)dataRepositoryId, (String)name, (byte[])new byte[0]);
            return;
        }
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, comparator);
        DLFileVersion dlFileVersion = (DLFileVersion)dlFileVersions.get(0);
        DLStoreUtil.copyFileVersion((long)companyId, (long)dataRepositoryId, (String)name, (String)dlFileVersion.getVersion(), (String)version);
    }

    protected void doVerify() throws Exception {
        this.checkMisversionedDLFileEntries();
        this.checkDLFileEntryType();
        this.checkMimeTypes();
        this.removeOrphanedDLFileEntries();
        this.updateAssets();
    }

    protected void removeOrphanedDLFileEntries() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getOrphanedFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no group"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            try {
                DLFileEntryLocalServiceUtil.deleteFileEntry((long)dlFileEntry.getFileEntryId());
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to remove file entry " + dlFileEntry.getFileEntryId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Removed orphaned file entries");
        }
    }

    protected void updateAssets() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getNoAssetFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no asset"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileEntry.getFileVersion());
            try {
                DLAppHelperLocalServiceUtil.updateAsset((long)dlFileEntry.getUserId(), (FileEntry)fileEntry, (FileVersion)fileVersion, null, null, null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for file entry " + dlFileEntry.getFileEntryId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for file entries");
        }
    }
}

