/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalContentSearch;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import javax.portlet.PortletPreferences;

public class VerifyJournal
extends VerifyProcess {
    public static final long DEFAULT_GROUP_ID = 14L;
    public static final int NUM_OF_ARTICLES = 5;
    private static Log _log = LogFactoryUtil.getLog(VerifyJournal.class);

    protected void doVerify() throws Exception {
        this.verifyOracleNewLine();
        List structures = JournalStructureLocalServiceUtil.getStructures();
        for (JournalStructure structure : structures) {
            ResourceLocalServiceUtil.addResources((long)structure.getCompanyId(), (long)0L, (long)0L, (String)JournalStructure.class.getName(), (long)structure.getId(), (boolean)false, (boolean)false, (boolean)false);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Permissions verified for structures");
        }
        List templates = JournalTemplateLocalServiceUtil.getTemplates();
        for (JournalTemplate template : templates) {
            ResourceLocalServiceUtil.addResources((long)template.getCompanyId(), (long)0L, (long)0L, (String)JournalTemplate.class.getName(), (long)template.getId(), (boolean)false, (boolean)false, (boolean)false);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Permissions verified for templates");
        }
        List articles = JournalArticleLocalServiceUtil.getArticles();
        for (JournalArticle article : articles) {
            String structureId;
            double version;
            String articleId;
            long groupId;
            block12: {
                groupId = article.getGroupId();
                articleId = article.getArticleId();
                version = article.getVersion();
                structureId = article.getStructureId();
                if (article.getResourcePrimKey() <= 0L) {
                    article = JournalArticleLocalServiceUtil.checkArticleResourcePrimKey((long)groupId, (String)articleId, (double)version);
                }
                ResourceLocalServiceUtil.addResources((long)article.getCompanyId(), (long)0L, (long)0L, (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (boolean)false, (boolean)false, (boolean)false);
                try {
                    AssetEntryLocalServiceUtil.getEntry((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
                }
                catch (NoSuchEntryException noSuchEntryException) {
                    try {
                        JournalArticleLocalServiceUtil.updateAsset((long)article.getUserId(), (JournalArticle)article, null, null, null);
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Object)("Unable to update asset for article " + article.getId() + ": " + e2.getMessage()));
                    }
                }
            }
            String content = GetterUtil.getString((String)article.getContent());
            String newContent = HtmlUtil.replaceMsWordCharacters((String)content);
            Validator.isNotNull((String)structureId);
            if (!content.equals(newContent)) {
                JournalArticleLocalServiceUtil.updateContent((long)groupId, (String)articleId, (double)version, (String)newContent);
            }
            JournalArticleLocalServiceUtil.checkStructure((long)groupId, (String)articleId, (double)version);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Permissions and assets verified for articles");
        }
        this.verifyContentSearch();
    }

    protected void verifyContentSearch() throws Exception {
        List contentSearches = JournalContentSearchLocalServiceUtil.getArticleContentSearches();
        for (JournalContentSearch contentSearch : contentSearches) {
            this.verifyContentSearch(contentSearch);
        }
    }

    protected void verifyContentSearch(JournalContentSearch contentSearch) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select preferences from PortletPreferences where portletId = ?");
            ps.setString(1, contentSearch.getPortletId());
            rs = ps.executeQuery();
            while (rs.next()) {
                String xml = rs.getString("preferences");
                PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)xml);
                String articleId = portletPreferences.getValue("articleId", null);
                JournalContentSearchLocalServiceUtil.updateContentSearch((long)contentSearch.getGroupId(), (boolean)contentSearch.isPrivateLayout(), (long)contentSearch.getLayoutId(), (String)contentSearch.getPortletId(), (String)articleId, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void verifyOracleNewLine() throws Exception {
        JournalTemplate template;
        String xsl;
        List templates;
        JournalStructure structure;
        String xsd;
        List structures;
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("oracle")) {
            return;
        }
        boolean checkNewLine = false;
        List articles = JournalArticleLocalServiceUtil.getArticles((long)14L, (int)0, (int)5);
        for (JournalArticle article : articles) {
            String content = article.getContent();
            if (content == null || content.indexOf("\\n") == -1) continue;
            articles = JournalArticleLocalServiceUtil.getArticles((long)14L);
            int j = 0;
            while (j < articles.size()) {
                article = (JournalArticle)articles.get(j);
                JournalArticleLocalServiceUtil.checkNewLine((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion());
                ++j;
            }
            checkNewLine = true;
            break;
        }
        if (!checkNewLine) {
            if (_log.isInfoEnabled()) {
                _log.debug((Object)"Do not fix oracle new line");
            }
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Fix oracle new line");
        }
        if ((structures = JournalStructureLocalServiceUtil.getStructures((long)14L, (int)0, (int)1)).size() == 1 && (xsd = (structure = (JournalStructure)structures.get(0)).getXsd()) != null && xsd.indexOf("\\n") != -1) {
            structures = JournalStructureLocalServiceUtil.getStructures((long)14L);
            int i2 = 0;
            while (i2 < structures.size()) {
                structure = (JournalStructure)structures.get(i2);
                JournalStructureLocalServiceUtil.checkNewLine((long)structure.getGroupId(), (String)structure.getStructureId());
                ++i2;
            }
        }
        if ((templates = JournalTemplateLocalServiceUtil.getTemplates((long)14L, (int)0, (int)1)).size() == 1 && (xsl = (template = (JournalTemplate)templates.get(0)).getXsl()) != null && xsl.indexOf("\\n") != -1) {
            templates = JournalTemplateLocalServiceUtil.getTemplates((long)14L);
            int i3 = 0;
            while (i3 < templates.size()) {
                template = (JournalTemplate)templates.get(i3);
                JournalTemplateLocalServiceUtil.checkNewLine((long)template.getGroupId(), (String)template.getTemplateId());
                ++i3;
            }
        }
    }
}

