/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class VerifyOracle
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyOracle.class);

    protected void alterColumns() throws Exception {
        int buildNumber = this.getBuildNumber();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select table_name, column_name, data_length from user_tab_columns where data_type = 'VARCHAR2' and char_used = 'B'");
            rs = ps.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                String columnName = rs.getString(2);
                int dataLength = rs.getInt(3);
                if (buildNumber >= 5209 && buildNumber < 6120 && dataLength != 4000) {
                    dataLength /= 4;
                }
                try {
                    this.runSQL("alter table " + tableName + " modify " + columnName + " varchar2(" + dataLength + " char)");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == 1441) {
                        if (!_log.isWarnEnabled()) continue;
                        StringBundler sb = new StringBundler(6);
                        sb.append("Unable to alter length of column ");
                        sb.append(columnName);
                        sb.append(" for table ");
                        sb.append(tableName);
                        sb.append("because it contains values that are ");
                        sb.append("larger than the new column length");
                        _log.warn((Object)sb.toString());
                        continue;
                    }
                    throw sqle;
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void doVerify() throws Exception {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("oracle")) {
            return;
        }
        this.alterColumns();
    }
}

