/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.staging.StagingAdvicesThreadLocal;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;

public class VerifyProcessUtil {
    private static Log _log = LogFactoryUtil.getLog(VerifyProcessUtil.class);

    public static boolean verifyProcess(boolean ranUpgradeProcess, boolean verified) throws VerifyException {
        int verifyFrequency = GetterUtil.getInteger((String)PropsUtil.get("verify.frequency"));
        if (verifyFrequency == -1 || verifyFrequency == 1 && !verified || ranUpgradeProcess) {
            return VerifyProcessUtil._verifyProcess(ranUpgradeProcess);
        }
        return false;
    }

    private static boolean _verifyProcess(boolean ranUpgradeProcess) throws VerifyException {
        boolean ranVerifyProcess = false;
        if (ranUpgradeProcess && PropsValues.INDEX_ON_UPGRADE) {
            PropsUtil.set("index.on.startup", Boolean.TRUE.toString());
            PropsValues.INDEX_ON_STARTUP = true;
        }
        boolean tempIndexReadOnly = SearchEngineUtil.isIndexReadOnly();
        SearchEngineUtil.setIndexReadOnly((boolean)true);
        BatchSessionUtil.setEnabled((boolean)true);
        NotificationThreadLocal.setEnabled((boolean)false);
        StagingAdvicesThreadLocal.setEnabled(false);
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            String[] verifyProcessClassNames;
            String[] stringArray = verifyProcessClassNames = PropsUtil.getArray("verify.processes");
            int n = verifyProcessClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String verifyProcessClassName = stringArray[n2];
                boolean tempRanVerifyProcess = VerifyProcessUtil._verifyProcess(verifyProcessClassName);
                if (tempRanVerifyProcess) {
                    ranVerifyProcess = true;
                }
                ++n2;
            }
        }
        finally {
            SearchEngineUtil.setIndexReadOnly((boolean)tempIndexReadOnly);
            BatchSessionUtil.setEnabled((boolean)false);
            NotificationThreadLocal.setEnabled((boolean)true);
            StagingAdvicesThreadLocal.setEnabled(true);
            WorkflowThreadLocal.setEnabled((boolean)true);
        }
        return ranVerifyProcess;
    }

    private static boolean _verifyProcess(String verifyProcessClassName) throws VerifyException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing verification " + verifyProcessClassName));
        }
        try {
            VerifyProcess verifyProcess = (VerifyProcess)Class.forName(verifyProcessClassName).newInstance();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running verification " + verifyProcessClassName));
            }
            verifyProcess.verify();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished verification " + verifyProcessClassName));
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            _log.error((Object)(String.valueOf(verifyProcessClassName) + " cannot be found"));
        }
        catch (IllegalAccessException illegalAccessException) {
            _log.error((Object)(String.valueOf(verifyProcessClassName) + " cannot be accessed"));
        }
        catch (InstantiationException instantiationException) {
            _log.error((Object)(String.valueOf(verifyProcessClassName) + " cannot be initiated"));
        }
        return false;
    }
}

