/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.NoSuchResourcePermissionException;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ContactLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.announcements.model.AnnouncementsEntry;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class VerifyResourcePermissions
extends VerifyProcess {
    private static final String[][] _MODELS = new String[][]{{AnnouncementsEntry.class.getName(), "AnnouncementsEntry", "entryId"}, {AssetCategory.class.getName(), "AssetCategory", "categoryId"}, {AssetTag.class.getName(), "AssetTag", "tagId"}, {AssetVocabulary.class.getName(), "AssetVocabulary", "vocabularyId"}, {BlogsEntry.class.getName(), "BlogsEntry", "entryId"}, {BookmarksEntry.class.getName(), "BookmarksEntry", "entryId"}, {BookmarksFolder.class.getName(), "BookmarksFolder", "folderId"}, {CalEvent.class.getName(), "CalEvent", "eventId"}, {DDMStructure.class.getName(), "DDMStructure", "structureId"}, {DDMTemplate.class.getName(), "DDMTemplate", "templateId"}, {DLFileEntry.class.getName(), "DLFileEntry", "fileEntryId"}, {DLFileShortcut.class.getName(), "DLFileShortcut", "fileShortcutId"}, {DLFolder.class.getName(), "DLFolder", "folderId"}, {JournalArticle.class.getName(), "JournalArticle", "resourcePrimKey"}, {JournalFeed.class.getName(), "JournalFeed", "id_"}, {JournalStructure.class.getName(), "JournalStructure", "id_"}, {JournalTemplate.class.getName(), "JournalTemplate", "id_"}, {LayoutSetBranch.class.getName(), "LayoutSetBranch", "layoutSetBranchId"}, {MBCategory.class.getName(), "MBCategory", "categoryId"}, {MBMessage.class.getName(), "MBMessage", "messageId"}, {PasswordPolicy.class.getName(), "PasswordPolicy", "passwordPolicyId"}, {PollsQuestion.class.getName(), "PollsQuestion", "questionId"}, {SCFrameworkVersion.class.getName(), "SCFrameworkVersion", "frameworkVersionId"}, {SCProductEntry.class.getName(), "SCProductEntry", "productEntryId"}, {ShoppingCategory.class.getName(), "ShoppingCategory", "categoryId"}, {ShoppingItem.class.getName(), "ShoppingItem", "itemId"}, {Team.class.getName(), "Team", "teamId"}, {User.class.getName(), "User_", "userId"}, {WikiNode.class.getName(), "WikiNode", "nodeId"}, {WikiPage.class.getName(), "WikiPage", "resourcePrimKey"}};
    private static Log _log = LogFactoryUtil.getLog(VerifyResourcePermissions.class);

    protected void doVerify() throws Exception {
        long[] companyIds;
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return;
        }
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            String[][] stringArray = _MODELS;
            int n3 = _MODELS.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] model = stringArray[n4];
                this.verifyModel(role, model[0], model[1], model[2]);
                ++n4;
            }
            ++n2;
        }
    }

    protected void verifyModel(long companyId, String name, long primKey, Role role, long ownerId) throws Exception {
        ResourcePermission resourcePermission = null;
        try {
            resourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)companyId, (String)name, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId());
        }
        catch (NoSuchResourcePermissionException noSuchResourcePermissionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No resource found for {" + companyId + ", " + name + ", " + 4 + ", " + primKey + ", " + role.getRoleId() + "}"));
            }
            ResourceLocalServiceUtil.addResources((long)companyId, (long)0L, (long)ownerId, (String)name, (String)String.valueOf(primKey), (boolean)false, (boolean)false, (boolean)false);
        }
        if (resourcePermission == null) {
            try {
                resourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)companyId, (String)name, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId());
            }
            catch (NoSuchResourcePermissionException noSuchResourcePermissionException) {
                return;
            }
        }
        if (name.equals(User.class.getName())) {
            User user = UserLocalServiceUtil.getUserById((long)ownerId);
            Contact contact = ContactLocalServiceUtil.getContact((long)user.getContactId());
            ownerId = contact.getUserId();
        }
        if (ownerId != resourcePermission.getOwnerId()) {
            resourcePermission.setOwnerId(ownerId);
            ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
        }
        if (_log.isInfoEnabled() && resourcePermission.getResourcePermissionId() % 100L == 0L) {
            _log.info((Object)("Processed 100 resource permissions for " + name));
        }
    }

    protected void verifyModel(Role role, String name, String modelName, String pkColumnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + pkColumnName + ", userId AS ownerId " + "from " + modelName + " where companyId = " + role.getCompanyId());
            rs = ps.executeQuery();
            while (rs.next()) {
                long primKey = rs.getLong(pkColumnName);
                long ownerId = rs.getLong("ownerId");
                this.verifyModel(role.getCompanyId(), name, primKey, role, ownerId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

